#!/usr/bin/env python3

import os
import sys

def main():
    progress_file = os.path.abspath(os.path.join(os.path.dirname(__file__), '../Progress/progress.md'))
    if not os.path.exists(progress_file):
        print(f"Fail to find File : {progress_file}")
        sys.exit(1)
    try:
        with open(progress_file, 'r', encoding='utf-8') as f:
            lines = f.readlines()
        for line in lines[4:]:  # Skip header lines
            if line.strip().startswith('|'):
                parts = [p.strip() for p in line.split('|')[1:]]
                if len(parts) >= 6:  # Ensure we have at least the confirmed working column
                    links = parts[5] if len(parts) > 5 else ''
                    if links == 'No':
                        print(line.strip())
                        sys.exit(0)
        print("No files found that need scanning")
        sys.exit(0)
    except Exception as e:
        print(f"Error reading progress file: {str(e)}")
        sys.exit(1)

if __name__ == '__main__':
    main()