#!/bin/bash
# Startup script for PHP Migration GUI with OpenAI support

cd "$(dirname "$0")"

# Check if virtual environment exists
if [ ! -d "venv" ]; then
    echo "Creating virtual environment..."
    python3 -m venv venv
    echo "Installing OpenAI package..."
    . venv/bin/activate
    pip install openai
else
    echo "Activating virtual environment..."
    . venv/bin/activate
fi

echo "Starting PHP Migration GUI with OpenAI support..."
python3 run_me.py