# 🚀 PHP Migration System - Quick Start Guide

## 🎯 How to Run the System

### Step 1: Launch the GUI
```bash
cd Tools
python3 migration_gui.py
```

## 🔥 Quick Mode Feature

### 🔘 Toggle Quick Mode
- **Location**: Top-right corner of the GUI
- **Default**: OFF (red text)
- **When ON**: Green text, instant click-to-update

### ⚡ Quick Mode Usage

#### When Quick Mode is **OFF** (Default):
- Click files to select them
- Edit details in the right panel
- Click "Save Changes" to update database
- Traditional workflow with confirmation

#### When Quick Mode is **ON**:
- **Double-click** the **Status** column to cycle through: new → keep → archive → remove → new
- **Double-click** any ✅ or ❌ icon in these columns:
  - **PHP8** column - Toggle PHP8 rewrite completion
  - **Tested** column - Toggle testing completion
  - **Links** column - Toggle link scanning completion
- **Instant Update**: Database updates immediately
- **Visual Feedback**: Status changes instantly, status bar shows what changed
- **No Save Required**: Changes are automatic

### 🎯 Perfect for Fast Workflow

**Scenario**: You've just finished PHP8 rewriting 10 files
1. **Enable Quick Mode** (checkbox in top-right)
2. **Double-click** the ❌ in the PHP8 column for each completed file
3. **Watch** as they instantly change to ✅
4. **Double-click** Status column to change from "new" to "keep"
5. **Done!** No need to select files or click save

## 🔍 File Existence Features

### Find Missing Files
1. **Set Filter**: "Exists: missing"
2. **See Results**: Only missing files show
3. **Generate List**: Click "Missing Files List" button
4. **Collection File**: Get list of files to collect from server

### Verify All Files
1. **Click "Verify Files"** button
2. **Progress Dialog**: Shows verification in progress
3. **Results**: Shows how many files exist vs missing
4. **Auto-Update**: Database flags updated automatically

## 📊 Key Buttons Explained

| Button | Purpose | When to Use |
|--------|---------|-------------|
| **Verify Files** | Check all files exist on filesystem | After copying files from server |
| **Missing Files List** | Generate collection list | Before going to collect files |
| **Scan All Links** | Find all dependencies | To discover new referenced files |
| **Bulk Update** | Update multiple files at once | When marking many files as "keep" |
| **Generate Report** | Create progress summaries | For project status meetings |
| **Statistics** | Show current progress | To see overall completion status |

## 🎮 Workflow Examples

### Daily Migration Work (Quick Mode ON)
1. Filter by "Status: new" to see unprocessed files
2. Work on files one by one
3. Double-click Status column to cycle: new → keep (for files to migrate)
4. Double-click ❌ in PHP8 column when done → instant ✅
5. Double-click ❌ in Tested column after testing → instant ✅

### Finding Missing Dependencies
1. Click "Scan All Links" (discovers new files)
2. Set filter "Exists: missing"
3. Click "Missing Files List"
4. Use generated list to collect files from server
5. Click "Verify Files" after copying files

### Project Status Review
1. Click "Statistics" for overview
2. Click "Generate Report" → "Summary Report"
3. Review progress by folder
4. Use filters to focus on specific areas

## 💡 Pro Tips

- **Quick Mode**: Perfect for batch marking completed work
- **Filters**: Combine multiple filters (e.g., "Status: keep" + "PHP8: pending")
- **Right-Click**: Context menu for quick status changes
- **Search**: Type file names to find specific files instantly
- **Auto-Discovery**: Link scanning automatically finds new files to collect

## 🚨 Important Notes

- **Quick Mode**: Works on Status, PHP8, Tested, and Links columns
- **Status Cycling**: new → keep → archive → remove → new (cycles through all four)
- **File Exists**: Cannot be toggled (reflects actual filesystem state)
- **Auto-Save**: Quick Mode changes are immediate - no undo!
- **Backup**: Create backups before major changes

---

**Ready to use!** Launch with `python3 migration_gui.py` and toggle Quick Mode for fast updates.