# OpenAI GPT Integration Setup

## Installation

1. **Install OpenAI Package**:
   ```bash
   pip install openai
   ```

2. **Get OpenAI API Key**:
   - Go to https://platform.openai.com/api-keys
   - Create a new API key
   - Copy the key

3. **Configure API Key in Application**:
   - Launch the migration GUI: `python3 run_me.py`
   - Go to **Tools** → **Configure OpenAI API Key**
   - Paste your API key
   - Click OK

## Usage

1. **Select a PHP file** in the main file list
2. **Click the "GPT Check" button** (appears when API key is configured)
3. **Wait for analysis** (progress dialog will show)
4. **Review results** in the popup dialog
5. **Check Notes field** - GPT results are automatically saved to the top of the Notes field

## Notes Field Integration

GPT results are automatically added to the Notes field in this format:
```
*** GPT dd/mm/yy ***
YES

This PHP code appears to be compatible with both PHP 5.6 and PHP 8.x.
The code uses standard PHP functions and syntax that work across both versions.

[Previous notes appear below...]
```

- **Date Stamped**: Each analysis includes the date
- **Top Position**: New GPT results appear at the top, pushing older notes down
- **Daily Updates**: Multiple analyses on the same day replace the previous result
- **Persistent**: Results are saved permanently in the database

## GPT Analysis Features

- **Simple Yes/No Answer**: GPT responds with YES or NO for compatibility
- **Detailed Explanation**: Provides specific issues found
- **File Size Limit**: Large files are truncated to 8000 characters for analysis
- **Error Handling**: Graceful handling of API errors and network issues

## Example GPT Response

```
YES

This PHP code appears to be compatible with both PHP 5.6 and PHP 8.x. 
The code uses standard PHP functions and syntax that work across both versions.
No deprecated functions or PHP 8-specific features detected.
```

## Cost Considerations

- Uses GPT-3.5-turbo model (cost-effective)
- Limited to 500 tokens response
- Only analyzes when you click the button
- No automatic batch processing

## Troubleshooting

- **No GPT Button**: Install openai package or configure API key
- **API Errors**: Check your API key and internet connection
- **Large Files**: Files over 8000 characters are automatically truncated