# AI Key Header Files Analysis

## List of Functions Available

### From isfunctions.php

- `sqlquery($getq)`: Executes a mysqli query on the database.
- `safetext2($safe)`: Sanitizes text input by replacing quotes and limiting characters.

### From atlas_functions.php

- `getquery($getq)`: Executes a mysql query (deprecated, uses old mysql functions).
- `getlinkedorders($orderid, $companyid, $hostcompanyid)`: Retrieves linked orders for a given order ID.
- `AI_md_to_html($md)`: Converts markdown text to HTML.
- `ai_cid_details($x, $ai_cid)`: Fetches company details via cURL for AI processing.
- `prep_ask_ai_noinput($ai_pretext)`: Prepares an AI query without user input.
- `prep_ask_ai($ai_pretext)`: Prepares an AI query with user input interface.
- `getcompanyid_fromemail($email)`: Retrieves company ID based on email.
- `customerreftoorderid($hostcompanyid, $customerref)`: Converts customer reference to order ID.
- `safetext2($safe)`: Sanitizes text input (duplicate).
- `getsecurity()`: Retrieves security parameters from GET/POST.
- `linktosor($x, $sorid)`: Generates HTML link for SOR (Sales Order Return).
- `linktoprocess($x, $processid)`: Generates HTML link for process.
- `linktoissue($x, $issueid)`: Generates HTML link for issue.
- `linktosrs($x, $srsid)`: Generates HTML link for SRS.
- `NewOrderID($reference)`: Extracts order ID from reference string.
- `linkdocid($x, $docid)`: Generates HTML link for document download/view.
- `oldlinkdocid($x, $docid)`: Generates HTML link for document (old version).
- `mailingid($x, $reference, $float, $size)`: Generates HTML link for mailing ID.
- `linkbarcodehistory($x, $barcode)`: Generates HTML link for barcode history.
- `linkcrm($x, $cid, $id)`: Generates HTML link for CRM.
- `operadoclinks($x, $reference, $float)`: Generates HTML links for Opera documents.
- `linkstkref($x, $reference, $float, $size, $hostco)`: Generates HTML link for stock reference.
- `neworderlinks($x, $reference, $float, $size)`: Generates HTML link for new order.
- `linkpurchaseorder($x, $reference, $float, $size)`: Generates HTML links for purchase order.
- `decodeinvoicenumberlinks($x, $reference)`: Decodes invoice number and generates links.
- `decodeinvoicenumber($reference)`: Decodes invoice number.
- `displayvalue($num, $s)`: Formats number with decimal places.
- `convertxerodatetoatlas($xerodate)`: Converts Xero date to Atlas timestamp.
- `lastsaleofby($stockref, $companyid)`: Retrieves last sale date for stock by company.
- `getstockdesc($hostcompanyid, $stockref)`: Retrieves stock description.
- `getstockdescriptions($hostcompanyid)`: Retrieves stock descriptions array.
- `getcontactname($contactid)`: Retrieves contact name.
- `sqlquery($getq)`: Executes mysqli query (duplicate).
- `get_employeeheader($employeeid, $x)`: Generates HTML header for employee details.
- `doismenusearch($searchid, $searchtext, $x, $vui)`: Performs menu search.
- `getdocumentdescription($x, $docid)`: Retrieves document description with status.
- `getlatestversiondocid($md5)`: Retrieves latest document version by MD5.
- `getstockdescription($stkref)`: Error message for missing host.
- `prndate($udate)`: Formats Unix timestamp to date string.
- `displaydate($udate)`: Formats Unix timestamp to date string (duplicate).
- `gethostcompanyfilter($gobalsearch, $fieldid)`: Replaces field ID in global search.
- `getcompanyname($companyid)`: Retrieves company name.
- `gethostcompanyoptions($userid, $selected)`: Generates HTML select for host companies.
- `gethostcompanyname($id)`: Retrieves host company name.
- `getusernameoptions($default2, $userid)`: Generates HTML select for usernames.
- `getusernameoptionsnames($default2)`: Generates HTML select for usernames by name.
- `getuserinitials($id)`: Retrieves user initials.
- `getusername($id)`: Retrieves username.
- `getcurrentname($id)`: Retrieves current name or username.
- `getuserid($id)`: Retrieves user ID by username.
- `getd($d)`: Formats Unix timestamp to date string.
- `safejson2($safe)`: Sanitizes JSON input.
- `safenumber2($number)`: Sanitizes number input.
- `safesessionid2($session)`: Sanitizes session ID.
- `reinput($inp)`: Returns input unchanged.
- `readbarcode($barcode)`: Returns barcode unchanged.
- `getweatherquery($getq)`: Executes weather database query (old mysql).
- `multisearch($txt, $fld)`: Performs multi-word search.
- `pdfdescription($description, $charactors)`: Formats description for PDF.
- `multisearchandworks($txt, $fld)`: Performs multi-word search with AND.
- `multisearchorworks($txt, $fld)`: Performs multi-word search with OR.
- `getcrmaddress($contactid, $companyid)`: Retrieves CRM address details.
- `calculateWorkingDays($startDate, $numDays)`: Calculates working days from start date.
- `getall_stocktarriffs_description($hostcompany, $stkref)`: Retrieves stock descriptions.
- `getcontactemail($contactid)`: Retrieves contact email.
- `getcontactnamecompany($contactid)`: Retrieves contact name and company.
- `getcontacttel($contactid)`: Retrieves contact telephone.
- `gethostsallowed($userid)`: Retrieves allowed hosts for user.
- `getusercurrentname($id)`: Retrieves user current name.
- `getusersecurity()`: Retrieves user security level.
- `pdfdescription2($description, $charactors)`: Formats description for PDF (alternative).
- `upsquery($getq)`: Executes UPS database query.
- `renderAnswerInput($questionId, $answerType, $config)`: Renders HTML input for answers.

## Functions Using getquery() (Need Updating)

- `getquery($getq)`: Uses old mysql functions.
- `getweatherquery($getq)`: Uses old mysql functions.

## Variables Set When getq.php / getq2.php / getq3.php Are Used

### User and Session Variables

- `$vui`: User ID.
- `$localname`: User name.
- `$usemenu`: Menu usage flag.
- `$usersecurity`: User security level.
- `$useissuestyle`: Issue style preference.
- `$canienter`: Entry permission.
- `$authin`: Authentication status.
- `$menuaccess`: Menu access level.
- `$mystocklocation`: Stock location.
- `$mysigniture`: Email signature.
- `$myextendedtextbox`: Extended textbox setting.
- `$mybirthday`: Birthday date.
- `$myfluff`: Fluff setting.
- `$myhelper`: Helper setting.
- `$showtelog`: Show telog flag.
- `$sentaheart`: Sent a heart flag.
- `$eastereggimg`: Easter egg image.
- `$logedintoatlas`: Atlas login status.
- `$showhideholiday`: Holiday visibility.
- `$documentadministrator`: Document admin status.
- `$usebackgroundimage`: Background image.

### Company Variables

- `$global_company_name`: Company name.
- `$global_company_fullname`: Full company name.
- `$global_company_add1`: Address line 1.
- `$global_company_add2`: Address line 2.
- `$global_company_add3`: Address line 3.
- `$global_company_add4`: Address line 4.
- `$global_company_postcode`: Postcode.
- `$global_company_tel`: Telephone.
- `$global_company_fax`: Fax.
- `$global_company_email`: Email.
- `$global_company_comm`: Commission.
- `$global_company_shippcharge`: Shipping charge.
- `$global_company_fixed`: Fixed value.
- `$global_company_vat`: VAT.
- `$global_company_prefix`: Prefix.
- `$global_company_insurancetrigger`: Insurance trigger.
- `$global_company_website_files`: Website files.
- `$global_company_logo`: Logo.
- `$global_company_logo64`: Logo 64.
- `$global_company_logo16`: Logo 16.
- `$global_company_logo48`: Logo 48.
- `$global_company_logo24`: Logo 24.
- `$global_company_shopify_read_key`: Shopify read key.
- `$global_company_shopify_read_keyurl`: Shopify read key URL.
- `$global_company_access`: Access array.
- `$global_company_nameslist`: Names list.
- `$global_company_filter`: Filter string.
- `$global_company_filter_inclusive`: Inclusive filter.
- `$global_access_purchaseorder`: Purchase order access.
- `$global_access_commitquote`: Commit quote access.
- `$global_access_updatestock`: Update stock access.
- `$global_access_updatedocument`: Update document access.
- `$global_access_movestock`: Move stock access.
- `$global_access_updatestaff`: Update staff access.

### Other Variables

- `$viamedonlinewebsite`: Online website URL.
- `$baseurl`: Base URL.
- `$pastelgreen`: Color code.
- `$pastelred`: Color code.
- `$pastelcyan`: Color code.
- `$pastelyellow`: Color code.
- `$pastelbrown`: Color code.
- `$nowis`: Current timestamp.
- `$ip`: IP address.
- `$usenow`: Current time.
- `$self`: Self URL.
- `$showalltimeicons`: Show time icons flag.
- `$docstoread`: Docs to read.
- `$focustext`: Focus text.
- `$atlason`: Atlas on flag.
- `$hostOptions`: Host options.
- `$eventOptions`: Event options.
- `$supercount_hide`: Supercount hide flag.