# Supplier Regulatory Database Structures

## regulatory_positions

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| name | varchar(255) | NO |  |  |  |
| description | text | YES |  |  |  |
| active | int | NO |  | 1 |  |
| addedby | int | NO |  |  |  |
| addedon | bigint | NO |  |  |  |

## regulatory_company_positions

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| companyid | int | NO |  |  |  |
| positionid | int | NO |  |  |  |
| contactid | int | YES |  |  |  |
| confirmedon | bigint | YES |  |  |  |
| confirmedby | int | YES |  |  |  |
| notes | text | YES |  |  |  |

## regulatory_document_types

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| name | varchar(255) | NO |  |  |  |
| description | text | YES |  |  |  |
| level | enum('company','stock') | NO |  |  |  |
| review_by | varchar(255) | YES |  |  |  |
| active | int | NO |  | 1 |  |
| addedby | int | NO |  |  |  |
| addedon | bigint | NO |  |  |  |

## regulatory_company_documents

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| companyid | int | NO |  |  |  |
| document_type_id | int | NO |  |  |  |
| docid | int | YES |  |  |  |
| status | enum('has','does_not_have') | NO |  |  |  |
| notes | text | YES |  |  |  |
| addedby | int | NO |  |  |  |
| addedon | bigint | NO |  |  |  |

## regulatory_group_documents

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| groupcode | varchar(255) | NO |  |  |  |
| document_type_id | int | NO |  |  |  |
| required | int | NO |  | 1 |  |
| document_url | varchar(500) | YES |  |  |  |
| addedby | int | NO |  |  |  |
| addedon | bigint | NO |  |  |  |

## regulatory_stock_documents

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| stockref | varchar(26) | NO |  |  |  |
| document_type_id | int | NO |  |  |  |
| required | int | NO |  | 1 |  |
| document_url | varchar(500) | YES |  |  |  |
| addedby | int | NO |  |  |  |
| addedon | bigint | NO |  |  |  |

## regulatory_stock_provided_documents

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| stockref | varchar(26) | NO |  |  |  |
| document_type_id | int | NO |  |  |  |
| docid | int | YES |  |  |  |
| status | enum('has','does_not_have') | NO |  |  |  |
| notes | text | YES |  |  |  |
| addedby | int | NO |  |  |  |
| addedon | bigint | NO |  |  |  |
## regulatory_link_types

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| description | varchar(255) | NO |  |  |  |
| active | int | NO |  | 1 |  |
| addedby | int | NO |  |  |  |
| addedon | bigint | NO |  |  |  |

## regulatory_company_links

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| regulatory_link_type_id | int | NO |  |  |  |
| companyid | int | NO |  |  |  |
| linked_companyid | int | NO |  |  |  |
| stockgroup | varchar(255) | YES |  |  |  |
| stockref | varchar(26) | YES |  |  |  |
| addedby | int | NO |  |  |  |
| addedon | bigint | NO |  |  |  |