# Supplier Regulatory Database Relations

## Table Relationships

### regulatory_positions
- **addedby** → `pw_companys.vui` (user who added the position)
- No direct foreign keys, used as reference table

### regulatory_company_positions
- **companyid** → `viamedquoteaddress.ID` (supplier company)
- **positionid** → `regulatory_positions.id` (position definition)
- **contactid** → `viamedquotecontact.id` (contact person)
- **confirmedby** → `pw_companys.vui` (user who confirmed)

### regulatory_document_types
- **addedby** → `pw_companys.vui` (user who added the document type)
- No direct foreign keys, used as reference table

### regulatory_company_documents
- **companyid** → `viamedquoteaddress.ID` (supplier company)
- **document_type_id** → `regulatory_document_types.id` (document type)
- **docid** → `ISO_quality_manual_files.id` (actual document file)
- **addedby** → `pw_companys.vui` (user who added)

### regulatory_group_documents
- **groupcode** → `viamed_customer_stock_references_groupcodes_links.groupcode` (supplier-specific group)
- **document_type_id** → `regulatory_document_types.id` (document type)
- **addedby** → `pw_companys.vui` (user who added)

### regulatory_stock_documents
- **stockref** → `stocklist.STOCK_REFE` (stock reference)
- **document_type_id** → `regulatory_document_types.id` (document type)
- **addedby** → `pw_companys.vui` (user who added)

### regulatory_stock_provided_documents
- **stockref** → `stocklist.STOCK_REFE` (stock reference)
- **document_type_id** → `regulatory_document_types.id` (document type)
- **docid** → `ISO_quality_manual_files.id` (actual document file)
- **addedby** → `pw_companys.vui` (user who added)
### regulatory_link_types
- **addedby** → `pw_companys.vui` (user who added the link type)
- No direct foreign keys, used as reference table

### regulatory_company_links
- **regulatory_link_type_id** → `regulatory_link_types.id` (link type)
- **companyid** → `viamedquoteaddress.ID` (supplier company)
- **linked_companyid** → `viamedquoteaddress.ID` (linked company)
- **stockgroup** → `viamed_customer_stock_references_groupcodes_links.groupcode` (optional, supplier-specific group)
- **stockref** → `stocklist.STOCK_REFE` (optional, stock reference)
- **addedby** → `pw_companys.vui` (user who added)

## Key Relationships Summary
- Supplier companies (`viamedquoteaddress.ID`) link to positions and documents via `regulatory_company_positions` and `regulatory_company_documents`
- Stock items (`stocklist.STOCK_REFE`) have requirements defined in `regulatory_stock_documents` and provided documents in `regulatory_stock_provided_documents`
- Groups (`viamed_customer_stock_references_groupcodes_links.groupcode`) define document requirements for multiple stocks via `regulatory_group_documents`
- Regulatory link types allow linking compliance responsibilities between companies via `regulatory_company_links`
- All user actions reference `pw_companys.vui` for audit trails
- Document files are stored in `ISO_quality_manual_files` and linked via `docid` fields