# Key Databases for Document Processing and Quality Management System

## Overview
The document processing and quality management system manages controlled documents, their versions, links to various entities, and tracking of user interactions. The system uses PHP 5.6 with MySQL databases and supports ISO quality management processes.

## Source Pages Analyzed
The following PHP pages were analyzed to identify the key databases and their interactions:
- `intranet/databases/iso_documents/showdoc2admin.php` - Document admin interface

## Core Document Management Databases

### 1. `ISO_quality_manual_files`
**Purpose**: Main table storing all controlled documents and their metadata.
**Key Fields**:
- `id`: Document ID
- `docid`: Document revision code
- `description`: Document title/description
- `type`: Document type
- `addedby/addedon`: Creation info
- `filename/docname`: File information
- `security`: Security level
- `hostcompany`: Host company ID
- `archived`: Archive status
- `reviewed_date`: Last review date
- `exp_date`: Expiry date
- `md5hash`: File hash for change detection

**Interactions**:
- Links to `ISO_quality_manual_files_referenced_docids` via `docid`
- Links to `ISO_quality_manual_interestedpartys` via `docid`
- Links to `ISO_quality_manual_files_reviews` via `docid`
- Links to `ISO_quality_manual_files_types_links` via `docid`
- Links to `ISO_quality_manual_stock_links` via `docid`
- Links to `ISO_quality_manual_user_read` via `docid`
- Links to `ISO_quality_manual_user_groups` via `docid`
- Links to `ISO_quality_manual_filelinks` via `docid`
- Links to `ISO_quality_manual_sted` via `docid`
- Links to `ISO_quality_manual_files_standards` via `docid`
- Links to `ISO_ce_index` via `docid`
- Links to `viamedquotefilelinks` via `docid`
- Links to `viamedagendalinkdocs` via `md5hash`
- Links to `ISO_training_docs` via `docid`
- Links to `iso_file_groups` via `docid`
- Links to `ISO_quality_manual_files_related_recur_issues` via `docid`
- References `ISO_quality_manual_files_security` via `security`
- References `global_companys` via `hostcompany`
- References `pw` via `addedby`

### 2. `ISO_quality_manual_files_referenced_docids`
**Purpose**: Links documents to other referenced documents.
**Key Fields**:
- `docid`: Source document
- `refdocid`: Referenced document

**Interactions**:
- Child of `ISO_quality_manual_files`
- References `ISO_quality_manual_files` (both directions)

### 3. `ISO_quality_manual_interestedpartys`
**Purpose**: Links documents to interested parties/departments.
**Key Fields**:
- `docid`: Document ID
- `interestedparty`: Party ID

**Interactions**:
- Child of `ISO_quality_manual_files`
- References `ISO_InterestedParties` via `interestedparty`

### 4. `ISO_quality_manual_files_reviews`
**Purpose**: Tracks document review history.
**Key Fields**:
- `docid`: Document ID
- `reviewedon/reviewedby`: Review info

**Interactions**:
- Child of `ISO_quality_manual_files`
- References `pw` via `reviewedby`

### 5. `ISO_quality_manual_files_types_links`
**Purpose**: Links documents to their types.
**Key Fields**:
- `docid`: Document ID
- `typeid`: Type ID

**Interactions**:
- Child of `ISO_quality_manual_files`
- References `ISO_quality_manual_files_types` via `typeid`

### 6. `ISO_quality_manual_stock_links`
**Purpose**: Links documents to stock items.
**Key Fields**:
- `docid`: Document ID
- `stock_ref`: Stock reference

**Interactions**:
- Child of `ISO_quality_manual_files`
- References `stocklist_tarriffs` via `stock_ref`

### 7. `ISO_quality_manual_user_read`
**Purpose**: Tracks which users have read which documents.
**Key Fields**:
- `docid`: Document ID
- `userid`: User ID
- `last_read`: Read timestamp

**Interactions**:
- Child of `ISO_quality_manual_files`
- References `pw` via `userid`

### 8. `ISO_quality_manual_user_groups`
**Purpose**: Limits document visibility to specific user groups.
**Key Fields**:
- `docid`: Document ID
- `groupid`: Group ID

**Interactions**:
- Child of `ISO_quality_manual_files`
- References `user_groups` via `groupid`

### 9. `ISO_quality_manual_filelinks`
**Purpose**: Links documents to ISO manual sections.
**Key Fields**:
- `fileid`: Document ID
- `qmid`: ISO section ID

**Interactions**:
- Child of `ISO_quality_manual_files`
- References `ISO_quality_manual` via `qmid`

### 10. `ISO_quality_manual_sted`
**Purpose**: Links documents to STED technical file format.
**Key Fields**:
- `stedid`: STED header ID
- `docid`: Document ID

**Interactions**:
- References `ISO_quality_manual_sted_headers` via `stedid`
- References `ISO_quality_manual_files` via `docid`

### 11. `ISO_quality_manual_files_standards`
**Purpose**: Links documents to ISO standards they prove compliance with.
**Key Fields**:
- `docid`: Document ID
- `standardid`: Standard ID
- `addedby/addedon`: Creation info
- `memo`: Additional notes

**Interactions**:
- Child of `ISO_quality_manual_files`
- References `ISO_standards` via `standardid`
- References `pw` via `addedby`

### 12. `ISO_ce_index`
**Purpose**: Links documents to CE technical file sections.
**Key Fields**:
- `fileid`: Document ID
- `familyid`: CE family ID
- `headerid`: CE header ID

**Interactions**:
- References `ISO_quality_manual_files` via `fileid`
- References `ISO_ce_family_index` via `familyid`
- References `ISO_ce_headers` via `headerid`

### 13. `viamedquotefilelinks`
**Purpose**: Links documents to customer contacts.
**Key Fields**:
- `docid`: Document ID
- `COMPANYID`: Company ID
- `CONTACTID`: Contact ID

**Interactions**:
- References `ISO_quality_manual_files` via `docid`
- References `viamedquoteaddress` via `COMPANYID`
- References `viamedquotecontact` via `CONTACTID`

### 14. `viamedagendalinkdocs`
**Purpose**: Links documents to agenda/issue items.
**Key Fields**:
- `issueid`: Issue ID
- `docid`: Document ID
- `md5hash`: File hash

**Interactions**:
- References `viamedagendahistory` via `issueid`
- References `ISO_quality_manual_files` via `md5hash`

### 15. `ISO_training_docs`
**Purpose**: Links documents to training courses.
**Key Fields**:
- `docid`: Document ID
- `courseid`: Course ID

**Interactions**:
- References `ISO_quality_manual_files` via `docid`
- References `ISO_training_course` via `courseid`

### 16. `iso_file_groups`
**Purpose**: Groups documents into categories.
**Key Fields**:
- `docid`: Document ID
- `groupid`: Group ID

**Interactions**:
- References `ISO_quality_manual_files` via `docid`
- References `iso_file_groups_names` via `groupid`

### 17. `ISO_quality_manual_files_related_recur_issues`
**Purpose**: Links documents to recurring issues/tasks.
**Key Fields**:
- `docid`: Document ID
- `recurissueid`: Recurring issue ID

**Interactions**:
- References `ISO_quality_manual_files` via `docid`
- References `viamedagendafuture` via `recurissueid`

## Supporting Databases

### 18. `ISO_quality_manual_files_security`
**Purpose**: Security level definitions.
**Key Fields**:
- `id`: Security level ID
- `description`: Security description

**Interactions**:
- Referenced by `ISO_quality_manual_files.security`

### 19. `ISO_quality_manual_files_types`
**Purpose**: Document type definitions.
**Key Fields**:
- `id`: Type ID
- `type`: Type code
- `description`: Type description
- `supplierreviewrequired`: Review requirement flag

**Interactions**:
- Referenced by `ISO_quality_manual_files_types_links.typeid`

### 20. `ISO_standards`
**Purpose**: ISO standard definitions.
**Key Fields**:
- `id`: Standard ID
- `mainheader`: Standard code
- `description`: Standard description

**Interactions**:
- Referenced by `ISO_quality_manual_files_standards.standardid`

### 21. `ISO_InterestedParties`
**Purpose**: Interested party/department definitions.
**Key Fields**:
- `id`: Party ID
- `description`: Party description

**Interactions**:
- Referenced by `ISO_quality_manual_interestedpartys.interestedparty`

### 22. `ISO_quality_manual`
**Purpose**: ISO manual section definitions.
**Key Fields**:
- `id`: Section ID
- `iso_section`: Section code
- `iso_section_header`: Section header
- `long_text`: Section content
- `filter`: Filter category

**Interactions**:
- Referenced by `ISO_quality_manual_filelinks.qmid`

### 23. `ISO_ce_family_index`
**Purpose**: CE technical file family definitions.
**Key Fields**:
- `id`: Family ID
- `family_description`: Family description

**Interactions**:
- Referenced by `ISO_ce_index.familyid`

### 24. `ISO_ce_headers`
**Purpose**: CE technical file section headers.
**Key Fields**:
- `id`: Header ID
- `ce_header`: Header text
- `ce_section`: Section code

**Interactions**:
- Referenced by `ISO_ce_index.headerid`

### 25. `ISO_training_course`
**Purpose**: Training course definitions.
**Key Fields**:
- `id`: Course ID
- `coursename`: Course name

**Interactions**:
- Referenced by `ISO_training_docs.courseid`

### 26. `iso_file_groups_names`
**Purpose**: Names of document groups.
**Key Fields**:
- `id`: Group ID
- `group_name`: Group name

**Interactions**:
- Referenced by `iso_file_groups.groupid`

### 27. `user_groups`
**Purpose**: User group definitions for access control.
**Key Fields**:
- `id`: Group ID
- `description`: Group description

**Interactions**:
- Referenced by `ISO_quality_manual_user_groups.groupid`

### 28. `global_companys`
**Purpose**: Host company definitions.
**Key Fields**:
- `id`: Company ID
- `name`: Company name
- `prefix`: Order prefix

**Interactions**:
- Referenced by `ISO_quality_manual_files.hostcompany`

### 29. `pw`
**Purpose**: User accounts.
**Key Fields**:
- `id`: User ID
- `username`: Username

**Interactions**:
- Referenced by various tables for user tracking

### 30. `stocklist_tarriffs`
**Purpose**: Master stock list.
**Key Fields**:
- `stock_ref`: Stock reference
- `description`: Item description
- `hostcompany_id`: Host company

**Interactions**:
- Referenced by `ISO_quality_manual_stock_links.stock_ref`

### 31. `viamedquoteaddress`
**Purpose**: Customer company addresses.
**Key Fields**:
- `ID`: Address ID
- `COMPANY`: Company name

**Interactions**:
- Referenced by `viamedquotefilelinks.COMPANYID`

### 32. `viamedquotecontact`
**Purpose**: Customer contacts.
**Key Fields**:
- `id`: Contact ID
- `CONTACT`: Contact name
- `COMPANY_ID`: Company ID

**Interactions**:
- Referenced by `viamedquotefilelinks.CONTACTID`
- References `viamedquoteaddress` via `COMPANY_ID`

### 33. `viamedagendahistory`
**Purpose**: Historical agenda/issue items.
**Key Fields**:
- `id`: Issue ID
- `subject`: Issue subject
- `notes`: Issue notes
- `docid`: Linked document ID

**Interactions**:
- Referenced by `viamedagendalinkdocs.issueid`

### 34. `viamedagendafuture`
**Purpose**: Future recurring issues/tasks.
**Key Fields**:
- `id`: Issue ID
- `subject`: Issue subject
- `type`: Issue type
- `target_user`: Assigned user

**Interactions**:
- Referenced by `ISO_quality_manual_files_related_recur_issues.recurissueid`

## Database Relationships Summary

```
ISO_quality_manual_files (main documents)
├── ISO_quality_manual_files_referenced_docids (related docs)
├── ISO_quality_manual_interestedpartys (interested parties)
│   └── ISO_InterestedParties
├── ISO_quality_manual_files_reviews (reviews)
├── ISO_quality_manual_files_types_links (types)
│   └── ISO_quality_manual_files_types
├── ISO_quality_manual_stock_links (stock links)
│   └── stocklist_tarriffs
├── ISO_quality_manual_user_read (user reads)
│   └── pw (users)
├── ISO_quality_manual_user_groups (user groups)
│   └── user_groups
├── ISO_quality_manual_filelinks (ISO sections)
│   └── ISO_quality_manual
├── ISO_quality_manual_sted (STED format)
│   └── ISO_quality_manual_sted_headers
├── ISO_quality_manual_files_standards (standards)
│   └── ISO_standards
├── ISO_ce_index (CE technical files)
│   ├── ISO_ce_family_index
│   └── ISO_ce_headers
├── viamedquotefilelinks (customer contacts)
│   ├── viamedquoteaddress
│   └── viamedquotecontact
├── viamedagendalinkdocs (agenda links)
│   └── viamedagendahistory
├── ISO_training_docs (training links)
│   └── ISO_training_course
├── iso_file_groups (document groups)
│   └── iso_file_groups_names
├── ISO_quality_manual_files_related_recur_issues (recurring issues)
│   └── viamedagendafuture
├── ISO_quality_manual_files_security (security levels)
├── global_companys (host companies)
└── pw (users)
```

## Key System Flows

1. **Document Creation**: `ISO_quality_manual_files` → various link tables
2. **Document Review**: `ISO_quality_manual_files` → `ISO_quality_manual_files_reviews`
3. **User Access Tracking**: `ISO_quality_manual_files` → `ISO_quality_manual_user_read`
4. **Quality Management**: `ISO_quality_manual_files` → `ISO_quality_manual_filelinks` → `ISO_quality_manual`
5. **CE Compliance**: `ISO_quality_manual_files` → `ISO_ce_index` → CE families/headers
6. **Training Integration**: `ISO_quality_manual_files` → `ISO_training_docs` → `ISO_training_course`
7. **Stock Documentation**: `ISO_quality_manual_files` → `ISO_quality_manual_stock_links` → `stocklist_tarriffs`
8. **Customer Communication**: `ISO_quality_manual_files` → `viamedquotefilelinks` → customer data
9. **Issue Tracking**: `ISO_quality_manual_files` → `viamedagendalinkdocs` → `viamedagendahistory`

This structure supports comprehensive document control, quality management, and compliance tracking across the organization.