# Key Databases for Group Action Categories System

## Overview
The group action categories system manages dynamic categories for tracking customer interactions within stock groups (e.g., "Lost Customers", "EYEMAX Promotion 1234"). This allows replication of the lost customers tracking functionality for multiple purposes without modifying existing code. Categories are linked to stock groups and used to differentiate tracking data in related tables like `viamedquotecontactstockstatus`.

## Source Pages Analyzed
The following PHP pages were analyzed to identify the key databases and their interactions:

- `vmserver10/intranet/databases/stock_groups/stockgroupuniquecustomers.php` - Main customer list page
- `vmserver10/intranet/databases/stock_groups/group_lost_customers.php` - Lost customers tracking page
- `vmserver10/intranet/databases/stock_groups/ajax_save_group_status.php` - Status save handler
- `vmserver10/intranet/databases/stock_groups/ajax_save_group_action.php` - Action save handler

## Core Group Action Categories Databases

### 1. `group_action_categories`
**Purpose**: Master table for defining categories of group actions (e.g., "Lost Customers", "Promotions"). Enables dynamic creation of tracking categories without code changes.
**Key Fields**:
- `id`: Category ID (primary key)
- `groupcode`: Links to `stockgroup.groupcode` (stock group identifier)
- `description`: Human-readable category name (e.g., "EYEMAX Promotion 1234")
- `createdon`: Unix timestamp when category was created

**Interactions**:
- Referenced by future group action main page for listing available categories
- Used to parameterize `typedata` in `viamedquotecontactstockstatus` (e.g., 'LostCustomers', 'EYEMAXPromotion1234')
- Links to `stockgroup` via `groupcode` to scope categories to specific stock groups
- Will be referenced by new category tracking pages (e.g., `group_category.php`) for filtering and display

## Database Relationships Summary

```
stockgroup (stock groups)
└── group_action_categories (categories per group)
    └── viamedquotecontactstockstatus (tracking data, via typedata)
```

## Key System Flows

1. **Category Creation**: User adds new category via main page → inserts into `group_action_categories`
2. **Category Selection**: Main page lists categories from `group_action_categories` linked to current `groupcode`
3. **Tracking Differentiation**: Category tracking pages use category description to set `typedata` in `viamedquotecontactstockstatus` (e.g., 'LostCustomers' vs. 'EYEMAXPromotion1234')
4. **Data Isolation**: Existing "Lost Customers" remains as hardcoded category; new ones are dynamic

This structure supports extensible customer tracking categories while maintaining backward compatibility with existing lost customers functionality.