# Key Databases for Contacts Processing System

## Overview
The contacts processing system in quotationrequest3.php manages customer and contact information, interactions, orders, and related activities. The system uses PHP 5.6 code with MySQL databases and integrates with CRM functionality, sales leads, service requests, and order management.

## Source Pages Analyzed
The following PHP pages were analyzed to identify the key databases and their interactions:

- `intranet/databases/crm/quotationrequest3.php` - Main contacts management page
- Associated AJAX calls and includes for contact processing

## Core Contact Management Databases

### 1. `viamedquotecontact`
**Purpose**: Main contacts table storing individual contact information for all customers and suppliers.
**Key Fields**:
- `id`: Contact ID (primary key)
- `CONTACT`: Contact name
- `COMPANY_ID`: Links to `viamedquoteaddress.ID`
- `INETADDR`: Email address
- `PHONE1/PHONE2`: Phone numbers
- `DEPARTMENT`: Department
- `UPOSITION`: Position/title
- `hideme`: Hidden flag
- `mail/email/phone`: Contact preferences
- `allowso`: Sales order permission
- `verifiedby/verifiedon`: Verification info
- `addedby/addedon`: Creation info
- `updatedon`: Last update timestamp

**Interactions**:
- Links to `viamedquoteaddress` via `COMPANY_ID`
- Referenced by `viamedquotestatus` via `customer_id`
- Used in `viamedagenda_events_log` via `contactid`
- Referenced by `viamedquote_orders` via `contact_id`
- Member of mailing groups via `viamedquotecontactgrouplinks`

### 2. `viamedquoteaddress`
**Purpose**: Company/customer master table storing company information and addresses.
**Key Fields**:
- `ID`: Company ID (primary key)
- `COMPANY`: Company name
- `ADDRESS1/2/3/CITY/ZIP/COUNTRY`: Address details
- `INETADDR`: Company email
- `PHONE1/PHONE2/FAX`: Company contact numbers
- `Vat_Number`: VAT number
- `Opera_*`: Opera system integration fields
- `credittype`: Credit type
- `Opera_Pricelist`: Default price list
- `incoterms`: Default incoterms
- `salesrep`: Assigned sales representative
- `addedby/addedon`: Creation info

**Interactions**:
- Parent to `viamedquotecontact` via `COMPANY_ID`
- Referenced by `viamedquote_orders` via `company_id`
- Referenced by `viamedquotestatus` via `company_id`
- Referenced by `viamed_memos_history` via `companyid`
- Referenced by `viamedagenda_events_log` via `companyid`

### 3. `viamedquotestatus`
**Purpose**: Activity log and status updates for contacts and companies.
**Key Fields**:
- `id`: Status entry ID
- `customer_id`: Links to `viamedquotecontact.id`
- `company_id`: Links to `viamedquoteaddress.ID`
- `status`: Status type (call, email, Order, SRS, etc.)
- `rasiedby`: User who created entry
- `timestampraised`: When entry was created
- `memo`: Status notes
- `marketingindexid`: Links to sales leads
- `visittag`: Status tag ID
- `irrequest`: Information request ID

**Interactions**:
- Child of `viamedquotecontact` and `viamedquoteaddress`
- Links to `viamed_marketing_index` via `marketingindexid`
- Links to `viamedquotestatus_tags` via `visittag`
- Links to `viamedquote_information_requests` via `irrequest`
- Used for activity history display

## Communication and Grouping Databases

### 4. `viamedquotecontactgroup`
**Purpose**: Mailing groups and contact categorization.
**Key Fields**:
- `id`: Group ID
- `description`: Group name
- `createdby/createdon`: Creation info
- `active`: Active flag

**Interactions**:
- Parent to `viamedquotecontactgrouplinks`
- Used for bulk email campaigns

### 5. `viamedquotecontactgrouplinks`
**Purpose**: Links contacts to mailing groups.
**Key Fields**:
- `groupid`: Links to `viamedquotecontactgroup.id`
- `contactid`: Links to `viamedquotecontact.id`
- `vui`: User ID who added
- `addedon/addedby`: Creation info

**Interactions**:
- Links `viamedquotecontact` to `viamedquotecontactgroup`
- Enables group-based contact management

## Event and Activity Tracking Databases

### 6. `viamedagenda_events_log`
**Purpose**: Scheduled events and activities for contacts.
**Key Fields**:
- `id`: Event ID
- `eventtypeid`: Links to `viamedagenda_events_types.id`
- `companyid`: Links to `viamedquoteaddress.ID`
- `contactid`: Links to `viamedquotecontact.id`
- `eventtime`: Scheduled time
- `eventuser`: Assigned user
- `memo`: Event notes
- `completed/completedby`: Completion info

**Interactions**:
- Links to `viamedquoteaddress` and `viamedquotecontact`
- References `viamedagenda_events_types` for event types
- Used for pending events display

### 7. `viamedagenda_events_types`
**Purpose**: Master list of event types.
**Key Fields**:
- `id`: Event type ID
- `description`: Event type name
- `hostcompanyid`: Host company
- `securitylevel`: Access level
- `archived`: Archive flag

**Interactions**:
- Referenced by `viamedagenda_events_log`
- Defines available event categories

## Sales and Marketing Databases

### 8. `viamed_marketing_index`
**Purpose**: Sales leads and marketing projects.
**Key Fields**:
- `id`: Lead ID
- `filtercode`: Lead type
- `description`: Lead description
- `customer_companyid`: Customer company
- `customer_contactid`: Customer contact
- `supplier_companyid`: Supplier company
- `completedon`: Completion date

**Interactions**:
- Links to `viamedquoteaddress` via company IDs
- Links to `viamedquotecontact` via contact IDs
- Referenced by `viamedquotestatus` via `marketingindexid`
- Used for sales pipeline management

### 9. `viamed_marketing_filtercodes`
**Purpose**: Marketing lead type definitions.
**Key Fields**:
- `id`: Filter code ID
- `description`: Lead type description
- `active`: Active flag

**Interactions**:
- Referenced by `viamed_marketing_index` via `filtercode`
- Defines lead categories

## Service and Returns Databases

### 10. `viamed_salereturnhead`
**Purpose**: Sale or Return (SOR) headers.
**Key Fields**:
- `id`: SOR ID
- `companyid`: Company ID
- `contactid`: Contact ID
- `operaid`: Opera reference
- `status`: SOR status
- `typesor`: SOR type
- `datesent`: Date sent

**Interactions**:
- Links to `viamedquoteaddress` and `viamedquotecontact`
- Parent to `viamed_sale_return`
- Used for outstanding SOR tracking

### 11. `viamed_sale_return`
**Purpose**: Individual items in Sale or Returns.
**Key Fields**:
- `headerid`: Links to `viamed_salereturnhead.id`
- `serialid`: Serial number ID
- `stock_ref`: Stock reference
- `status`: Item status
- `datereturned`: Return date

**Interactions**:
- Child of `viamed_salereturnhead`
- Links to stock tracking systems
- Used for SOR item management

### 12. `viamed_customer_repairs_header`
**Purpose**: Service Request System (SRS) headers.
**Key Fields**:
- `id`: SRS ID
- `companyid`: Company ID
- `viamedquotecontactid`: Contact ID
- `status`: SRS status
- `createddate`: Creation date
- `repair_notes`: Repair notes

**Interactions**:
- Links to `viamedquoteaddress` and `viamedquotecontact`
- Used for outstanding SRS tracking
- Referenced in status updates

## Order Integration Databases

### 13. `viamedquote_orders`
**Purpose**: Customer orders linked to contacts.
**Key Fields**:
- `id`: Order ID
- `company_id`: Company ID
- `contact_id`: Contact ID
- `customer_ref`: Customer reference
- `order_stage`: Order stage
- `createdon/createdby`: Creation info

**Interactions**:
- Links to `viamedquoteaddress` via `company_id`
- Links to `viamedquotecontact` via `contact_id`
- Referenced in contact order history
- Used for order status display

### 14. `viamedquotestocklink`
**Purpose**: Links stock items to contact visits/status entries.
**Key Fields**:
- `companyid`: Company ID
- `visitid`: Links to `viamedquotestatus.id`
- `stockref`: Stock reference
- `addedon/addedby`: Creation info

**Interactions**:
- Links `viamedquotestatus` to stock items
- Used for stock discussion tracking

## Supporting Databases

### 15. `global_companys_departments`
**Purpose**: Department definitions.
**Key Fields**:
- `id`: Department ID
- `description`: Department name
- `active`: Active flag

**Interactions**:
- Referenced by contact department fields
- Used for department filtering

### 16. `viamedquotestatus_tags`
**Purpose**: Status tags for categorizing activities.
**Key Fields**:
- `id`: Tag ID
- `tagtype`: Tag type (1=visit tags)
- `description`: Tag description

**Interactions**:
- Referenced by `viamedquotestatus` via `visittag`
- Used for activity categorization

### 17. `viamedquote_information_requests`
**Purpose**: Information requests from customers.
**Key Fields**:
- `id`: Request ID
- `subject`: Request subject
- `companyid`: Company ID
- `contactid`: Contact ID
- `status`: Request status

**Interactions**:
- Links to `viamedquoteaddress` and `viamedquotecontact`
- Referenced by `viamedquotestatus` via `irrequest`
- Used for IR tracking

### 18. `viamedquote_global_watchlist`
**Purpose**: User watchlists for tracking items.
**Key Fields**:
- `watchkey1`: Item ID being watched
- `watchtype`: Type of item (CustomerReturn, etc.)
- `addedby`: User who added
- `status`: Watch status

**Interactions**:
- Used for SRS watchlist functionality
- Links to various item types

### 19. `tellog` and `tellognotes`
**Purpose**: Telephone call logging.
**Key Fields** (tellog):
- `id`: Call ID
- `callid`: Call identifier
- `addedby/addedon`: Creation info
- `marketingindexid`: Linked marketing activity

**Interactions**:
- Referenced in status updates for call logging
- Links to marketing activities

### 20. `viamedquote_orders_credits`
**Purpose**: Credit notes linked to companies.
**Key Fields**:
- `id`: Credit ID
- `creditreference`: Credit reference
- `company_id`: Company ID
- `committedon`: Commitment date

**Interactions**:
- Links to `viamedquoteaddress` via `company_id`
- Used for outstanding credits display

### 21. `viamed_memos_history`
**Purpose**: Customer memos and notes.
**Key Fields**:
- `companyid`: Company ID
- `contactid`: Contact ID
- `memotype`: Memo type
- `memo`: Memo content
- `addedon/addedby`: Creation info

**Interactions**:
- Links to `viamedquoteaddress` and `viamedquotecontact`
- Used for customer-specific notes

### 22. `viamedquoteaddress_hostcompany`
**Purpose**: Links companies to host companies.
**Key Fields**:
- `company_id`: Company ID
- `hostcompany`: Host company ID

**Interactions**:
- Links `viamedquoteaddress` to host company settings
- Used for company-specific configurations

## Database Relationships Summary

```
viamedquoteaddress (companies)
├── viamedquotecontact (contacts)
│   ├── viamedquotecontactgrouplinks → viamedquotecontactgroup
│   ├── viamedquotestatus (activities)
│   │   ├── viamedquotestatus_tags
│   │   ├── viamed_marketing_index
│   │   └── viamedquote_information_requests
│   ├── viamedagenda_events_log → viamedagenda_events_types
│   ├── viamedquote_orders (orders)
│   ├── viamed_salereturnhead → viamed_sale_return
│   ├── viamed_customer_repairs_header
│   └── viamed_memos_history
├── viamedquoteaddress_hostcompany
├── viamedquote_orders_credits
└── viamed_memos_history
```

## Key System Flows

1. **Contact Creation**: `viamedquoteaddress` → `viamedquotecontact`
2. **Activity Logging**: Contact actions create `viamedquotestatus` entries
3. **Group Management**: Contacts linked to `viamedquotecontactgroup` via `viamedquotecontactgrouplinks`
4. **Event Scheduling**: `viamedagenda_events_log` linked to contacts and companies
5. **Sales Integration**: Contacts linked to `viamed_marketing_index` for lead management
6. **Order Processing**: Contacts linked to `viamedquote_orders` for order history
7. **Service Tracking**: SRS and SOR systems linked to contacts via `viamed_customer_repairs_header` and `viamed_salereturnhead`

This structure supports comprehensive contact management with integrated sales, service, and order processing capabilities.