# AI Database Roles, Titles, Issues Structure

This document outlines the database table structures for the roles, titles, issues, and related components in the ISO 13485 compliance system.

## Core Tables

### ISO_job_titles
- id (primary key)
- description (job title name)
- supervisorid (references ISO_job_titles.id for hierarchy)
- heightofrole (numeric level in hierarchy)
- defaultmeeting (references viamedagenda.id)
- hostcompanyid (references global_companys.id)

### ISO_job_titles_employeeid
- titleid (references ISO_job_titles.id)
- employid (references pw.id)

### pw (Users)
- id (primary key)
- username
- active (1=active, 0=inactive)

### ISO_job_base_process
- id (primary key)
- description (process description)
- taskid (references viamedagendafuture.id)
- auditid (references viamedagendafuture.id)
- interestedparty (boolean flag)
- responsibilityonly (boolean, 1=responsibility only, no tasks/audits)
- intrastatsmenun (references intrastatmenu.id)
- agendaid (references viamedagenda.id)

### ISO_job_base_process_title
- processid (references ISO_job_base_process.id)
- titleid (references ISO_job_titles.id)

### viamedagendafuture (Future/Rolling Issues)
- id (primary key)
- subject
- target_user (username)
- recur_time_months
- recur_time_weeks
- recur_time_days
- live_date (timestamp)
- notes
- icanprelinkissues (boolean, allow linking user issues)

### viamedagendahistory (Historical Issues)
- id (primary key)
- subject
- autoissueid (references viamedagendafuture.id)
- completed (boolean)
- investigatedcomplete (boolean)
- createdate (timestamp)
- viewed (boolean)
- hide_until (timestamp)
- investigateby (username)

### ISO_job_titles_risks
- id (primary key)
- jobid (references ISO_job_base_process.id)
- typeid (references ISO_job_risks_types.id)
- notes
- updatedby (references pw.id)
- updatedon (timestamp)
- reviewedon (timestamp)

### ISO_job_risks_types
- id (primary key)
- description (risk type description)

### ISO_training_tasks
- processid (references ISO_job_base_process.id)
- employeetrained (references pw.id)
- trainedby (references pw.id)

### ISO_training_course
- id (primary key)
- coursetypeid
- coursename

### ISO_training_people
- employeeid (references pw.id)
- courseid (references ISO_training_course.id)

### ISO_InterestedParties
- id (primary key)
- description

### ISO_job_base_process_interestedpartys
- processid (references ISO_job_base_process.id)
- interestedparty (references ISO_InterestedParties.id)

### ISO_job_base_process_companyid
- processid (references ISO_job_base_process.id)
- hostcompanyid (references global_companys.id)

### global_companys
- id (primary key)
- name
- active (0=active, 1=inactive)

### viamedagenda
- id (primary key)
- meetingid
- sectionid
- subsectionid
- heading
- companyid (references global_companys.id)

### ISO_quality_manual
- id (primary key)
- filter (references ISO_quality_manual_filter_groups.filter)
- iso_section

### ISO_quality_manual_processes
- processid (references ISO_job_base_process.id)
- qmid (references ISO_quality_manual.id)

### ISO_job_base_process_files
- processid (references ISO_job_base_process.id)
- docid (references ISO_quality_manual_files.docid)

### ISO_quality_manual_files
- docid (primary key)
- description
- type
- archived (boolean)

### ISO_job_base_process_effective_review
- processid (references ISO_job_base_process.id)
- reviewedon (timestamp)
- reviewedby (references pw.id)
- memo

### pw_companys
- vui (references pw.id)
- company_id (references global_companys.id)

### intrastatmenu
- id (primary key)
- catagory
- sub_catagory
- description

### ISO_quality_manual_filter_groups
- filter (primary key)
- description
- hostcompanyid (references global_companys.id)
- active (0=active, 1=inactive)

### ISO_InterestedParties_risks
- id (primary key)
- interestedpartyid (references ISO_InterestedParties.id)
- description

### ISO_InterestedParties_risk_process
- riskid (references ISO_InterestedParties_risks.id)
- processid (references ISO_job_base_process.id)

### ISO_training_docs
- docid (references ISO_quality_manual_files.docid)
- courseid (references ISO_training_course.id)