# AI Database Roles, Titles, Issues Relations

This document describes the relationships between database tables in the ISO 13485 compliance system, focusing on how roles, titles, issues, processes, and related components interconnect.

## Core Relationships

### Organizational Hierarchy
- **ISO_job_titles** self-references via `supervisorid` to create a hierarchical structure of job titles
- **ISO_job_titles_employeeid** links employees (`pw.id`) to their job titles (`ISO_job_titles.id`)
- **pw_companys** associates users with companies they belong to

### Process Management
- **ISO_job_base_process_title** assigns job titles to specific processes
- **ISO_job_base_process** contains core process information and links to:
  - Rolling tasks via `taskid` (viamedagendafuture.id)
  - Rolling audits via `auditid` (viamedagendafuture.id)
  - Meeting agendas via `agendaid` (viamedagenda.id)
  - Intrastat menu items via `intrastatsmenun` (intrastatmenu.id)

### Issue Tracking
- **viamedagendahistory** tracks historical issues and links to:
  - Future/rolling issues via `autoissueid` (viamedagendafuture.id)
  - Users responsible for investigation via `investigateby` (pw.username)
- **viamedagendafuture** defines recurring issues/tasks with:
  - Target users via `target_user` (pw.username)
  - Recurrence patterns (months, weeks, days)

### Risk Management
- **ISO_job_titles_risks** associates risks with processes and:
  - Links to risk types via `typeid` (ISO_job_risks_types.id)
  - Tracks updates via `updatedby` (pw.id)
  - Records review dates via `reviewedon`
- **ISO_InterestedParties_risks** defines risks related to interested parties
- **ISO_InterestedParties_risk_process** links interested party risks to specific processes

### Training and Competence
- **ISO_training_tasks** records training completion for employees on processes
- **ISO_training_people** tracks which employees are enrolled in which courses
- **ISO_training_course** defines available training courses
- **ISO_training_docs** associates documents with training courses

### Document Management
- **ISO_quality_manual_processes** links processes to quality manual sections
- **ISO_quality_manual** contains ISO sections filtered by groups
- **ISO_quality_manual_filter_groups** categorizes quality manual sections by company
- **ISO_job_base_process_files** associates documents with processes
- **ISO_quality_manual_files** stores document metadata

### Company and Meeting Structure
- **ISO_job_base_process_companyid** links processes to companies
- **global_companys** defines company entities
- **viamedagenda** structures meeting agendas hierarchically (meeting -> section -> subsection)
- **ISO_job_titles** links to default meetings via `defaultmeeting`

### Interested Parties
- **ISO_InterestedParties** defines stakeholders affected by processes
- **ISO_job_base_process_interestedpartys** associates interested parties with processes
- **ISO_InterestedParties_risks** defines risks specific to interested parties

### Process Effectiveness and Review
- **ISO_job_base_process_effective_review** tracks effectiveness reviews of processes
- Links reviewers via `reviewedby` (pw.id) and processes via `processid`

## Key Integration Points for ISO 13485

### Roles and Responsibilities
- Job titles define organizational roles with hierarchical reporting
- Employees are assigned to titles, establishing clear responsibility chains
- Processes are assigned to titles, defining who is responsible for what

### Process Control
- Each process has defined tasks, audits, and risk assessments
- Training requirements ensure competent execution
- Document control maintains process documentation

### Issue and Risk Management
- Rolling issues ensure continuous monitoring
- Risk assessments cover likelihood, severity, and mitigation
- Interested parties are considered in risk evaluations

### Continuous Improvement
- Effectiveness reviews track process performance
- Historical issues provide learning opportunities
- Training records ensure ongoing competence

This relational structure supports the ISO 13485 requirements for quality management systems, ensuring traceability, responsibility, and continuous improvement across all organizational processes.