# Key Database Table Structures for Purchase Orders Processing

## viamedquote_purchase_orders

## `viamedquote_purchase_orders`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| hostcompanyid | int | NO |  |  |  |
| company_id | int | NO |  |  |  |
| contact_id | int | NO |  |  |  |
| addedby | int | NO |  |  |  |
| addedon | bigint | NO |  | 0 |  |
| status | varchar(32) | NO |  |  |  |
| senton | bigint | NO |  | 0 |  |
| sentby | int | NO |  |  |  |
| commitedon | bigint | NO |  | 0 |  |
| commitedby | int | NO |  |  |  |
| completedon | bigint | NO |  | 0 |  |
| completedby | int | NO |  |  |  |
| cancelledon | bigint | NO |  | 0 |  |
| cancelledby | int | NO |  |  |  |
| currency_id | int | NO |  |  |  |
| memonotes | longtext | NO |  |  |  |
| internalmemonotes | longtext | NO |  |  |  |
| hidememonotes | varchar(1) | NO |  | 0 |  |
| openedby | int | NO |  |  |  |
| openedon | bigint | NO |  | 0 |  |
| revisionid | int | NO |  | 0 |  |

## viamedquote_purchase_orders_details

## `viamedquote_purchase_orders_details`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| orderid | int | NO |  |  |  |
| stockref | varchar(26) | NO |  |  |  |
| qty | int | NO |  |  |  |
| qty_received | int | NO |  | 0 |  |
| price | float(10,2) | NO |  |  |  |
| supplierinvoiceprice | float(10,2) | NO |  | 0.00 |  |
| supplier_ref | varchar(64) | NO |  |  |  |
| supplier_description | varchar(200) | NO |  |  |  |
| requireddate | bigint | NO |  | 0 |  |
| memo | longtext | NO |  |  |  |
| addedby | int | NO |  |  |  |
| addedon | bigint | NO |  | 0 |  |
| supplierpriceby | int | NO |  |  |  |
| supplierpriceon | bigint | NO |  | 0 |  |
| remainingcancelled | bigint | NO |  | 0 |  |
| remainingcancelledby | int | NO |  |  |  |

## viamedquote_purchase_orders_editreason

## `viamedquote_purchase_orders_editreason`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| orderid | int | NO |  |  |  |
| addedby | int | NO |  |  |  |
| addedon | bigint | NO |  | 0 |  |
| revisionid | int | NO |  |  |  |
| reason | longtext | NO |  |  |  |

## viamed_customer_stock_references

## `viamed_customer_stock_references`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| companyid | int | NO |  |  |  |
| hostcompanyid | int | NO |  |  |  |
| stock_ref | varchar(26) | NO |  |  |  |
| customer_ref | varchar(64) | NO |  |  |  |
| customerdescription | varchar(200) | NO |  |  |  |
| rawprice | float(10,2) | NO |  |  |  |
| rawpricediscount | float(10,2) | NO |  | 0.00 |  |
| currenyid | int | NO |  |  |  |
| status | varchar(1) | NO |  | 2 |  |
| sordmemo | longtext | NO |  |  |  |
| addedby | int | NO |  |  |  |
| addedon | bigint | NO |  | 0 |  |
| updatedby | int | NO |  |  |  |
| updatedon | bigint | NO |  | 0 |  |

## global_companys_currencys

## `global_companys_currencys`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| hostcompanyid | int | NO |  |  |  |
| currency | varchar(3) | NO |  |  |  |
| description | varchar(64) | NO |  |  |  |
| symbol | varchar(8) | NO |  |  |  |
| active | tinyint | NO |  | 1 |  |
| addedby | int | NO |  |  |  |
| addedon | bigint | NO |  | 0 |  |

## supplier_items

## `supplier_items`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| POR | varchar(16) | NO |  |  |  |
| Stock_ref | varchar(26) | NO |  |  |  |
| Qty | int | NO |  |  |  |
| Order_complete | varchar(1) | NO |  | N |  |
| addedby | int | NO |  |  |  |
| addedon | bigint | NO |  | 0 |  |

## viamedquoteorderwatch

## `viamedquoteorderwatch`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| company_id | int | NO |  |  |  |
| userid | int | NO |  |  |  |
| status | varchar(16) | NO |  |  |  |
| ordertype | varchar(1) | NO |  |  |  |
| repeatwatch | varchar(1) | NO |  | 0 |  |
| addedby | int | NO |  |  |  |
| addedon | bigint | NO |  | 0 |  |

## ISO_supplier_reviews

## `ISO_supplier_reviews`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| cid | int | NO |  |  |  |
| completedon | bigint | NO |  | 0 |  |
| completedby | int | NO |  |  |  |
| reviewscore | int | NO |  |  |  |
| notes | longtext | NO |  |  |  |
| addedby | int | NO |  |  |  |
| addedon | bigint | NO |  | 0 |  |

## Serialnumbers

## `Serialnumbers`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| Stock_ref | varchar(255) | YES |  |  |  |
| Autocountsn | varchar(255) | YES |  |  |  |
| Textsn | varchar(255) | YES |  |  |  |
| Serialnumber | varchar(100) | NO |  |  |  |
| Datebookedin | varchar(255) | YES |  |  |  |
| Invoicenumber | varchar(100) | YES |  |  |  |
| Ordernumber | varchar(100) | YES |  |  |  |
| Bookedoutby | varchar(100) | YES |  |  |  |
| Bookedinby | varchar(100) | YES |  |  |  |
| Porref | varchar(100) | YES |  |  |  |
| usedescription | varchar(100) | YES |  |  |  |
| returned | varchar(100) | YES |  |  |  |
| batchnumber | varchar(100) | YES |  |  |  |
| batchdate | varchar(100) | YES |  |  |  |
| stocklocation | varchar(100) | NO |  |  |  |
| stocklocation2 | varchar(100) | NO |  |  |  |
| last_counted | varchar(100) | NO |  |  |  |
| Dateout | bigint | YES |  |  |  |
| reason | varchar(250) | NO |  |  |  |
| manufacture_date_code | varchar(16) | NO |  |  |  |
| manufacture_use_date | varchar(12) | NO |  |  |  |
| cost_price | varchar(12) | NO |  |  |  |
| total_cost_price | varchar(12) | NO |  |  |  |
| sell_price | varchar(12) | NO |  |  |  |
| modifiedby | varchar(32) | NO |  |  |  |
| inprintq | varchar(64) | NO |  |  |  |
| expiredate | bigint | NO |  | 0 |  |
| errorcheck | varchar(64) | NO |  |  |  |
| companyid | int | NO |  |  |  |
| connotes | varchar(16) | NO |  |  |  |
| gbp_buyprice | float(10,2) | NO |  |  |  |
| gbp_estshipcost | float(10,2) | NO |  |  |  |
| gbp_finalcost | float(10,2) | NO |  |  |  |
| originalenteredsn | varchar(64) | NO |  |  |  |
| goodsinbookid | int | NO |  |  |  |
| producedby | int | NO |  |  |  |
| shortmemo | varchar(250) | NO |  |  |  |
| calculatedexpdate | bigint | NO |  |  |  |
| crm_companyid | int | NO |  |  |  |
| Deliverynumber | int | NO |  |  |  |
| srsnumber | varchar(24) | NO |  |  |  |
| srsscanedtoby | varchar(24) | NO |  |  |  |
| srsscanedtoon | bigint | NO |  | 0 |  |
| valuestatus | int | NO |  |  |  |
| valuestatusby | int | NO |  |  |  |
| valuestatuson | bigint | NO |  | 0 |  |
| allocationid | int | NO |  |  |  |
| po_lineid | int | NO |  |  |  |
| serviceexchange | int | NO |  |  |  |
| serviceexchangememo | longtext | NO |  |  |  |

## stocklist_tarriffs

## `stocklist_tarriffs`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| stock_ref | varchar(64) | NO |  |  |  |
| tariff | varchar(16) | NO |  |  |  |
| spare | varchar(16) | NO |  |  |  |
| warranty_customer | varchar(12) | NO |  |  |  |
| warranty_supplier | varchar(12) | NO |  |  |  |
| warranty_distributor | varchar(12) | NO |  |  |  |
| ce_marking | varchar(10) | NO |  |  |  |
| ce_marking_standards | varchar(10) | NO |  |  |  |
| showdatecode | char(3) | NO |  |  |  |
| usebydatemonths | int | NO |  | 0 |  |
| weelabel | char(2) | NO |  |  |  |
| ean13 | varchar(26) | NO |  |  |  |
| qa_type | int | NO |  |  |  |
| attacheditems | varchar(3) | NO |  |  |  |
| equipment_type | varchar(96) | NO |  |  |  |
| ceclass | varchar(16) | NO |  |  |  |
| safclass | varchar(4) | NO |  |  |  |
| saftype | varchar(4) | NO |  |  |  |
| cmdclass | varchar(16) | NO |  |  |  |
| cefileid | int | NO |  |  |  |
| prelabeltext | longtext | NO |  |  |  |
| lastcost | varchar(24) | NO |  |  |  |
| natonumber | varchar(36) | NO |  |  |  |
| stock_value_tag | varchar(24) | NO |  |  |  |
| nhs_eclass | varchar(5) | NO |  |  |  |
| thumbnailurl | varchar(250) | NO |  |  |  |
| imageurl | varchar(250) | NO |  |  |  |
| enable_quick_serial | varchar(1) | NO |  |  |  |
| weetick | varchar(4) | NO |  |  |  |
| weeweight | varchar(12) | NO |  |  |  |
| weeconsumable | varchar(4) | NO |  |  |  |
| label_description | varchar(96) | NO |  |  |  |
| showfactorydate | varchar(5) | NO |  |  |  |
| creationdate | bigint | NO |  | 0 |  |
| allow_dupsn | tinyint(1) | NO |  |  |  |
| freecarriage | tinyint(1) | NO |  |  |  |
| ppq | varchar(32) | NO |  |  |  |
| audited | int | NO |  |  |  |
| nhscataloguecode | varchar(32) | NO |  |  |  |
| latex | varchar(3) | NO |  |  |  |
| coshh | varchar(3) | NO |  |  |  |
| electromedical | varchar(3) | NO |  |  |  |
| environmentallyfriendly | varchar(3) | NO |  |  |  |
| ethicallysourced | varchar(3) | NO |  |  |  |
| whilestockslast | varchar(3) | NO |  |  |  |
| updatedby | varchar(32) | NO |  |  |  |
| updatedon | bigint | NO |  | 0 |  |
| warranty_extendedtext | longtext | NO |  |  |  |
| uk_contract_price_percent | float(10,2) | NO |  |  |  |
| companyid | varchar(12) | NO |  |  |  |
| uk_contract_price_percent_addedby | varchar(32) | NO |  |  |  |
| uk_contract_price_percent_addedon | bigint | NO |  | 0 |  |
| minstock | int | NO |  |  |  |
| scrollbar | varchar(250) | NO |  |  |  |
| stock_count | int | NO |  |  |  |
| stock_cost | float | NO |  |  |  |
| po_stock_cost | float(12,4) | NO |  |  |  |
| stock_value | float | NO |  |  |  |
| GHX_description | varchar(250) | NO |  |  |  |
| freec | varchar(12) | NO |  |  |  |
| auditedon | bigint | NO |  | 0 |  |
| auditedby | varchar(64) | NO |  |  |  |
| pricedesc | longtext | NO |  |  |  |
| isrepaircode | varchar(5) | NO |  |  |  |
| duelsn | varchar(7) | NO |  |  |  |
| sellbydatemonthsfrombarcode | int | NO |  |  |  |
| reqarequiredmonths | int | NO |  |  |  |
| qrquicklink | varchar(1) | NO |  |  |  |
| stockvalidatedon | bigint | NO |  | 0 |  |
| stockvalidatedby | varchar(32) | NO |  |  |  |
| stockvisability | varchar(32) | NO |  |  |  |
| qaoperaadjust | varchar(1) | NO |  |  |  |
| GHX_description_extend | longtext | NO |  |  |  |
| countryoforigin | varchar(128) | NO |  |  |  |
| singlespartnumber | varchar(10) | NO |  |  |  |
| packsize | int | NO |  |  |  |
| rohs | varchar(3) | NO |  |  |  |
| rohsexlusion | varchar(12) | NO |  |  |  |
| mtbf | longtext | NO |  |  |  |
| orderedas | varchar(12) | NO |  |  |  |
| ingress | varchar(6) | NO |  |  |  |
| alternative1 | varchar(16) | NO |  |  |  |
| alternative2 | varchar(16) | NO |  |  |  |
| alternative3 | varchar(16) | NO |  |  |  |
| tempnote | longtext | NO |  |  |  |
| tempdate | bigint | NO |  | 0 |  |
| reach | varchar(3) | NO |  |  |  |
| docompatibility | varchar(1) | NO |  |  |  |
| gmdn | varchar(32) | NO |  |  |  |
| ghxuom | varchar(5) | NO |  |  |  |
| ghxuomdesc | varchar(10) | NO |  |  |  |
| groupstatus | varchar(32) | NO |  |  |  |
| corpsale | varchar(3) | NO |  |  |  |
| ghx_brand | varchar(32) | NO |  |  |  |
| ghx_mancode | varchar(24) | NO |  |  |  |
| permnote | longtext | NO |  |  |  |
| permdate | int | NO |  |  |  |
| techempid | int | NO |  |  |  |
| hiddennotes | longtext | NO |  |  |  |
| dehp | varchar(5) | NO |  |  |  |
| matchedpairs | varchar(3) | NO |  |  |  |
| matchpairspn | varchar(14) | NO |  |  |  |
| offsetallowed | varchar(5) | NO |  |  |  |
| outputdiff | varchar(5) | NO |  |  |  |
| checkpricedate | bigint | NO |  | 0 |  |
| qaformfullprint | varchar(3) | NO |  |  |  |
| regularforcasts | varchar(3) | NO |  |  |  |
| hostcompany_id | int | NO |  |  |  |
| SUPERSEDED | varchar(24) | NO |  |  |  |
| bundlepackagingallowed | int | NO |  |  |  |
| supportdateend | bigint | NO |  | 0 |  |
| availabledateend | bigint | NO |  | 0 |  |
| sntag | int | NO |  |  |  |
| descriptiveitemonly | int | NO |  |  |  |
| daystodeliver | int | NO |  |  |  |
| perishable_replace_months | int | NO |  |  |  |
| usertag | int | NO |  |  |  |
| servicable | varchar(3) | NO |  |  |  |
| servicable_partnumber | varchar(20) | NO |  |  |  |
| webimageurl | varchar(128) | NO |  |  |  |
| webimagefileid | int | NO |  |  |  |
| ce_docid | int | NO |  |  |  |
| requiresextraboxtoship | varchar(7) | NO |  |  |  |
| returnscountryoforigin | varchar(64) | NO |  |  |  |
| pickingnotes | longtext | NO |  |  |  |
| pricelistweight | int | NO |  |  |  |
| phthalate | varchar(3) | NO |  |  |  |
| specialsales | varchar(5) | NO |  |  |  |
| specialsales_rep | int | NO |  |  |  |
| operamemo | longtext | NO |  |  |  |
| newcustomeralerttext | longtext | NO |  |  |  |
| quicksrsturnaround | varchar(3) | NO |  |  |  |
| oemspecialsales | tinyint | NO |  |  |  |
| traininglevel | varchar(48) | NO |  |  |  |
| trainingcharge | varchar(48) | NO |  |  |  |
| trainingexplaination | longtext | NO |  |  |  |
| doewnotblockshipping | varchar(4) | NO |  |  |  |
| productstop | varchar(3) | NO |  |  |  |
| preproductionnotes | longtext | NO |  |  |  |
| qaweightcheck | int | NO |  |  |  |
| qaweightcheckrange | int | NO |  |  |  |
| repairturnaround | int | NO |  |  |  |
| rmareturntarriff | varchar(24) | NO |  |  |  |
| suppliernotes | longtext | NO |  |  |  |
| GHX_QOM | varchar(24) | NO |  |  |  |
| GHX_QOM_Description | varchar(48) | NO |  |  |  |
| ghx_manname | varchar(32) | NO |  |  |  |
| supreturns_customvalue | varchar(12) | NO |  |  |  |
| ghx_gln_supplier | varchar(16) | NO |  |  |  |
| ghx_gln_manufacturer | varchar(16) | NO |  |  |  |
| srsmemo | longtext | NO |  |  |  |
| srs_triage | longtext | NO |  |  |  |
| ncage | varchar(5) | NO |  |  |  |
| suppmoq | int | NO |  |  |  |
| lastsupplieroperaac | varchar(12) | NO |  |  |  |
| importtax | float(10,2) | NO |  |  |  |
| importfreight | float(10,2) | NO |  |  |  |
| suppdeldays | int | NO |  |  |  |
| suppdeldatesbacktoback | varchar(5) | NO |  |  |  |
| suppliergroup | varchar(250) | NO |  |  |  |
| catagorytype | varchar(64) | NO |  |  |  |
| shelflife | int | NO |  |  |  |
| hidefrompohm | tinyint | NO |  |  |  |
| manualcost | float(10,2) | NO |  |  |  |
| gs128notes | longtext | NO |  |  |  |
| cleanerpninternal | varchar(100) | NO |  |  |  |
| cleanercustomer | varchar(100) | NO |  |  |  |
| operadesc | varchar(40) | NO |  |  |  |
| suppliernotespo | longtext | NO |  |  |  |
| paperworkdescription | longtext | NO |  |  |  |
| singlebarcodeitem | tinyint | NO |  |  |  |
| nominalcode | varchar(8) | NO |  |  |  |
| nosaleineu | varchar(4) | NO |  |  |  |
| OperaDescription | varchar(128) | NO |  |  |  |
| HasBarcodeTracking | tinyint | NO |  |  |  |
| hiddensearch | longtext | NO |  |  |  |
| vatfree | tinyint | NO |  |  |  |
| image_docid | int | NO |  |  |  |
| distributionrights | int | NO |  |  |  |
| IsDeliveryInsuranceLine | tinyint | NO |  |  |  |
| pepolid | varchar(48) | NO |  |  |  |
| orderqtytobarcodes | int | NO |  |  |  |
| cebodynumber | varchar(12) | NO |  |  |  |
| serialnumber_lables_id | int | NO |  |  |  |
| aftersales | int | NO |  |  |  |
| DescriptionExtra | varchar(129) | NO |  |  |  |
| qapercent | varchar(16) | NO |  |  |  |
| riskassesmentdocid | int | NO |  |  |  |
| upsservicecode | varchar(3) | NO |  |  |  |
| addedby | int | NO |  |  |  |
| EUREP | varchar(36) | YES |  |  |  |
| UKREP | varchar(36) | YES |  |  |  |
| hidefromsystemreports | varchar(4) | NO |  | No |  |
| productiondocid | int | NO |  |  |  |
| feedbackemailbody | longtext | NO |  |  |  |
| iso_feedbackquestion | longtext | NO |  |  |  |
| mainstocklocation | int | NO |  |  |  |
| shopifyhandle | varchar(256) | NO |  |  |  |
| monthexpirestop | int | NO |  |  |  |
| usagetype | varchar(64) | NO |  |  |  |
| qadocumentid | int | NO |  |  |  |
| servicedocumentid | int | NO |  |  |  |
| ifudocid | int | NO |  |  |  |
| packingdocid | int | NO |  |  |  |
| techdocid | int | NO |  |  |  |
| officialshelflife | int | NO |  |  |  |
| importtariff | varchar(64) | NO |  |  |  |
| mhraregnumber | varchar(24) | NO |  |  |  |
| complianceimporter | int | NO |  |  |  |
| officialimportercid | int | NO |  |  |  |
| manufacturercid | int | NO |  |  |  |
| mhraregnumbercid | int | NO |  |  |  |
| umdns | varchar(32) | NO |  |  |  |
| firstonmarket | varchar(12) | NO |  |  |  |
| ecdirective | varchar(3) | NO |  |  |  |
| supportdate | varchar(12) | NO |  |  |  |
| workinglife | varchar(64) | NO |  |  |  |
| postdelinspection | int | NO |  |  |  |
| reprocessuse | varchar(4) | NO |  |  |  |
| reprocesscycles | varchar(11) | NO |  |  |  |
| datastorage | varchar(4) | NO |  |  |  |
| dataconnection | varchar(4) | NO |  |  |  |
| safetymeasures | varchar(4) | NO |  |  |  |
| performanceqatest | int | NO |  |  |  |
| supguarantee | varchar(12) | NO |  |  |  |
| labelbackdocid | int | NO |  |  |  |
| hostauthorityrefnumber | longtext | NO |  |  |  |
| sellablealarmlimit | int | NO |  |  |  |
| canreprocesscycles | varchar(4) | NO |  |  |  |
| decontamination | varchar(64) | NO |  |  |  |
| QAMeasures | varchar(32) | NO |  |  |  |
| manprodliabdocid | int | NO |  |  |  |
| goodsoutlabelid | int | NO |  |  |  |
| paqdocpackid | int | NO |  |  |  |
| cn22desc | varchar(64) | NO |  |  |  |
| cleandocid | int | NO |  |  |  |
| officialservicedocid | int | NO |  |  |  |
| EUDAMED | varchar(32) | NO |  |  |  |
| rohs2 | varchar(3) | NO |  |  |  |
| custrepreview | bigint | NO |  |  |  |
| xrefgroup | varchar(48) | NO |  |  |  |
| webstockoptions | int | NO |  |  |  |
| webstockqty | int | NO |  |  |  |
| webstockpercent | int | NO |  |  |  |
| goodsinproceduredocid | int | NO |  |  |  |
| extrasearch | longtext | NO |  |  |  |
| hideinvoicezeros | int | NO |  |  |  |
| minimumstoragetemperature | varchar(8) | NO |  |  |  |
| maximumstoragetemperature | varchar(8) | NO |  |  |  |
| minimumrelhumid | varchar(8) | NO |  |  |  |
| maximumrelhumid | varchar(8) | NO |  |  |  |
| feedbackurllink | varchar(128) | NO |  |  |  |
| shopifydesc | longtext | NO |  |  |  |
| shopifytitle | varchar(70) | NO |  |  |  |
| Shopify_Tag_String | varchar(200) | NO |  |  |  |
| Shopify_Product_Type | varchar(200) | NO |  |  |  |
| Shopify_SEO_Title | varchar(200) | NO |  |  |  |
| Shopify_SEO_Description | varchar(200) | NO |  |  |  |
| shopify_url_img | varchar(200) | NO |  |  |  |
| AI_FAQURL | varchar(128) | NO |  |  |  |
| exclusivetomemo | longtext | NO |  |  |  |
| fda_number | varchar(128) | NO |  |  |  |
| excludestockcount | tinyint | NO |  |  |  |
| allowpriceexport | tinyint | NO |  |  |  |

## viamedquoteaddress

## `viamedquoteaddress`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| ID | int | NO | PRI |  | auto_increment |
| ADDRESS1 | varchar(255) | YES |  |  |  |
| ADDRESS2 | varchar(255) | YES |  |  |  |
| ADDRESS3 | varchar(255) | YES |  |  |  |
| CITY | varchar(255) | YES |  |  |  |
| COMPANY | varchar(255) | YES |  |  |  |
| CONTACT | varchar(255) | YES |  |  |  |
| COUNTRY | varchar(255) | YES |  |  |  |
| INETADDR | varchar(255) | YES |  |  |  |
| KEY5 | varchar(255) | YES |  |  |  |
| PHONE1 | varchar(255) | YES |  |  |  |
| PHONE2 | varchar(255) | YES |  |  |  |
| FAX | varchar(200) | NO |  |  |  |
| STATE | varchar(255) | YES |  |  |  |
| TITLE | varchar(255) | YES |  |  |  |
| UPOSITION | varchar(255) | YES |  |  |  |
| ZIP | varchar(255) | YES |  |  |  |
| DEPARTMENT | varchar(255) | YES |  |  |  |
| NOTES | longtext | YES |  |  |  |
| FLAG | varchar(10) | NO |  |  |  |
| REGION | varchar(50) | NO |  |  |  |
| STATUS | varchar(100) | NO |  |  |  |
| HNHREP | varchar(50) | NO |  |  |  |
| REORDER | int | NO |  | 0 |  |
| OWNERGROUP | varchar(100) | NO |  |  |  |
| NHSREGION | varchar(100) | NO |  |  |  |
| hideme | varchar(100) | NO |  |  |  |
| contact_special_id | int | NO |  |  |  |
| contact_special_type | varchar(16) | NO |  |  |  |
| visitingnotes | longtext | NO |  |  |  |
| Company_reg_number | varchar(24) | NO |  |  |  |
| Vat_Number | varchar(24) | NO |  |  |  |
| contact_type | varchar(128) | NO |  |  |  |
| lostsalestag | varchar(200) | NO |  |  |  |
| lostsalesnotes | longtext | NO |  |  |  |
| alternativenames | longtext | NO |  |  |  |
| emailinvoices | varchar(5) | NO |  |  |  |
| debtornotes | varchar(250) | NO |  |  |  |
| googleidentifier | varchar(64) | NO |  |  |  |
| rmanotes | longtext | NO |  |  |  |
| website | varchar(200) | NO |  |  |  |
| companyid | int | NO |  |  |  |
| einvoicenotes | longtext | NO |  |  |  |
| checkingnotes | longtext | NO |  |  |  |
| checkingnotesby | int | NO |  |  |  |
| checkingnoteson | bigint | NO |  |  |  |
| orderconf1 | varchar(1) | NO |  |  |  |
| orderconf2 | varchar(1) | NO |  |  |  |
| einvoicesingles | varchar(1) | NO |  |  |  |
| invoice_company_id | int | NO |  |  |  |
| addedby | int | NO |  |  |  |
| addedon | bigint | NO |  |  |  |
| rep_company_id | int | NO |  |  |  |
| rep_contact_id | int | NO |  |  |  |
| mainconotes | longtext | NO |  |  |  |
| mainconotesby | int | NO |  |  |  |
| mainconoteson | bigint | NO |  |  |  |
| otheraccount | varchar(16) | NO |  |  |  |
| vat_exempt | int | NO |  |  |  |
| paymenttermsdefault | int | NO |  |  |  |
| deliverytermsdefault | int | NO |  |  |  |
| credittype | varchar(16) | NO |  |  |  |
| firstcontactcode | varchar(32) | NO |  |  |  |
| stoponaccount | int | NO |  |  |  |
| specialsalesflag | varchar(3) | NO |  |  |  |
| salesrep | int | NO |  |  |  |
| updatedby | int | NO |  |  |  |
| updatedon | bigint | NO |  |  |  |
| DL_TestField | varchar(12) | NO |  |  |  |
| goodinmemo | longtext | NO |  |  |  |
| hidefrompostock | smallint | NO |  |  |  |
| Invoice_Method | int | NO |  |  |  |
| glncode | varchar(24) | NO |  |  |  |
| stocksignedoffon | bigint | NO |  | 0 |  |
| stocksignedoffby | int | NO |  |  |  |
| Opera_Region | varchar(35) | NO |  |  |  |
| Opera_Territory | varchar(35) | NO |  |  |  |
| Opera_Cust_type | varchar(35) | NO |  |  |  |
| Opera_Cust_analy | varchar(6) | NO |  |  |  |
| Opera_Stat_account | varchar(20) | NO |  |  |  |
| Opera_Desp_method | varchar(35) | NO |  |  |  |
| Opera_Pricelist | varchar(12) | NO |  |  |  |
| Opera_Creditlimit | int | NO |  |  |  |
| Xero_contactname | varchar(100) | NO |  |  |  |
| ourpoaccount | varchar(48) | NO |  |  |  |
| incoterms | int | NO |  |  |  |
| incotermslocation | varchar(32) | NO |  |  |  |
| XeroInvoiceCompanyName | varchar(128) | NO |  |  |  |
| XeroInvoiceContactEmail | varchar(128) | NO |  |  |  |
| banksearch | varchar(128) | NO |  |  |  |
| operaclosingbalance | float(10,3) | NO |  |  |  |
| supplierpaymentdays | int | NO |  |  |  |
| ourpocurrency | int | NO |  |  |  |
| peppolid | varchar(48) | NO |  |  |  |
| xeroexportsuppliername | varchar(64) | NO |  |  |  |
| xeroexportcustomername | varchar(200) | NO |  |  |  |
| customereorinumber | varchar(24) | NO |  |  |  |
| issueicon | varchar(5) | NO |  |  |  |
| issueiconcolour | int | NO |  |  |  |
| allgoodslabelid | int | NO |  |  |  |
| restockmonths | int | NO |  |  |  |
| shopifyaddress | longtext | NO |  |  |  |
| delnotification | int | NO |  |  |  |
| deliverytermsdefaultconsign | varchar(128) | NO |  |  |  |
| supplierreviewrating | varchar(1) | NO |  |  |  |
| WILDIXPHONE | varchar(100) | NO |  |  |  |
| blacklist | varchar(64) | NO |  |  |  |
| distpreinsurance | int | NO |  |  |  |
| distformreturned | bigint | NO |  |  |  |
| distagreement | bigint | NO |  |  |  |
| linkedaddress | int | NO |  |  |  |
| feedbacksurvey | tinyint | NO |  |  |  |
| paymentroute | tinyint | NO |  |  |  |
| paymentroutenotes | longtext | NO |  |  |  |
| preferedcid | int | NO |  |  |  |
| transittimedays | int | NO |  |  |  |
| suppliermonthcutoff | int | NO |  |  |  |

## viamedquotecontact

## `viamedquotecontact`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| CONTACT | varchar(100) | NO |  |  |  |
| COUNTRY | varchar(100) | NO |  |  |  |
| INETADDR | varchar(100) | NO |  |  |  |
| PHONE1 | varchar(100) | NO |  |  |  |
| PHONE2 | varchar(100) | NO |  |  |  |
| FAX | varchar(100) | NO |  |  |  |
| TITLE | varchar(100) | NO |  |  |  |
| UPOSITION | varchar(100) | NO |  |  |  |
| ZIP | varchar(100) | NO |  |  |  |
| DEPARTMENT | varchar(100) | NO |  |  |  |
| FLAG | varchar(100) | NO |  |  |  |
| COMPANY_ID | int | NO |  | 0 |  |
| NOTES | longtext | NO |  |  |  |
| REPID | varchar(100) | NO |  |  |  |
| KEY5 | varchar(100) | NO |  |  |  |
| hideme | varchar(100) | NO |  |  |  |
| updatedon | varchar(100) | NO |  |  |  |
| MAILDEPT | varchar(32) | NO |  |  |  |
| mail | varchar(7) | NO |  |  |  |
| email | varchar(7) | NO |  |  |  |
| phone | varchar(7) | NO |  |  |  |
| hidemereason | varchar(64) | NO |  |  |  |
| addedby | varchar(32) | NO |  |  |  |
| iso | varchar(5) | NO |  |  |  |
| accountstatements | varchar(5) | NO |  |  |  |
| sendpricingupdates | varchar(5) | NO |  |  |  |
| emailinvoice | varchar(5) | NO |  |  |  |
| mobilenumber | varchar(32) | NO |  |  |  |
| addedon | bigint | NO |  | 0 |  |
| altdirectdial | varchar(32) | NO |  |  |  |
| extension | varchar(32) | NO |  |  |  |
| altextension | varchar(32) | NO |  |  |  |
| bleepnum | varchar(32) | NO |  |  |  |
| responsibility | varchar(78) | NO |  |  |  |
| GOLDMINEKEY | varchar(24) | NO |  |  |  |
| polog | varchar(5) | NO |  |  |  |
| remit | varchar(5) | NO |  |  |  |
| emailinvoicegoldmine | varchar(5) | NO |  |  |  |
| emailpricechanges | varchar(5) | NO |  |  |  |
| firstcontact | varchar(32) | NO |  |  |  |
| CleanPosition | varchar(64) | NO |  |  |  |
| xeroimported | tinyint | NO |  |  |  |
| allowso | tinyint | NO |  |  |  |
| hashcode | varchar(32) | YES |  |  |  |
| verifiedby | int | NO |  |  |  |
| verifiedon | bigint | NO |  |  |  |
| verifiedadminby | int | NO |  |  |  |
| verifiedadminon | bigint | NO |  |  |  |
| WILDIXPHONE | varchar(100) | NO |  |  |  |
| unsubscribeby | int | NO |  |  |  |
| unsubscribeon | bigint | NO |  |  |  |
| deliverynotification | tinyint | NO |  |  |  |

## global_companys

## `global_companys`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| name | varchar(64) | NO |  |  |  |
| fullname | varchar(64) | NO |  |  |  |
| add1 | varchar(64) | NO |  |  |  |
| add2 | varchar(64) | NO |  |  |  |
| add3 | varchar(64) | NO |  |  |  |
| add4 | varchar(64) | NO |  |  |  |
| postcode | varchar(64) | NO |  |  |  |
| country | varchar(128) | NO |  |  |  |
| tel | varchar(64) | NO |  |  |  |
| fax | varchar(64) | NO |  |  |  |
| email | varchar(64) | NO |  |  |  |
| stockcountdate | bigint | NO |  | 0 |  |
| operadocs | varchar(250) | NO |  |  |  |
| isodocs | varchar(250) | NO |  |  |  |
| isodocthumbs | varchar(250) | NO |  |  |  |
| privacymode | int | NO |  |  |  |
| docidlogo | int | NO |  |  |  |
| website | varchar(250) | NO |  |  |  |
| commrate | float(10,2) | NO |  |  |  |
| shippcharge | float(10,2) | NO |  |  |  |
| fixedcharge | float(10,2) | NO |  |  |  |
| vatrate | float(10,2) | NO |  |  |  |
| debtorsdone | int | NO |  |  |  |
| vatcode | varchar(16) | NO |  |  |  |
| bankaccountnumber | varchar(24) | NO |  |  |  |
| active | int | NO |  |  |  |
| termsandconditionslocation | varchar(200) | NO |  |  |  |
| bankname | varchar(64) | NO |  |  |  |
| banksortcode | varchar(12) | NO |  |  |  |
| bankaccount | varchar(24) | NO |  |  |  |
| bankiban | varchar(64) | NO |  |  |  |
| bankbic | varchar(32) | NO |  |  |  |
| templatecode | varchar(16) | NO |  |  |  |
| prefix | varchar(4) | NO |  |  |  |
| sendinvoicefromemail | varchar(100) | NO |  |  |  |
| companyregistrationnumber | varchar(128) | NO |  |  |  |
| accountsemail | varchar(128) | NO |  |  |  |
| accountsnameforinvoiceemail | varchar(64) | NO |  |  |  |
| feedbacklink | varchar(128) | NO |  |  |  |
| eori | varchar(36) | NO |  |  |  |
| insurancetrigger | int | NO |  |  |  |
| UTR | varchar(20) | NO |  |  |  |
| website_files | varchar(250) | NO |  |  |  |
| govgatewayid | varchar(16) | NO |  |  |  |
| govgatewaypw | varchar(32) | NO |  |  |  |
| gmaillogin | varchar(128) | NO |  |  |  |
| gmailcode_encrypted | varbinary(255) | YES |  |  |  |

## pw_companys

## `pw_companys`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| vui | int | NO |  |  |  |
| company_id | int | NO |  |  |  |
| addedon | bigint | NO |  |  |  |
| addedby | int | NO |  |  |  |
| adminmode | int | NO |  |  |  |
| useremail | varchar(128) | NO |  |  |  |
| purchaseorder | tinyint | NO |  |  |  |
| commitquote | tinyint | NO |  |  |  |
| passwordemail | varchar(64) | NO |  |  |  |
| updatestock | tinyint | NO |  |  |  |
| updatedocument | tinyint | NO |  |  |  |
| updatestaff | tinyint | NO |  |  |  |
| updatexref | tinyint | NO |  |  |  |
| updatecountryrules | int | NO |  |  |  |
| movestock | tinyint | NO |  |  |  |
| updatexero | tinyint | NO |  |  |  |
| quickpick | tinyint | NO |  |  |  |

## viamed_memos_history

## `viamed_memos_history`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| addedon | bigint | NO |  | 0 |  |
| addedby | int | NO |  |  |  |
| memotype | int | NO |  |  |  |
| memo | longtext | NO |  |  |  |
| opera | varchar(12) | NO |  |  |  |
| companyid | int | NO |  |  |  |
| contactid | int | NO |  |  |  |

## viamedagendahistory

## `viamedagendahistory`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| agendid | varchar(100) | NO |  |  |  |
| subject | varchar(200) | NO |  |  |  |
| notes | longtext | NO |  |  |  |
| completionnotes | longtext | NO |  |  |  |
| backorderstatus | varchar(64) | NO |  |  |  |
| chaired | varchar(100) | NO |  |  |  |
| investigateby | varchar(100) | NO |  |  |  |
| investigatedcomplete | bigint | NO |  |  |  |
| investigatenotes | longtext | NO |  |  |  |
| completed | varchar(100) | NO |  |  |  |
| resoleved | varchar(100) | NO |  |  |  |
| resultnotes | longtext | NO |  |  |  |
| createdate | bigint | NO |  |  |  |
| createpresent | varchar(100) | NO |  |  |  |
| completepresent | varchar(100) | NO |  |  |  |
| completedate | bigint | NO |  |  |  |
| createmeetingdate | bigint | NO |  |  |  |
| stock_ref | varchar(16) | NO |  |  |  |
| opera | varchar(10) | NO |  |  |  |
| porref | varchar(10) | NO |  |  |  |
| porreq | varchar(100) | NO |  |  |  |
| testfield | varchar(100) | NO |  |  |  |
| modified | varchar(100) | NO |  |  |  |
| Order_number | varchar(100) | NO |  |  |  |
| complete_pdf_location | varchar(100) | NO |  |  |  |
| showdueon | varchar(100) | NO |  |  |  |
| repeatduenext | varchar(100) | NO |  |  |  |
| viewed | varchar(10) | NO |  |  |  |
| user_highlight | char(3) | NO |  |  |  |
| deadline_date | varchar(100) | NO |  |  |  |
| hide_until | bigint | NO |  |  |  |
| priority | int | NO |  | 0 |  |
| historytrackid | varchar(100) | NO |  |  |  |
| updatetag | varchar(12) | NO |  |  |  |
| previous_issue | int | NO |  | 0 |  |
| stock_ref_tag | varchar(128) | NO |  |  |  |
| opera_tag | varchar(16) | NO |  |  |  |
| primary_issue | int | NO |  | 0 |  |
| hideupdates | char(2) | NO |  |  |  |
| informationonly | char(2) | NO |  |  |  |
| viamedquotecompanyid | int | NO |  |  |  |

## ISO_quality_manual_files

## `ISO_quality_manual_files`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| addedby | varchar(100) | NO |  |  |  |
| addedon | bigint | NO |  |  |  |
| docid | int | NO |  |  |  |
| docname | varchar(100) | NO |  |  |  |
| description | varchar(254) | NO |  |  |  |
| type | varchar(100) | NO |  |  |  |
| security | varchar(100) | NO |  |  |  |
| oldid | varchar(100) | NO |  |  |  |
| archived | varchar(100) | NO |  |  |  |
| update_reason | longtext | NO |  |  |  |
| filename | varchar(100) | NO |  |  |  |
| removedby | varchar(64) | NO |  |  |  |
| removedon | varchar(64) | NO |  |  |  |
| exp_date | bigint | NO |  | 0 |  |
| reviewed_date | bigint | NO |  | 0 |  |
| reviewed_by | varchar(64) | NO |  |  |  |
| thumb_nail | varchar(24) | NO |  |  |  |
| pages | int | NO |  | 0 |  |
| link_code | varchar(12) | NO |  |  |  |
| companyid | varchar(32) | NO |  |  |  |
| review_timer | bigint | NO |  |  |  |
| md5hash | varchar(255) | NO |  |  |  |
| isostandard | varchar(1) | NO |  |  |  |
| downloadname | varchar(124) | NO |  |  |  |
| pdftext | longtext | NO |  |  |  |
| serialbarcode | int | NO |  |  |  |
| srsnumber | varchar(16) | NO |  |  |  |
| srnnumber | varchar(16) | NO |  |  |  |
| exp_date_ignore | int | NO |  |  |  |
| searchextra | longtext | NO |  |  |  |
| hostcompany | int | NO |  |  |  |
| documentexplain | longtext | NO |  |  |  |
| draftdocument | int | NO |  |  |  |
| draftupdatetodocid | int | NO |  |  |  |
| draftrevision | int | NO |  |  |  |
| sornumber | int | NO |  |  |  |
| interestedparty | int | NO |  |  |  |
| qualitymanual | int | NO |  |  |  |
| qualitymanualprimaryid | int | NO |  |  |  |
| primaryaudit | varchar(3) | NO |  |  |  |
| primarycop | int | NO |  |  |  |
| revisionconrtol | varchar(64) | NO |  |  |  |
| essencialreq | tinyint | NO |  |  |  |
| porref | varchar(24) | NO |  |  |  |
| salesorderid | int | NO |  |  |  |
| purchaseorderid | int | NO |  |  |  |
| pricelistcode | varchar(12) | NO |  |  |  |
| riskassesmentdocid | int | NO |  |  |  |
| alarmexpire | int | NO |  |  |  |
| alarmexpireuser | int | NO |  |  |  |
| alarmdate | bigint | NO |  |  |  |
| scope | longtext | NO |  |  |  |
| hsearealink | int | NO |  |  |  |
| employeeid | int | NO |  |  |  |
| external_revision_ref | varchar(128) | NO |  |  |  |
| contactdontchase | tinyint | NO |  |  |  |
| contactdontchaseby | int | NO |  |  |  |
| contactdontchaseon | bigint | NO |  |  |  |
| downloadcount | int | NO |  |  |  |
| AI_reviewedon | bigint | NO |  |  |  |
| AI_raw | longtext | NO |  |  |  |
| AI_status | int | NO |  |  |  |
| AI_conversationid | int | YES |  | NULL |  |
| AI_fileid | int | YES |  | NULL |  |
| AI_summary | longtext | NO |  |  |  |
| AI_summary_status | int | NO |  | 0 |  |
| returnboxid | int | NO |  |  |  |