# Key Database Table Structures

## viamedquote_orders

## `viamedquote_orders`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| company_id | int | NO |  |  |  |
| contact_id | int | NO |  |  |  |
| order_stage | int | NO |  |  |  |
| createdon | bigint | NO |  |  |  |
| createdby | int | NO |  |  |  |
| hostcompany | int | NO |  |  |  |
| host_order_id | varchar(64) | NO |  |  |  |
| confirmedby | int | NO |  |  |  |
| confirmedon | bigint | NO |  |  |  |
| customer_ref | varchar(128) | NO |  |  |  |
| priority | int | NO |  |  |  |
| due | bigint | NO |  | 0 |  |
| modifiedby | int | NO |  |  |  |
| modifiedon | bigint | NO |  |  |  |
| delivery_company_id | int | NO |  |  |  |
| po_docid | int | NO |  |  |  |
| del_docid | int | NO |  |  |  |
| sentclickedon | bigint | NO |  |  |  |
| sentclickedby | int | NO |  |  |  |
| invoice_company_id | int | NO |  |  |  |
| quote_proforma | int | NO |  |  |  |
| delayedinvoice | bigint | NO |  | 0 |  |
| iscreditnote | int | NO |  |  |  |
| notes | longtext | NO |  |  |  |
| vatexempt | int | NO |  |  |  |
| deletedby | int | NO |  | 0 |  |
| deletedon | bigint | NO |  | 0 |  |
| originalhost | int | NO |  | 0 |  |
| incoterms | int | NO |  |  |  |
| incotermslocation | varchar(32) | NO |  |  |  |
| contact_id_tel | varchar(24) | NO |  |  |  |
| quotevaliduntil | bigint | NO |  |  |  |
| cancelleddate | bigint | NO |  |  |  |
| cancelledby | int | NO |  |  |  |
| cancelledreason | longtext | NO |  |  |  |
| wasaquoteproforma | int | NO |  |  |  |
| wasaquoteproformaby | int | NO |  |  |  |
| wasaquoteproformaon | bigint | NO |  |  |  |
| prepaid | tinyint | NO |  |  |  |
| paperworkmemo | longtext | NO |  |  |  |
| signofascompleteby | int | NO |  |  |  |
| signofascompleteon | bigint | NO |  |  |  |
| reviewedby | int | NO |  |  |  |
| reviewedon | bigint | NO |  |  |  |
| paperworkname | int | NO |  |  |  |
| enduser_contact_id | int | NO |  |  |  |
| pndocid | int | NO |  |  |  |
| proformapaidon | bigint | NO |  |  |  |
| proformapaidby | int | NO |  |  |  |
| multipledeliveryids | int | NO |  |  |  |
| customer_ref_extra | varchar(128) | NO |  |  |  |
| countasreal | int | NO |  |  |  |
| partship | int | NO |  |  |  |
| shipready | int | NO |  |  |  |
| checkingstartedon | bigint | NO |  |  |  |
| checkingstartedby | int | NO |  |  |  |
| holdinvoices | tinyint | NO |  |  |  |
| autocredit | bigint | NO |  | 0 |  |
| visapayment | tinyint | NO |  |  |  |
| mailingscalculated | bigint | NO |  | 0 |  |
| holdpicking | tinyint | NO |  |  |  |
| quoteagreedby | int | NO |  |  |  |
| quoteagreedon | bigint | NO |  |  |  |
| ccpaidby | int | NO |  |  |  |
| ccpaidon | bigint | NO |  |  |  |
| preweights | longtext | NO |  |  |  |
| partpaid | tinyint | NO |  |  |  |
| insuranceagreed | int | NO |  |  |  |
| marketingindexid | int | NO |  |  |  |
| ordersource | varchar(32) | NO |  |  |  |
| deletedchasedby | int | NO |  |  |  |
| deletedchasedon | bigint | NO |  |  |  |
| clonedorderid | int | NO |  |  |  |
| clonedby | int | NO |  |  |  |
| clonedon | bigint | NO |  |  |  |
| customerconfirmationsenton | bigint | NO |  |  |  |
| customerconfirmationsentby | int | NO |  |  |  |
| quotesenton | bigint | NO |  |  |  |
| quotesentby | int | NO |  |  |  |
| proformasenton | bigint | NO |  |  |  |
| proformasentby | int | NO |  |  |  |

-e 
## viamedquote_orders_details
## `viamedquote_orders_details`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| orderid | int | NO |  |  |  |
| stockref | varchar(26) | NO |  |  |  |
| qty | int | NO |  |  |  |
| qty_shipped | int | NO |  |  |  |
| addedby | int | NO |  |  |  |
| addedon | bigint | NO |  |  |  |
| modifiedby | int | NO |  |  |  |
| modifiedon | bigint | NO |  |  |  |
| unitprice | float(10,2) | NO |  |  |  |
| vat_exempt | int | NO |  |  |  |
| desctriptiveitem | varchar(200) | NO |  |  |  |
| memo | longtext | NO |  |  |  |
| duedate | bigint | NO |  |  |  |
| pricelist | varchar(8) | NO |  |  |  |
| paperworkorder | int | NO |  |  |  |
| qtycancelled | int | NO |  |  |  |
| qtycancelledon | bigint | NO |  |  |  |
| qtycancelledby | int | NO |  |  |  |
| backorderstatustext | varchar(64) | NO |  |  |  |
| backorderstatuson | bigint | NO |  |  |  |
| backorderstatusby | int | NO |  |  |  |
| issueid | int | NO |  |  |  |
| custinformdateon | bigint | NO |  |  |  |
| original_del_date | bigint | NO |  |  |  |
| current_del_date | bigint | NO |  |  |  |
| custinformdateby | int | NO |  |  |  |

## `viamedquote_orders_editreason`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| orderid | int | NO |  | 0 |  |
| addedby | int | NO |  | 0 |  |
| addedon | bigint | NO |  | 0 |  |
| originalby | int | NO |  |  |  |
| originalon | bigint | NO |  | 0 |  |
| reason | longtext | NO |  |  |  |
| reviewedon | int | NO |  |  |  |
| reviewedby | int | NO |  |  |  |
| cleanreason | varchar(128) | NO |  |  |  |
| openfault | varchar(32) | NO |  |  |  |
| hostcompanyid | int | NO |  |  |  |

## `viamedquote_orders_editreason_clean`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| addedby | int | NO |  |  |  |
| addedon | bigint | NO |  |  |  |
| dirtyreason | longtext | NO |  |  |  |
| cleanreason | varchar(128) | NO |  |  |  |
| openfault | varchar(32) | NO |  |  |  |
| reasoncode | varchar(64) | NO |  |  |  |

## `viamedquote_orders_incoterms`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| code | varchar(3) | NO |  |  |  |
| description | varchar(64) | NO |  |  |  |
| active | int | NO |  |  |  |
| addedby | int | NO |  |  |  |
| addedon | bigint | NO |  | 0 |  |
| placeof | varchar(20) | NO |  |  |  |
| extnotes | longtext | NO |  |  |  |

-e 
## viamedquote_orders_deliverys
## `viamedquote_orders_deliverys`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| ordernumber | varchar(32) | NO |  |  |  |
| deliverynumber | int | NO |  |  |  |
| deliverydocid | int | NO |  |  |  |
| invoicedon | bigint | NO |  | 0 |  |
| invoiceby | int | NO |  |  |  |
| invoiceref | varchar(12) | NO |  |  |  |
| trackingnumber | varchar(128) | NO |  |  |  |
| trackingaddedby | int | NO |  |  |  |
| trackingaddedon | bigint | NO |  | 0 |  |
| numberparcels | int | NO |  |  |  |
| weightsmemo | longtext | NO |  |  |  |
| stopinvoice | int | NO |  |  |  |
| stopdeliveryconfirmation | int | NO |  |  |  |
| shipoption | varchar(128) | NO |  |  |  |
| deliveredon | bigint | NO |  | 0 |  |
| deliveredby | int | NO |  |  |  |
| deliveryconfirmationby | int | NO |  |  |  |
| deliveryconfirmationon | bigint | NO |  | 0 |  |
| deliveryconfirmationsentto | varchar(128) | NO |  |  |  |
| giventoshipperon | bigint | NO |  | 0 |  |
| giventoshipperby | int | NO |  |  |  |
| hiddenmemo | varchar(200) | NO |  |  |  |
| multiple_delivery_company_id | int | NO |  |  |  |
| finalweight | varchar(5) | NO |  |  |  |
| upspackcode | varchar(35) | NO |  |  |  |
| incoterms | int | NO |  |  |  |
| incotermslocation | varchar(96) | NO |  |  |  |

-e 
## viamedquote_orders_invoices
## `viamedquote_orders_invoices`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| orderid | int | NO |  |  |  |
| deliveryid | int | NO |  |  |  |
| invoiceref | varchar(12) | NO |  |  |  |
| goodstotal | float(10,2) | NO |  |  |  |
| vattotal | float(10,2) | NO |  |  |  |
| invoicetotal | float(10,2) | NO |  |  |  |
| paidflag | bigint | NO |  | 0 |  |
| paidby | int | NO |  |  |  |
| paidon | bigint | NO |  |  |  |
| paidamount | float(10,2) | NO |  |  |  |
| invoicecommitedon | bigint | NO |  |  |  |
| commitedby | int | NO |  |  |  |
| invoicesenttocustomeron | bigint | NO |  |  |  |
| invoicesenttocustomerby | int | NO |  |  |  |
| invoicesentby | varchar(12) | NO |  |  |  |
| invoicesenttosalesrep | int | NO |  |  |  |
| invoicesenttosalesrepon | bigint | NO |  |  |  |
| invoicesenttosalesrepby | int | NO |  |  |  |
| creditid | int | NO |  |  |  |
| creditnoteby | int | NO |  |  |  |
| creditnoteon | bigint | NO |  |  |  |
| receiptid | int | NO |  |  |  |
| hostcompanyid | int | NO |  |  |  |
| xero_commitedon | bigint | NO |  |  |  |
| xero_commitedby | int | NO |  |  |  |
| xero_commitedfile | varchar(128) | NO |  |  |  |
| autodatecredits | bigint | NO |  | 0 |  |
| operafilesupdated | bigint | NO |  | 0 |  |
| companyid | int | NO |  |  |  |

-e 
## Serialnumbers
## `Serialnumbers`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| Stock_ref | varchar(255) | YES |  |  |  |
| Autocountsn | varchar(255) | YES |  |  |  |
| Textsn | varchar(255) | YES |  |  |  |
| Serialnumber | varchar(100) | NO |  |  |  |
| Datebookedin | varchar(255) | YES |  |  |  |
| Invoicenumber | varchar(100) | YES |  |  |  |
| Ordernumber | varchar(100) | YES |  |  |  |
| Bookedoutby | varchar(100) | YES |  |  |  |
| Bookedinby | varchar(100) | YES |  |  |  |
| Porref | varchar(100) | YES |  |  |  |
| usedescription | varchar(100) | YES |  |  |  |
| returned | varchar(100) | YES |  |  |  |
| batchnumber | varchar(100) | YES |  |  |  |
| batchdate | varchar(100) | YES |  |  |  |
| stocklocation | varchar(100) | NO |  |  |  |
| stocklocation2 | varchar(100) | NO |  |  |  |
| last_counted | varchar(100) | NO |  |  |  |
| Dateout | bigint | YES |  |  |  |
| reason | varchar(250) | NO |  |  |  |
| manufacture_date_code | varchar(16) | NO |  |  |  |
| manufacture_use_date | varchar(12) | NO |  |  |  |
| cost_price | varchar(12) | NO |  |  |  |
| total_cost_price | varchar(12) | NO |  |  |  |
| sell_price | varchar(12) | NO |  |  |  |
| modifiedby | varchar(32) | NO |  |  |  |
| inprintq | varchar(64) | NO |  |  |  |
| expiredate | bigint | NO |  | 0 |  |
| errorcheck | varchar(64) | NO |  |  |  |
| companyid | int | NO |  |  |  |
| connotes | varchar(16) | NO |  |  |  |
| gbp_buyprice | float(10,2) | NO |  |  |  |
| gbp_estshipcost | float(10,2) | NO |  |  |  |
| gbp_finalcost | float(10,2) | NO |  |  |  |
| originalenteredsn | varchar(64) | NO |  |  |  |
| goodsinbookid | int | NO |  |  |  |
| producedby | int | NO |  |  |  |
| shortmemo | varchar(250) | NO |  |  |  |
| calculatedexpdate | bigint | NO |  |  |  |
| crm_companyid | int | NO |  |  |  |
| Deliverynumber | int | NO |  |  |  |
| srsnumber | varchar(24) | NO |  |  |  |
| srsscanedtoby | varchar(24) | NO |  |  |  |
| srsscanedtoon | bigint | NO |  | 0 |  |
| valuestatus | int | NO |  |  |  |
| valuestatusby | int | NO |  |  |  |
| valuestatuson | bigint | NO |  | 0 |  |
| allocationid | int | NO |  |  |  |
| po_lineid | int | NO |  |  |  |
| serviceexchange | int | NO |  |  |  |
| serviceexchangememo | longtext | NO |  |  |  |

-e 
## serialnumberpicking
## `serialnumberpicking`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| stock_ref | varchar(100) | NO |  |  |  |
| serialnumberid | int | NO |  |  |  |
| pickedby | varchar(100) | NO |  |  |  |
| pickedon | bigint | NO |  |  |  |
| ordernumber | varchar(100) | NO |  |  |  |
| matchedon | bigint | NO |  |  |  |
| status | varchar(100) | NO |  |  |  |
| serialnumber | varchar(64) | NO |  |  |  |
| deliveryprinted | tinyint | NO |  |  |  |
| deliverynumber | int | NO |  |  |  |
| lineid | int | NO |  |  |  |

## `serialnumberprintq`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| stockref | varchar(100) | NO |  |  |  |
| barcodeid | varchar(100) | NO |  |  |  |
| description | varchar(100) | NO |  |  |  |
| datebookedin | varchar(100) | NO |  |  |  |
| name | varchar(100) | NO |  |  |  |
| serialnumber | varchar(100) | NO |  |  |  |

## `serialnumbers_cleared`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| ord | varchar(12) | NO |  |  |  |
| inv | varchar(12) | NO |  |  |  |
| dateout | bigint | NO |  | 0 |  |
| reason | varchar(250) | NO |  |  |  |
| bookedoutby | varchar(32) | NO |  |  |  |
| clearedby | varchar(32) | NO |  |  |  |
| clearedon | bigint | NO |  | 0 |  |

## `serialnumbers_instock`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| barcode | int | NO |  |  |  |
| yearend | int | NO |  |  |  |
| stkref | varchar(24) | NO |  |  |  |
| hostcompanyid | int | NO |  |  |  |
| instockon | bigint | NO |  | 0 |  |
| instockby | int | NO |  |  |  |
| serialnumber | varchar(64) | NO |  |  |  |
| valuestatus | int | NO |  |  |  |
| value_tag | varchar(64) | NO |  |  |  |

## `serialnumbers_instock_totals`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO |  |  |  |
| timestamp | bigint | NO |  | 0 |  |
| valuetotal | int | NO |  |  |  |
| hostcompanyid | int | NO |  |  |  |

## `serialnumbers_logfile`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| header_flag | char(1) | NO |  |  |  |
| stock_ref | varchar(10) | NO |  |  |  |
| barcodeid | int | NO |  | 0 |  |
| record_type | varchar(10) | NO |  |  |  |
| date_created | varchar(100) | NO |  |  |  |
| date_modified | varchar(100) | NO |  |  |  |
| date_record_sealed | varchar(100) | NO |  |  |  |

## `serialnumbers_tracesrs`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| barcode | int | NO |  |  |  |
| issueto | int | NO |  |  |  |
| addedon | bigint | NO |  | 0 |  |
| addedby | int | NO |  |  |  |
| notes | longtext | NO |  |  |  |
| active | bigint | NO |  | 0 |  |

## `serialnumberscombined`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| stock_ref_combined | varchar(100) | NO |  |  |  |
| stock_ref_item | varchar(100) | NO |  |  |  |

## `serialnumberstocktake`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| serialid | varchar(100) | NO |  |  |  |
| date | bigint | NO |  | 0 |  |
| status | varchar(100) | NO |  |  |  |
| stock_ref | varchar(100) | NO |  |  |  |
| serialnumber | varchar(100) | NO |  |  |  |
| countedby | varchar(100) | NO |  |  |  |
| locationid | int | NO |  |  |  |
| errorcheck | varchar(12) | NO |  |  |  |
| calcloc | int | NO |  |  |  |
| prndate | varchar(16) | NO |  |  |  |

## `shopify_product_details`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| stock_ref | varchar(64) | NO |  |  |  |
| Variant_SKU | varchar(64) | NO |  |  |  |
| Handle | varchar(255) | YES |  |  |  |
| Title | varchar(255) | YES |  |  |  |
| Body_HTML | longtext | YES |  |  |  |
| Vendor | varchar(255) | YES |  |  |  |
| Product_Category | varchar(255) | YES |  |  |  |
| Type | varchar(255) | YES |  |  |  |
| Tags | varchar(255) | YES |  |  |  |
| Published | varchar(255) | YES |  |  |  |
| Option1_Name | varchar(255) | YES |  |  |  |
| Option1_Value | varchar(255) | YES |  |  |  |
| Option1_Linked_To | varchar(255) | YES |  |  |  |
| Option2_Name | varchar(255) | YES |  |  |  |
| Option2_Value | varchar(255) | YES |  |  |  |
| Option2_Linked_To | varchar(255) | YES |  |  |  |
| Option3_Name | varchar(255) | YES |  |  |  |
| Option3_Value | varchar(255) | YES |  |  |  |
| Option3_Linked_To | varchar(255) | YES |  |  |  |
| Variant_Grams | varchar(255) | YES |  |  |  |
| Variant_Inventory_Tracker | varchar(255) | YES |  |  |  |
| Variant_Inventory_Qty | varchar(255) | YES |  |  |  |
| Variant_Inventory_Policy | varchar(255) | YES |  |  |  |
| Variant_Fulfillment_Service | varchar(255) | YES |  |  |  |
| Variant_Price | varchar(255) | YES |  |  |  |
| Variant_Compare_At_Price | varchar(255) | YES |  |  |  |
| Variant_Requires_Shipping | varchar(255) | YES |  |  |  |
| Variant_Taxable | varchar(255) | YES |  |  |  |
| Variant_Barcode | varchar(255) | YES |  |  |  |
| Image_Src | varchar(255) | YES |  |  |  |
| Image_Position | varchar(255) | YES |  |  |  |
| Image_Alt_Text | varchar(255) | YES |  |  |  |
| Gift_Card | varchar(255) | YES |  |  |  |
| SEO_Title | varchar(255) | YES |  |  |  |
| SEO_Description | varchar(255) | YES |  |  |  |
| Google_Shopping__Google_Product_Category | varchar(255) | YES |  |  |  |
| Google_Shopping__Gender | varchar(255) | YES |  |  |  |
| Google_Shopping__Age_Group | varchar(255) | YES |  |  |  |
| Google_Shopping__MPN | varchar(255) | YES |  |  |  |
| Google_Shopping__Condition | varchar(255) | YES |  |  |  |
| Google_Shopping__Custom_Product | varchar(255) | YES |  |  |  |
| Google_Shopping__Custom_Label_0 | varchar(255) | YES |  |  |  |
| Google_Shopping__Custom_Label_1 | varchar(255) | YES |  |  |  |
| Google_Shopping__Custom_Label_2 | varchar(255) | YES |  |  |  |
| Google_Shopping__Custom_Label_3 | varchar(255) | YES |  |  |  |
| Google_Shopping__Custom_Label_4 | varchar(255) | YES |  |  |  |
| Google_Custom_Product_productmetafieldsmmgoogleshoppingcusto | varchar(255) | YES |  |  |  |
| Complementary_products_productmetafieldsshopifydiscoveryprod | varchar(255) | YES |  |  |  |
| Related_products_productmetafieldsshopifydiscoveryproduct_re | varchar(255) | YES |  |  |  |
| Related_products_settings_productmetafieldsshopifydiscoveryp | varchar(255) | YES |  |  |  |
| Variant_Image | varchar(255) | YES |  |  |  |
| Variant_Weight_Unit | varchar(255) | YES |  |  |  |
| Variant_Tax_Code | varchar(255) | YES |  |  |  |
| Cost_per_item | varchar(255) | YES |  |  |  |
| Included__United_Kingdom | varchar(255) | YES |  |  |  |
| Price__United_Kingdom | varchar(255) | YES |  |  |  |
| Compare_At_Price__United_Kingdom | varchar(255) | YES |  |  |  |
| Included__International | varchar(255) | YES |  |  |  |
| Price__International | varchar(255) | YES |  |  |  |
| Compare_At_Price__International | varchar(255) | YES |  |  |  |
| Status | varchar(255) | YES |  |  |  |
| IntrastatsControl | varchar(255) | YES |  |  |  |

## `special_cab_returns`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| OperaAccount | varchar(8) | NO |  |  |  |
| Serialnumber | varchar(32) | NO |  |  |  |
| BarcodeID | varchar(16) | NO |  |  |  |
| NuferRMA | varchar(16) | NO |  |  |  |
| date | varchar(16) | NO |  |  |  |
| by | varchar(32) | NO |  |  |  |
| viamedbox | int | NO |  |  |  |

## `specialprices`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| Pricelist | varchar(8) | NO |  |  |  |
| Stock_ref | varchar(32) | NO |  |  |  |
| Price | varchar(100) | NO |  | 0 |  |
| qb1 | varchar(100) | NO |  |  |  |
| qb2 | varchar(100) | NO |  |  |  |
| qb3 | varchar(100) | NO |  |  |  |
| qb4 | varchar(100) | NO |  |  |  |
| qb5 | varchar(100) | NO |  |  |  |
| qb6 | varchar(100) | NO |  |  |  |
| qb7 | varchar(100) | NO |  |  |  |
| qb8 | varchar(100) | NO |  |  |  |
| qb9 | varchar(100) | NO |  |  |  |
| qb10 | varchar(100) | NO |  |  |  |
| qb1sp | varchar(100) | NO |  |  |  |
| qb2sp | varchar(100) | NO |  |  |  |
| qb3sp | varchar(100) | NO |  |  |  |
| qb4sp | varchar(100) | NO |  |  |  |
| qb5sp | varchar(100) | NO |  |  |  |
| qb6sp | varchar(100) | NO |  |  |  |
| qb7sp | varchar(100) | NO |  |  |  |
| qb8sp | varchar(100) | NO |  |  |  |
| qb9sp | varchar(100) | NO |  |  |  |
| qb10sp | varchar(100) | NO |  |  |  |
| Currency | varchar(10) | NO |  |  |  |
| D | varchar(4) | NO |  |  |  |
| company | varchar(12) | NO |  |  |  |
| hostcompanyid | int | NO |  |  |  |
| cd_nsell | varchar(16) | NO |  |   |  |
| cd_ndate | varchar(16) | NO |  |   |  |
| helduntil | bigint | NO |  |  |  |
| publishdate | bigint | NO |  |  |  |
| id | int | NO | PRI |  | auto_increment |
| reviewdate | bigint | NO |  |  |  |

## `specialprices_extranotes`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| pricelist | varchar(4) | NO |  |  |  |
| company | int | NO |  |  |  |
| notes | longtext | NO |  |  |  |

## `specialprices_held`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| Pricelist | varchar(8) | NO |  |  |  |
| Stock_ref | varchar(16) | NO |  |  |  |
| Price | varchar(100) | NO |  | 0 |  |
| qb1 | varchar(100) | NO |  |  |  |
| qb2 | varchar(100) | NO |  |  |  |
| qb3 | varchar(100) | NO |  |  |  |
| qb4 | varchar(100) | NO |  |  |  |
| qb5 | varchar(100) | NO |  |  |  |
| qb6 | varchar(100) | NO |  |  |  |
| qb7 | varchar(100) | NO |  |  |  |
| qb8 | varchar(100) | NO |  |  |  |
| qb9 | varchar(100) | NO |  |  |  |
| qb10 | varchar(100) | NO |  |  |  |
| qb1sp | varchar(100) | NO |  |  |  |
| qb2sp | varchar(100) | NO |  |  |  |
| qb3sp | varchar(100) | NO |  |  |  |
| qb4sp | varchar(100) | NO |  |  |  |
| qb5sp | varchar(100) | NO |  |  |  |
| qb6sp | varchar(100) | NO |  |  |  |
| qb7sp | varchar(100) | NO |  |  |  |
| qb8sp | varchar(100) | NO |  |  |  |
| qb9sp | varchar(100) | NO |  |  |  |
| qb10sp | varchar(100) | NO |  |  |  |
| Currency | varchar(10) | NO |  |  |  |
| D | varchar(4) | NO |  |  |  |
| company | varchar(12) | NO |  |  |  |
| hostcompany_id | int | NO |  |  |  |
| helduntil | int | NO |  |  |  |

## `specialprices_history`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| Pricelist | varchar(8) | NO |  |  |  |
| Stock_ref | varchar(32) | NO |  |  |  |
| Price | varchar(100) | NO |  | 0 |  |
| qb1 | varchar(100) | NO |  |  |  |
| qb2 | varchar(100) | NO |  |  |  |
| qb3 | varchar(100) | NO |  |  |  |
| qb4 | varchar(100) | NO |  |  |  |
| qb5 | varchar(100) | NO |  |  |  |
| qb6 | varchar(100) | NO |  |  |  |
| qb7 | varchar(100) | NO |  |  |  |
| qb8 | varchar(100) | NO |  |  |  |
| qb9 | varchar(100) | NO |  |  |  |
| qb10 | varchar(100) | NO |  |  |  |
| qb1sp | varchar(100) | NO |  |  |  |
| qb2sp | varchar(100) | NO |  |  |  |
| qb3sp | varchar(100) | NO |  |  |  |
| qb4sp | varchar(100) | NO |  |  |  |
| qb5sp | varchar(100) | NO |  |  |  |
| qb6sp | varchar(100) | NO |  |  |  |
| qb7sp | varchar(100) | NO |  |  |  |
| qb8sp | varchar(100) | NO |  |  |  |
| qb9sp | varchar(100) | NO |  |  |  |
| qb10sp | varchar(100) | NO |  |  |  |
| Currency | varchar(10) | NO |  |  |  |
| D | varchar(4) | NO |  |  |  |
| company | varchar(12) | NO |  |  |  |
| hostcompanyid | int | NO |  |  |  |
| cd_nsell | varchar(16) | NO |  |  |  |
| cd_ndate | varchar(16) | NO |  |  |  |
| datereplaced | bigint | NO |  | 0 |  |
| dateoveridden | bigint | NO |  | 0 |  |
| actualdatereplaced | bigint | NO |  | 0 |  |
| overriddenby | int | NO |  |  |  |
| validated | int | NO |  |  |  |
| helduntil | bigint | NO |  | 0 |  |

## `specialprices_modified`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| Pricelist | varchar(8) | NO |  |  |  |
| Stock_ref | varchar(10) | NO |  |  |  |
| Price | decimal(10,2) | NO |  | 0.00 |  |
| qb1 | varchar(100) | NO |  |  |  |
| qb2 | varchar(100) | NO |  |  |  |
| qb3 | varchar(100) | NO |  |  |  |
| qb4 | varchar(100) | NO |  |  |  |
| qb5 | varchar(100) | NO |  |  |  |
| qb6 | varchar(100) | NO |  |  |  |
| qb7 | varchar(100) | NO |  |  |  |
| qb8 | varchar(100) | NO |  |  |  |
| qb9 | varchar(100) | NO |  |  |  |
| qb10 | varchar(100) | NO |  |  |  |
| qb1sp | varchar(100) | NO |  |  |  |
| qb2sp | varchar(100) | NO |  |  |  |
| qb3sp | varchar(100) | NO |  |  |  |
| qb4sp | varchar(100) | NO |  |  |  |
| qb5sp | varchar(100) | NO |  |  |  |
| qb6sp | varchar(100) | NO |  |  |  |
| qb7sp | varchar(100) | NO |  |  |  |
| qb8sp | varchar(100) | NO |  |  |  |
| qb9sp | varchar(100) | NO |  |  |  |
| qb10sp | varchar(100) | NO |  |  |  |
| Currency | varchar(10) | NO |  |  |  |
| Deimal | varchar(4) | NO |  |  |  |

## `specialprices_postages`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| listid | int | NO |  |  |  |
| stockref | varchar(24) | NO |  |  |  |
| pricelist | varchar(12) | NO |  |  |  |
| hostcompanyid | int | NO |  |  |  |
| qty | int | NO |  |  |  |
| shipmethod | int | NO |  |  |  |
| pricevalue | float(10,2) | NO |  |  |  |
| notes | longtext | NO |  |  |  |
| addedby | int | NO |  |  |  |
| addedon | int | NO |  |  |  |
| country_name | varchar(48) | NO |  | United Kingdom |  |

## `specialprices_reviews`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| stockref | varchar(64) | NO |  |  |  |
| pricelist | varchar(8) | NO |  |  |  |
| hostcompanyid | int | NO |  |  |  |
| reviewedon | bigint | NO |  |  |  |
| reviewedby | int | NO |  |  |  |
| pricechangeon | bigint | NO |  |  |  |
| userawareofchangefrom | bigint | NO |  |  |  |
| useridawareofchange | int | NO |  |  |  |

## `specialprices_stkextra`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| stock_ref | varchar(12) | NO |  |  |  |
| pricelist | varchar(4) | NO |  |  |  |
| companyid | varchar(32) | NO |  |  |  |
| hidesingleprice | tinyint | NO |  |  |  |
| addedby | int | NO |  |  |  |
| addedon | bigint | NO |  | 0 |  |

## `specialprices_types`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| code | varchar(4) | NO |  |  |  |
| description | varchar(32) | NO |  |  |  |
| active | varchar(1) | NO |  |  |  |
| company | varchar(12) | NO |  |  |  |
| hostcompanyid | int | NO |  |  |  |

## `specialprices_workingdb`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| Pricelist | varchar(8) | NO |  |  |  |
| Stock_ref | varchar(32) | NO |  |  |  |
| Price | varchar(100) | NO |  | 0 |  |
| qb1 | varchar(100) | NO |  |  |  |
| qb2 | varchar(100) | NO |  |  |  |
| qb3 | varchar(100) | NO |  |  |  |
| qb4 | varchar(100) | NO |  |  |  |
| qb5 | varchar(100) | NO |  |  |  |
| qb6 | varchar(100) | NO |  |  |  |
| qb7 | varchar(100) | NO |  |  |  |
| qb8 | varchar(100) | NO |  |  |  |
| qb9 | varchar(100) | NO |  |  |  |
| qb10 | varchar(100) | NO |  |  |  |
| qb1sp | varchar(100) | NO |  |  |  |
| qb2sp | varchar(100) | NO |  |  |  |
| qb3sp | varchar(100) | NO |  |  |  |
| qb4sp | varchar(100) | NO |  |  |  |
| qb5sp | varchar(100) | NO |  |  |  |
| qb6sp | varchar(100) | NO |  |  |  |
| qb7sp | varchar(100) | NO |  |  |  |
| qb8sp | varchar(100) | NO |  |  |  |
| qb9sp | varchar(100) | NO |  |  |  |
| qb10sp | varchar(100) | NO |  |  |  |
| Currency | varchar(10) | NO |  |  |  |
| D | varchar(4) | NO |  |  |  |
| company | varchar(12) | NO |  |  |  |
| hostcompanyid | int | NO |  |  |  |
| cd_nsell | varchar(16) | NO |  |   |  |
| cd_ndate | varchar(16) | NO |  |   |  |
| userid | int | NO |  |  |  |
| workinglistid | int | NO |  |  |  |

## `specialprices_workinglist`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| description | varchar(100) | NO |  |  |  |
| createdon | bigint | NO |  | 0 |  |
| modifiedon | int | NO |  |  |  |
| createdby | int | NO |  |  |  |
| userincontrolid | int | NO |  |  |  |
| issueid | int | NO |  |  |  |
| hostcompanyid | int | NO |  |  |  |
| stockgroup | varchar(200) | NO |  |  |  |
| pricelist | varchar(8) | NO |  |  |  |
| singleitemlist | tinyint | NO |  |  |  |
| iscustomerlist | tinyint | NO |  |  |  |
| contact_id | int | NO |  |  |  |

## `stock_audits`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| auditedby | varchar(64) | NO |  |  |  |
| auditedon | bigint | NO |  | 0 |  |
| stock_ref | varchar(24) | NO |  |  |  |

## `stock_chemical_directives`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| directive | varchar(10) | NO |  |  |  |
| substance | varchar(32) | NO |  |  |  |
| ecnumber | varchar(18) | NO |  |  |  |
| casnumber | varchar(18) | NO |  |  |  |
| useage | varchar(3) | NO |  |  |  |
| addedby | varchar(32) | NO |  |  |  |
| addedon | int | NO |  |  |  |

## `stock_chemical_directives_stock_link`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| stock_ref | varchar(32) | NO |  |  |  |
| chemicalid | int | NO |  |  |  |
| addedon | int | NO |  |  |  |
| addedby | varchar(32) | NO |  |  |  |

## `stock_contact_reserved`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| hostcompanyid | int | NO |  |  |  |
| companyid | int | NO |  |  |  |
| contactid | int | NO |  |  |  |
| stockref | varchar(32) | NO |  |  |  |
| reserveqty | int | NO |  |  |  |
| addedon | bigint | NO |  |  |  |
| addedby | int | NO |  |  |  |
| authorisedon | bigint | NO |  |  |  |
| authorisedby | int | NO |  |  |  |
| status | int | NO |  |  |  |

## `stock_group_agencys`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| groupdesc | varchar(128) | NO |  |  |  |
| account | varchar(128) | NO |  |  |  |
| country | varchar(128) | NO |  |  |  |
| distributor_type | varchar(32) | NO |  |  |  |
| addedby | varchar(64) | NO |  |  |  |
| addedon | bigint | NO |  | 0 |  |

## `stock_group_agencys_stock_references`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| type | varchar(32) | NO |  |  |  |
| stock_ref | varchar(16) | NO |  |  |  |
| country | varchar(64) | NO |  |  |  |
| account | varchar(12) | NO |  |  |  |
| addedby | varchar(32) | NO |  |  |  |
| addedon | bigint | NO |  | 0 |  |
| validfrom | bigint | NO |  |  |  |
| expires | bigint | NO |  | 0 |  |
| requiredqty | int | NO |  |  |  |
| contractprice | varchar(96) | NO |  |  |  |
| testfield | varchar(32) | NO |  |  |  |
| notes | longtext | NO |  |  |  |
| specialpricecode | int | NO |  |  |  |
| contractpricecurr | varchar(10) | NO |  |  |  |
| hideme | varchar(1) | NO |  |  |  |
| updatedby | int | NO |  |  |  |
| updatedon | bigint | NO |  | 0 |  |
| companyid | int | NO |  |  |  |
| hostcompanyid | int | NO |  |  |  |
| supplieragreement | int | NO |  |  |  |
| supplieragreementby | bigint | NO |  |  |  |
| supplieragreementcid | int | NO |  |  |  |
| dltag | int | NO |  |  |  |

## `stock_sales_groups`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| description | varchar(64) | NO |  |  |  |
| industry | varchar(24) | NO |  |  |  |
| catagory | varchar(64) | NO |  |  |  |
| priority | int | NO |  |  |  |
| addedby | int | NO |  |  |  |
| addedon | bigint | NO |  | 0 |  |
| coding | varchar(16) | NO |  |  |  |

## `stock_sales_groups_countries`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| description | varchar(64) | NO |  |  |  |
| priority | int | NO |  |  |  |
| addedby | int | NO |  |  |  |
| addedon | bigint | NO |  | 0 |  |

## `stock_sales_groups_countries_users`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| countryid | int | NO |  |  |  |
| userid | int | NO |  |  |  |
| priority | int | NO |  |  |  |

## `stock_sales_groups_country_status`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| groupid | int | NO |  |  |  |
| countryid | int | NO |  |  |  |
| statusid | int | NO |  |  |  |
| addedby | int | NO |  |  |  |
| addedon | int | NO |  |  |  |

## `stock_sales_groups_stkref`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| stock_ref | varchar(12) | NO |  |  |  |
| groupid | int | NO |  |  |  |
| addedby | int | NO |  |  |  |
| addedon | bigint | NO |  | 0 |  |

## `stock_sales_status`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| description | varchar(64) | NO |  |  |  |
| addedby | int | NO |  |  |  |
| addedon | int | NO |  |  |  |

## `stock_view_history`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| stockref | varchar(32) | NO |  |  |  |
| hostcompanyid | int | NO |  |  |  |
| addedby | int | NO |  |  |  |
| addedon | bigint | NO |  |  |  |

## `stock_weights`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| stock_ref | varchar(100) | NO |  |  |  |
| weight | varchar(100) | NO |  |  |  |
| length | varchar(100) | NO |  |  |  |
| width | varchar(100) | NO |  |  |  |
| height | varchar(100) | NO |  |  |  |
| user | varchar(100) | NO |  |  |  |
| volumetric | varchar(100) | NO |  |  |  |
| item_width | varchar(32) | NO |  |  |  |
| item_weight | varchar(32) | NO |  |  |  |
| item_height | varchar(32) | NO |  |  |  |
| item_length | varchar(32) | NO |  |  |  |
| date | bigint | NO |  | 0 |  |
| weeweight | varchar(100) | NO |  |  |  |
| confirmedby | int | NO |  |  |  |
| confirmedon | bigint | NO |  | 0 |  |
| physical_item_width | varchar(32) | NO |  |  |  |
| physical_item_height | varchar(32) | NO |  |  |  |
| physical_item_length | varchar(32) | NO |  |  |  |
| physical_item_weight | varchar(32) | NO |  |  |  |
| packagingpn | varchar(8) | NO |  |  |  |

## `stock_weights_history`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| archivedby | varchar(32) | NO |  |  |  |
| archivedon | bigint | NO |  | 0 |  |
| stock_ref | varchar(100) | NO |  |  |  |
| weight | varchar(100) | NO |  |  |  |
| length | varchar(100) | NO |  |  |  |
| width | varchar(100) | NO |  |  |  |
| height | varchar(100) | NO |  |  |  |
| user | varchar(100) | NO |  |  |  |
| volumetric | varchar(100) | NO |  |  |  |
| item_width | varchar(32) | NO |  |  |  |
| item_weight | varchar(32) | NO |  |  |  |
| item_height | varchar(32) | NO |  |  |  |
| item_length | varchar(32) | NO |  |  |  |
| date | bigint | NO |  | 0 |  |

## `stockactive`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| Stock_ref | varchar(100) | NO |  |  |  |
| UKP | varchar(100) | NO |  |  |  |
| EUREU | varchar(100) | NO |  |  |  |
| EURD | varchar(100) | NO |  |  |  |
| USDEU | varchar(100) | NO |  |  |  |
| USDD | varchar(100) | NO |  |  |  |
| status | varchar(100) | NO |  |  |  |

## `stockforms`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| hostcompanyid | int | NO |  |  |  |
| description | varchar(128) | NO |  |  |  |
| active | int | NO |  |  |  |

## `stockforms_pages`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| formid | int | NO |  |  |  |
| docid | int | NO |  |  |  |
| active | int | NO |  |  |  |

## `stockforms_pages_fields`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| hostcompanyid | int | NO |  |  |  |
| formid | int | NO |  |  |  |
| pageid | int | NO |  |  |  |
| tablename | varchar(32) | NO |  |  |  |
| fieldname | varchar(128) | NO |  |  |  |
| specialfunction | int | NO |  |  |  |
| extrafield | varchar(32) | NO |  |  |  |
| x1 | float | NO |  |  |  |
| y1 | float | NO |  |  |  |
| x2 | float | NO |  |  |  |
| y2 | float | NO |  |  |  |
| status | int | NO |  |  |  |

## `stockgroup`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| tag | varchar(100) | NO |  |  |  |
| id | bigint | NO | PRI |  | auto_increment |
| stk_ref | varchar(16) | NO |  |  |  |
| description | varchar(40) | NO |  |  |  |
| owner | varchar(100) | NO |  |  |  |
| groupcode | varchar(128) | NO |  |  |  |
| agency | varchar(128) | NO |  |  |  |
| reorder | int | NO |  |  |  |
| universaltime | bigint | NO |  |  |  |
| imgfile | varchar(13) | NO |  |  |  |
| tagged | varchar(12) | NO |  |  |  |
| temp | varchar(200) | NO |  |  |  |
| pricelistweight | int | NO |  |  |  |
| hostcompanyid | int | NO |  |  |  |
| pricelisttitle | varchar(128) | NO |  |  |  |
| companyid | int | NO |  |  |  |

## `stockgroup_header`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| groupcode | varchar(250) | NO |  |  |  |
| addedby | int | NO |  |  |  |
| addedon | bigint | NO |  | 0 |  |
| pricelistheader | varchar(100) | NO |  |  |  |

## `stocklisb4`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| STOCK_REFE | varchar(16) | NO | PRI |  |  |
| SEARCH_REF | varchar(8) | YES |  |  |  |
| SEARCH_RE1 | varchar(8) | YES |  |  |  |
| DESCRIPTIO | varchar(40) | YES |  |  |  |
| ANALYSIS_C | varchar(8) | YES |  |  |  |
| CATEGORY | varchar(35) | YES |  |  |  |
| SELLING_PR | float(5,2) | YES |  |  |  |
| COST_PRICE | float(5,2) | YES |  |  |  |
| LAST_COST_ | float(5,2) | YES |  |  |  |
| EXTENSION_ | varchar(40) | YES |  |  |  |
| SALE_PRICE | float(5,2) | YES |  |  |  |
| QUANTITY_I | float(5,2) | YES |  |  |  |
| SUPERSEDED | varchar(40) | YES |  |  |  |
| PROFILE_CO | varchar(40) | YES |  |  |  |

## `stocklist`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| STOCK_REFE | varchar(16) | NO |  |  |  |
| SEARCH_REF | varchar(18) | YES |  |  |  |
| SEARCH_RE1 | varchar(18) | YES |  |  |  |
| DESCRIPTIO | varchar(80) | YES |  |  |  |
| ANALYSIS_C | varchar(8) | YES |  |  |  |
| CATEGORY | varchar(35) | YES |  |  |  |
| SELLING_PR | decimal(10,2) | YES |  |  |  |
| COST_PRICE | decimal(10,2) | YES |  |  |  |
| LAST_COST_ | decimal(10,2) | YES |  |  |  |
| EXTEND_DESC | longtext | YES |  |  |  |
| SALE_PRICE | decimal(10,2) | YES |  |  |  |
| UNIT_WEIGHT | varchar(100) | YES |  |  |  |
| UNIT_VOL | varchar(100) | YES |  |  |  |
| QUANTITY_I | decimal(10,2) | YES |  |  |  |
| SUPERSEDED | varchar(40) | YES |  |  |  |
| MEMO | longtext | YES |  |  |  |
| PROFILE_CO | varchar(40) | YES |  |  |  |
| ONPURCHASEORDER | varchar(10) | YES |  |  |  |
| ONSALEORDER | varchar(10) | YES |  |  |  |
| NLACCOUNT | varchar(8) | NO |  |  |  |
| companyid | varchar(32) | NO |  |  |  |
| hostcompany | int | NO |  |  |  |

## `stocklist_competitorinfo`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| stkref | varchar(100) | NO |  |  |  |
| compname | varchar(100) | NO |  |  |  |
| comppn | varchar(100) | NO |  |  |  |
| compprice | varchar(100) | NO |  |  |  |
| compcurr | varchar(100) | NO |  |  |  |
| compcount | varchar(100) | NO |  |  |  |
| compnote | longtext | NO |  |  |  |
| addby | varchar(100) | NO |  |  |  |
| addon | varchar(100) | NO |  |  |  |

## `stocklist_contract_prices`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO |  |  |  |
| stock_ref | varchar(32) | NO |  |  |  |
| contract_price | float(10,2) | NO |  |  |  |
| valid_until | bigint | NO |  | 0 |  |
| addedby | varchar(64) | NO |  |  |  |
| addedon | bigint | NO |  | 0 |  |
| companyid | varchar(16) | NO |  |  |  |
| qb1 | int | NO |  |  |  |
| qb1sp | float(10,2) | NO |  |  |  |
| qb2 | int | NO |  |  |  |
| qb2sp | float(10,2) | NO |  |  |  |
| qb3 | int | NO |  |  |  |
| qb3sp | float(10,2) | NO |  |  |  |
| qb4 | int | NO |  |  |  |
| qb4sp | float(10,2) | NO |  |  |  |
| qb5 | int | NO |  |  |  |
| qb5sp | float(10,2) | NO |  |  |  |

## `stocklist_export_templates`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| owner | int | NO |  |  |  |
| description | varchar(64) | NO |  |  |  |
| pricelistcode | varchar(4) | NO |  |  |  |

## `stocklist_export_templates_fields`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| templateid | int | NO |  |  |  |
| fieldid | int | NO |  |  |  |
| reord | int | NO |  |  |  |

## `stocklist_extra`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| stock_ref | varchar(10) | NO |  |  |  |
| extended | longtext | NO |  |  |  |

## `stocklist_extra_exporter`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| groupcode | varchar(32) | NO |  |  |  |
| owner | varchar(32) | NO |  |  |  |
| stock_ref | varchar(24) | NO |  |  |  |
| layoutnumber | int | NO |  |  |  |

## `stocklist_extra_fields`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| description | varchar(64) | NO |  |  |  |
| tablename | varchar(96) | NO |  |  |  |
| fieldname | varchar(96) | NO |  |  |  |
| stockrefname | varchar(96) | NO |  |  |  |
| companyidfield | varchar(16) | NO |  |  |  |

## `stocklist_extra_fields_answers`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| stock_ref | varchar(24) | NO |  |  |  |
| fieldid | int | NO |  |  |  |
| answer | longtext | NO |  |  |  |
| tem | varchar(1) | NO |  |  |  |
| hostcompanyid | int | NO |  |  |  |

## `stocklist_extra_fields_stock_link`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| fieldid | int | NO |  |  |  |
| stock_ref | varchar(32) | NO |  |  |  |
| answer | longtext | NO |  |  |  |
| updatedby | varchar(32) | NO |  |  |  |
| updatedon | int | NO |  |  |  |

## `stocklist_faq`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| question | longtext | NO |  |  |  |
| answer | longtext | NO |  |  |  |
| docid | int | NO |  |  |  |
| addedby | int | NO |  |  |  |
| confirmedby | int | NO |  |  |  |
| addedon | bigint | NO |  | 0 |  |
| confirmedon | bigint | NO |  | 0 |  |
| underreview | bigint | NO |  | 0 |  |
| issueid | int | NO |  |  |  |
| displayorder | int | NO |  |  |  |
| adminmemo | longtext | NO |  |  |  |
| status | int | NO |  |  |  |

## `stocklist_faq_docid`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| questionid | int | NO |  |  |  |
| docid | int | NO |  |  |  |

## `stocklist_faq_stock`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| stkref | varchar(16) | NO |  |  |  |
| questionid | int | NO |  |  |  |
| displayorder | int | NO |  |  |  |

## `stocklist_freedelivery`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| stock_ref | varchar(32) | NO |  |  |  |
| pricelist | varchar(8) | NO |  |  |  |
| freechecked | varchar(12) | NO |  |  |  |
| hostcompanyid | int | NO |  |  |  |
| updatedby | int | NO |  |  |  |
| updatedon | bigint | NO |  | 0 |  |

## `stocklist_ghx`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| stock_ref | varchar(16) | NO |  |  |  |
| originalman | varchar(32) | NO |  |  |  |
| manname | varchar(32) | NO |  |  |  |
| brand | varchar(32) | NO |  |  |  |
| subbrand | varchar(32) | NO |  |  |  |
| manprodcode | varchar(32) | NO |  |  |  |
| functionalname | varchar(64) | NO |  |  |  |
| variant | varchar(32) | NO |  |  |  |
| unitsize | varchar(8) | NO |  |  |  |
| UOM | varchar(12) | NO |  |  |  |
| pricingoption | varchar(64) | NO |  |  |  |
| deliveryoption | varchar(32) | NO |  |  |  |
| bodypart | varchar(32) | NO |  |  |  |
| dimensions | varchar(64) | NO |  |  |  |
| battery | varchar(64) | NO |  |  |  |
| hostcompanyid | int | NO |  |  |  |

## `stocklist_subcomponents`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| Stock_ref | varchar(32) | NO |  |  |  |
| Stock_ref_sub | varchar(32) | NO |  |  |  |
| required | varchar(3) | NO |  |  |  |
| hostcompanyid | int | NO |  |  |  |
| autoorderadd | int | NO |  |  |  |
| updatedon | bigint | NO |  | 0 |  |
| updatedby | int | NO |  |  |  |
| subtype | varchar(32) | NO |  |  |  |
| qty | float(10,2) | NO |  |  |  |

## `stocklist_subcomponents_history`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| Stock_ref | varchar(32) | NO |  |  |  |
| Stock_ref_sub | varchar(32) | NO |  |  |  |
| required | varchar(3) | NO |  |  |  |
| hostcompanyid | int | NO |  |  |  |
| autoorderadd | int | NO |  |  |  |
| updatedon | bigint | NO |  | 0 |  |
| updatedby | int | NO |  |  |  |
| subtype | varchar(32) | NO |  |  |  |
| qty | float(10,2) | NO |  |  |  |

-e 
## viamedquoteaddress
## `viamedquoteaddress`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| ID | int | NO | PRI |  | auto_increment |
| ADDRESS1 | varchar(255) | YES |  |  |  |
| ADDRESS2 | varchar(255) | YES |  |  |  |
| ADDRESS3 | varchar(255) | YES |  |  |  |
| CITY | varchar(255) | YES |  |  |  |
| COMPANY | varchar(255) | YES |  |  |  |
| CONTACT | varchar(255) | YES |  |  |  |
| COUNTRY | varchar(255) | YES |  |  |  |
| INETADDR | varchar(255) | YES |  |  |  |
| KEY5 | varchar(255) | YES |  |  |  |
| PHONE1 | varchar(255) | YES |  |  |  |
| PHONE2 | varchar(255) | YES |  |  |  |
| FAX | varchar(200) | NO |  |  |  |
| STATE | varchar(255) | YES |  |  |  |
| TITLE | varchar(255) | YES |  |  |  |
| UPOSITION | varchar(255) | YES |  |  |  |
| ZIP | varchar(255) | YES |  |  |  |
| DEPARTMENT | varchar(255) | YES |  |  |  |
| NOTES | longtext | YES |  |  |  |
| FLAG | varchar(10) | NO |  |  |  |
| REGION | varchar(50) | NO |  |  |  |
| STATUS | varchar(100) | NO |  |  |  |
| HNHREP | varchar(50) | NO |  |  |  |
| REORDER | int | NO |  | 0 |  |
| OWNERGROUP | varchar(100) | NO |  |  |  |
| NHSREGION | varchar(100) | NO |  |  |  |
| hideme | varchar(100) | NO |  |  |  |
| contact_special_id | int | NO |  |  |  |
| contact_special_type | varchar(16) | NO |  |  |  |
| visitingnotes | longtext | NO |  |  |  |
| Company_reg_number | varchar(24) | NO |  |  |  |
| Vat_Number | varchar(24) | NO |  |  |  |
| contact_type | varchar(128) | NO |  |  |  |
| lostsalestag | varchar(200) | NO |  |  |  |
| lostsalesnotes | longtext | NO |  |  |  |
| alternativenames | longtext | NO |  |  |  |
| emailinvoices | varchar(5) | NO |  |  |  |
| debtornotes | varchar(250) | NO |  |  |  |
| googleidentifier | varchar(64) | NO |  |  |  |
| rmanotes | longtext | NO |  |  |  |
| website | varchar(200) | NO |  |  |  |
| companyid | int | NO |  |  |  |
| einvoicenotes | longtext | NO |  |  |  |
| checkingnotes | longtext | NO |  |  |  |
| checkingnotesby | int | NO |  |  |  |
| checkingnoteson | bigint | NO |  |  |  |
| orderconf1 | varchar(1) | NO |  |  |  |
| orderconf2 | varchar(1) | NO |  |  |  |
| einvoicesingles | varchar(1) | NO |  |  |  |
| invoice_company_id | int | NO |  |  |  |
| addedby | int | NO |  |  |  |
| addedon | bigint | NO |  |  |  |
| rep_company_id | int | NO |  |  |  |
| rep_contact_id | int | NO |  |  |  |
| mainconotes | longtext | NO |  |  |  |
| mainconotesby | int | NO |  |  |  |
| mainconoteson | bigint | NO |  |  |  |
| otheraccount | varchar(16) | NO |  |  |  |
| vat_exempt | int | NO |  |  |  |
| paymenttermsdefault | int | NO |  |  |  |
| deliverytermsdefault | int | NO |  |  |  |
| credittype | varchar(16) | NO |  |  |  |
| firstcontactcode | varchar(32) | NO |  |  |  |
| stoponaccount | int | NO |  |  |  |
| specialsalesflag | varchar(3) | NO |  |  |  |
| salesrep | int | NO |  |  |  |
| updatedby | int | NO |  |  |  |
| updatedon | bigint | NO |  |  |  |
| DL_TestField | varchar(12) | NO |  |  |  |
| goodinmemo | longtext | NO |  |  |  |
| hidefrompostock | smallint | NO |  |  |  |
| Invoice_Method | int | NO |  |  |  |
| glncode | varchar(24) | NO |  |  |  |
| stocksignedoffon | bigint | NO |  | 0 |  |
| stocksignedoffby | int | NO |  |  |  |
| Opera_Region | varchar(35) | NO |  |  |  |
| Opera_Territory | varchar(35) | NO |  |  |  |
| Opera_Cust_type | varchar(35) | NO |  |  |  |
| Opera_Cust_analy | varchar(6) | NO |  |  |  |
| Opera_Stat_account | varchar(20) | NO |  |  |  |
| Opera_Desp_method | varchar(35) | NO |  |  |  |
| Opera_Pricelist | varchar(12) | NO |  |  |  |
| Opera_Creditlimit | int | NO |  |  |  |
| Xero_contactname | varchar(100) | NO |  |  |  |
| ourpoaccount | varchar(48) | NO |  |  |  |
| incoterms | int | NO |  |  |  |
| incotermslocation | varchar(32) | NO |  |  |  |
| XeroInvoiceCompanyName | varchar(128) | NO |  |  |  |
| XeroInvoiceContactEmail | varchar(128) | NO |  |  |  |
| banksearch | varchar(128) | NO |  |  |  |
| operaclosingbalance | float(10,3) | NO |  |  |  |
| supplierpaymentdays | int | NO |  |  |  |
| ourpocurrency | int | NO |  |  |  |
| peppolid | varchar(48) | NO |  |  |  |
| xeroexportsuppliername | varchar(64) | NO |  |  |  |
| xeroexportcustomername | varchar(200) | NO |  |  |  |
| customereorinumber | varchar(24) | NO |  |  |  |
| issueicon | varchar(5) | NO |  |  |  |
| issueiconcolour | int | NO |  |  |  |
| allgoodslabelid | int | NO |  |  |  |
| restockmonths | int | NO |  |  |  |
| shopifyaddress | longtext | NO |  |  |  |
| delnotification | int | NO |  |  |  |
| deliverytermsdefaultconsign | varchar(128) | NO |  |  |  |
| supplierreviewrating | varchar(1) | NO |  |  |  |
| WILDIXPHONE | varchar(100) | NO |  |  |  |
| blacklist | varchar(64) | NO |  |  |  |
| distpreinsurance | int | NO |  |  |  |
| distformreturned | bigint | NO |  |  |  |
| distagreement | bigint | NO |  |  |  |
| linkedaddress | int | NO |  |  |  |
| feedbacksurvey | tinyint | NO |  |  |  |
| paymentroute | tinyint | NO |  |  |  |
| paymentroutenotes | longtext | NO |  |  |  |
| preferedcid | int | NO |  |  |  |
| transittimedays | int | NO |  |  |  |
| suppliermonthcutoff | int | NO |  |  |  |

-e 
## viamedquotecontact
## `viamedquotecontact`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| CONTACT | varchar(100) | NO |  |  |  |
| COUNTRY | varchar(100) | NO |  |  |  |
| INETADDR | varchar(100) | NO |  |  |  |
| PHONE1 | varchar(100) | NO |  |  |  |
| PHONE2 | varchar(100) | NO |  |  |  |
| FAX | varchar(100) | NO |  |  |  |
| TITLE | varchar(100) | NO |  |  |  |
| UPOSITION | varchar(100) | NO |  |  |  |
| ZIP | varchar(100) | NO |  |  |  |
| DEPARTMENT | varchar(100) | NO |  |  |  |
| FLAG | varchar(100) | NO |  |  |  |
| COMPANY_ID | int | NO |  | 0 |  |
| NOTES | longtext | NO |  |  |  |
| REPID | varchar(100) | NO |  |  |  |
| KEY5 | varchar(100) | NO |  |  |  |
| hideme | varchar(100) | NO |  |  |  |
| updatedon | varchar(100) | NO |  |  |  |
| MAILDEPT | varchar(32) | NO |  |  |  |
| mail | varchar(7) | NO |  |  |  |
| email | varchar(7) | NO |  |  |  |
| phone | varchar(7) | NO |  |  |  |
| hidemereason | varchar(64) | NO |  |  |  |
| addedby | varchar(32) | NO |  |  |  |
| iso | varchar(5) | NO |  |  |  |
| accountstatements | varchar(5) | NO |  |  |  |
| sendpricingupdates | varchar(5) | NO |  |  |  |
| emailinvoice | varchar(5) | NO |  |  |  |
| mobilenumber | varchar(32) | NO |  |  |  |
| addedon | bigint | NO |  | 0 |  |
| altdirectdial | varchar(32) | NO |  |  |  |
| extension | varchar(32) | NO |  |  |  |
| altextension | varchar(32) | NO |  |  |  |
| bleepnum | varchar(32) | NO |  |  |  |
| responsibility | varchar(78) | NO |  |  |  |
| GOLDMINEKEY | varchar(24) | NO |  |  |  |
| polog | varchar(5) | NO |  |  |  |
| remit | varchar(5) | NO |  |  |  |
| emailinvoicegoldmine | varchar(5) | NO |  |  |  |
| emailpricechanges | varchar(5) | NO |  |  |  |
| firstcontact | varchar(32) | NO |  |  |  |
| CleanPosition | varchar(64) | NO |  |  |  |
| xeroimported | tinyint | NO |  |  |  |
| allowso | tinyint | NO |  |  |  |
| hashcode | varchar(32) | YES |  |  |  |
| verifiedby | int | NO |  |  |  |
| verifiedon | bigint | NO |  |  |  |
| verifiedadminby | int | NO |  |  |  |
| verifiedadminon | bigint | NO |  |  |  |
| WILDIXPHONE | varchar(100) | NO |  |  |  |
| unsubscribeby | int | NO |  |  |  |
| unsubscribeon | bigint | NO |  |  |  |
| deliverynotification | tinyint | NO |  |  |  |

-e 
## stocklist_tarriffs
## `stocklist_tarriffs`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| stock_ref | varchar(64) | NO |  |  |  |
| tariff | varchar(16) | NO |  |  |  |
| spare | varchar(16) | NO |  |  |  |
| warranty_customer | varchar(12) | NO |  |  |  |
| warranty_supplier | varchar(12) | NO |  |  |  |
| warranty_distributor | varchar(12) | NO |  |  |  |
| ce_marking | varchar(10) | NO |  |  |  |
| ce_marking_standards | varchar(10) | NO |  |  |  |
| showdatecode | char(3) | NO |  |  |  |
| usebydatemonths | int | NO |  | 0 |  |
| weelabel | char(2) | NO |  |  |  |
| ean13 | varchar(26) | NO |  |  |  |
| qa_type | int | NO |  |  |  |
| attacheditems | varchar(3) | NO |  |  |  |
| equipment_type | varchar(96) | NO |  |  |  |
| ceclass | varchar(16) | NO |  |  |  |
| safclass | varchar(4) | NO |  |  |  |
| saftype | varchar(4) | NO |  |  |  |
| cmdclass | varchar(16) | NO |  |  |  |
| cefileid | int | NO |  |  |  |
| prelabeltext | longtext | NO |  |  |  |
| lastcost | varchar(24) | NO |  |  |  |
| natonumber | varchar(36) | NO |  |  |  |
| stock_value_tag | varchar(24) | NO |  |  |  |
| nhs_eclass | varchar(5) | NO |  |  |  |
| thumbnailurl | varchar(250) | NO |  |  |  |
| imageurl | varchar(250) | NO |  |  |  |
| enable_quick_serial | varchar(1) | NO |  |  |  |
| weetick | varchar(4) | NO |  |  |  |
| weeweight | varchar(12) | NO |  |  |  |
| weeconsumable | varchar(4) | NO |  |  |  |
| label_description | varchar(96) | NO |  |  |  |
| showfactorydate | varchar(5) | NO |  |  |  |
| creationdate | bigint | NO |  | 0 |  |
| allow_dupsn | tinyint(1) | NO |  |  |  |
| freecarriage | tinyint(1) | NO |  |  |  |
| ppq | varchar(32) | NO |  |  |  |
| audited | int | NO |  |  |  |
| nhscataloguecode | varchar(32) | NO |  |  |  |
| latex | varchar(3) | NO |  |  |  |
| coshh | varchar(3) | NO |  |  |  |
| electromedical | varchar(3) | NO |  |  |  |
| environmentallyfriendly | varchar(3) | NO |  |  |  |
| ethicallysourced | varchar(3) | NO |  |  |  |
| whilestockslast | varchar(3) | NO |  |  |  |
| updatedby | varchar(32) | NO |  |  |  |
| updatedon | bigint | NO |  | 0 |  |
| warranty_extendedtext | longtext | NO |  |  |  |
| uk_contract_price_percent | float(10,2) | NO |  |  |  |
| companyid | varchar(12) | NO |  |  |  |
| uk_contract_price_percent_addedby | varchar(32) | NO |  |  |  |
| uk_contract_price_percent_addedon | bigint | NO |  | 0 |  |
| minstock | int | NO |  |  |  |
| scrollbar | varchar(250) | NO |  |  |  |
| stock_count | int | NO |  |  |  |
| stock_cost | float | NO |  |  |  |
| po_stock_cost | float(12,4) | NO |  |  |  |
| stock_value | float | NO |  |  |  |
| GHX_description | varchar(250) | NO |  |  |  |
| freec | varchar(12) | NO |  |  |  |
| auditedon | bigint | NO |  | 0 |  |
| auditedby | varchar(64) | NO |  |  |  |
| pricedesc | longtext | NO |  |  |  |
| isrepaircode | varchar(5) | NO |  |  |  |
| duelsn | varchar(7) | NO |  |  |  |
| sellbydatemonthsfrombarcode | int | NO |  |  |  |
| reqarequiredmonths | int | NO |  |  |  |
| qrquicklink | varchar(1) | NO |  |  |  |
| stockvalidatedon | bigint | NO |  | 0 |  |
| stockvalidatedby | varchar(32) | NO |  |  |  |
| stockvisability | varchar(32) | NO |  |  |  |
| qaoperaadjust | varchar(1) | NO |  |  |  |
| GHX_description_extend | longtext | NO |  |  |  |
| countryoforigin | varchar(128) | NO |  |  |  |
| singlespartnumber | varchar(10) | NO |  |  |  |
| packsize | int | NO |  |  |  |
| rohs | varchar(3) | NO |  |  |  |
| rohsexlusion | varchar(12) | NO |  |  |  |
| mtbf | longtext | NO |  |  |  |
| orderedas | varchar(12) | NO |  |  |  |
| ingress | varchar(6) | NO |  |  |  |
| alternative1 | varchar(16) | NO |  |  |  |
| alternative2 | varchar(16) | NO |  |  |  |
| alternative3 | varchar(16) | NO |  |  |  |
| tempnote | longtext | NO |  |  |  |
| tempdate | bigint | NO |  | 0 |  |
| reach | varchar(3) | NO |  |  |  |
| docompatibility | varchar(1) | NO |  |  |  |
| gmdn | varchar(32) | NO |  |  |  |
| ghxuom | varchar(5) | NO |  |  |  |
| ghxuomdesc | varchar(10) | NO |  |  |  |
| groupstatus | varchar(32) | NO |  |  |  |
| corpsale | varchar(3) | NO |  |  |  |
| ghx_brand | varchar(32) | NO |  |  |  |
| ghx_mancode | varchar(24) | NO |  |  |  |
| permnote | longtext | NO |  |  |  |
| permdate | int | NO |  |  |  |
| techempid | int | NO |  |  |  |
| hiddennotes | longtext | NO |  |  |  |
| dehp | varchar(5) | NO |  |  |  |
| matchedpairs | varchar(3) | NO |  |  |  |
| matchpairspn | varchar(14) | NO |  |  |  |
| offsetallowed | varchar(5) | NO |  |  |  |
| outputdiff | varchar(5) | NO |  |  |  |
| checkpricedate | bigint | NO |  | 0 |  |
| qaformfullprint | varchar(3) | NO |  |  |  |
| regularforcasts | varchar(3) | NO |  |  |  |
| hostcompany_id | int | NO |  |  |  |
| SUPERSEDED | varchar(24) | NO |  |  |  |
| bundlepackagingallowed | int | NO |  |  |  |
| supportdateend | bigint | NO |  | 0 |  |
| availabledateend | bigint | NO |  | 0 |  |
| sntag | int | NO |  |  |  |
| descriptiveitemonly | int | NO |  |  |  |
| daystodeliver | int | NO |  |  |  |
| perishable_replace_months | int | NO |  |  |  |
| usertag | int | NO |  |  |  |
| servicable | varchar(3) | NO |  |  |  |
| servicable_partnumber | varchar(20) | NO |  |  |  |
| webimageurl | varchar(128) | NO |  |  |  |
| webimagefileid | int | NO |  |  |  |
| ce_docid | int | NO |  |  |  |
| requiresextraboxtoship | varchar(7) | NO |  |  |  |
| returnscountryoforigin | varchar(64) | NO |  |  |  |
| pickingnotes | longtext | NO |  |  |  |
| pricelistweight | int | NO |  |  |  |
| phthalate | varchar(3) | NO |  |  |  |
| specialsales | varchar(5) | NO |  |  |  |
| specialsales_rep | int | NO |  |  |  |
| operamemo | longtext | NO |  |  |  |
| newcustomeralerttext | longtext | NO |  |  |  |
| quicksrsturnaround | varchar(3) | NO |  |  |  |
| oemspecialsales | tinyint | NO |  |  |  |
| traininglevel | varchar(48) | NO |  |  |  |
| trainingcharge | varchar(48) | NO |  |  |  |
| trainingexplaination | longtext | NO |  |  |  |
| doewnotblockshipping | varchar(4) | NO |  |  |  |
| productstop | varchar(3) | NO |  |  |  |
| preproductionnotes | longtext | NO |  |  |  |
| qaweightcheck | int | NO |  |  |  |
| qaweightcheckrange | int | NO |  |  |  |
| repairturnaround | int | NO |  |  |  |
| rmareturntarriff | varchar(24) | NO |  |  |  |
| suppliernotes | longtext | NO |  |  |  |
| GHX_QOM | varchar(24) | NO |  |  |  |
| GHX_QOM_Description | varchar(48) | NO |  |  |  |
| ghx_manname | varchar(32) | NO |  |  |  |
| supreturns_customvalue | varchar(12) | NO |  |  |  |
| ghx_gln_supplier | varchar(16) | NO |  |  |  |
| ghx_gln_manufacturer | varchar(16) | NO |  |  |  |
| srsmemo | longtext | NO |  |  |  |
| srs_triage | longtext | NO |  |  |  |
| ncage | varchar(5) | NO |  |  |  |
| suppmoq | int | NO |  |  |  |
| lastsupplieroperaac | varchar(12) | NO |  |  |  |
| importtax | float(10,2) | NO |  |  |  |
| importfreight | float(10,2) | NO |  |  |  |
| suppdeldays | int | NO |  |  |  |
| suppdeldatesbacktoback | varchar(5) | NO |  |  |  |
| suppliergroup | varchar(250) | NO |  |  |  |
| catagorytype | varchar(64) | NO |  |  |  |
| shelflife | int | NO |  |  |  |
| hidefrompohm | tinyint | NO |  |  |  |
| manualcost | float(10,2) | NO |  |  |  |
| gs128notes | longtext | NO |  |  |  |
| cleanerpninternal | varchar(100) | NO |  |  |  |
| cleanercustomer | varchar(100) | NO |  |  |  |
| operadesc | varchar(40) | NO |  |  |  |
| suppliernotespo | longtext | NO |  |  |  |
| paperworkdescription | longtext | NO |  |  |  |
| singlebarcodeitem | tinyint | NO |  |  |  |
| nominalcode | varchar(8) | NO |  |  |  |
| nosaleineu | varchar(4) | NO |  |  |  |
| OperaDescription | varchar(128) | NO |  |  |  |
| HasBarcodeTracking | tinyint | NO |  |  |  |
| hiddensearch | longtext | NO |  |  |  |
| vatfree | tinyint | NO |  |  |  |
| image_docid | int | NO |  |  |  |
| distributionrights | int | NO |  |  |  |
| IsDeliveryInsuranceLine | tinyint | NO |  |  |  |
| pepolid | varchar(48) | NO |  |  |  |
| orderqtytobarcodes | int | NO |  |  |  |
| cebodynumber | varchar(12) | NO |  |  |  |
| serialnumber_lables_id | int | NO |  |  |  |
| aftersales | int | NO |  |  |  |
| DescriptionExtra | varchar(129) | NO |  |  |  |
| qapercent | varchar(16) | NO |  |  |  |
| riskassesmentdocid | int | NO |  |  |  |
| upsservicecode | varchar(3) | NO |  |  |  |
| addedby | int | NO |  |  |  |
| EUREP | varchar(36) | YES |  |  |  |
| UKREP | varchar(36) | YES |  |  |  |
| hidefromsystemreports | varchar(4) | NO |  | No |  |
| productiondocid | int | NO |  |  |  |
| feedbackemailbody | longtext | NO |  |  |  |
| iso_feedbackquestion | longtext | NO |  |  |  |
| mainstocklocation | int | NO |  |  |  |
| shopifyhandle | varchar(256) | NO |  |  |  |
| monthexpirestop | int | NO |  |  |  |
| usagetype | varchar(64) | NO |  |  |  |
| qadocumentid | int | NO |  |  |  |
| servicedocumentid | int | NO |  |  |  |
| ifudocid | int | NO |  |  |  |
| packingdocid | int | NO |  |  |  |
| techdocid | int | NO |  |  |  |
| officialshelflife | int | NO |  |  |  |
| importtariff | varchar(64) | NO |  |  |  |
| mhraregnumber | varchar(24) | NO |  |  |  |
| complianceimporter | int | NO |  |  |  |
| officialimportercid | int | NO |  |  |  |
| manufacturercid | int | NO |  |  |  |
| mhraregnumbercid | int | NO |  |  |  |
| umdns | varchar(32) | NO |  |  |  |
| firstonmarket | varchar(12) | NO |  |  |  |
| ecdirective | varchar(3) | NO |  |  |  |
| supportdate | varchar(12) | NO |  |  |  |
| workinglife | varchar(64) | NO |  |  |  |
| postdelinspection | int | NO |  |  |  |
| reprocessuse | varchar(4) | NO |  |  |  |
| reprocesscycles | varchar(11) | NO |  |  |  |
| datastorage | varchar(4) | NO |  |  |  |
| dataconnection | varchar(4) | NO |  |  |  |
| safetymeasures | varchar(4) | NO |  |  |  |
| performanceqatest | int | NO |  |  |  |
| supguarantee | varchar(12) | NO |  |  |  |
| labelbackdocid | int | NO |  |  |  |
| hostauthorityrefnumber | longtext | NO |  |  |  |
| sellablealarmlimit | int | NO |  |  |  |
| canreprocesscycles | varchar(4) | NO |  |  |  |
| decontamination | varchar(64) | NO |  |  |  |
| QAMeasures | varchar(32) | NO |  |  |  |
| manprodliabdocid | int | NO |  |  |  |
| goodsoutlabelid | int | NO |  |  |  |
| paqdocpackid | int | NO |  |  |  |
| cn22desc | varchar(64) | NO |  |  |  |
| cleandocid | int | NO |  |  |  |
| officialservicedocid | int | NO |  |  |  |
| EUDAMED | varchar(32) | NO |  |  |  |
| rohs2 | varchar(3) | NO |  |  |  |
| custrepreview | bigint | NO |  |  |  |
| xrefgroup | varchar(48) | NO |  |  |  |
| webstockoptions | int | NO |  |  |  |
| webstockqty | int | NO |  |  |  |
| webstockpercent | int | NO |  |  |  |
| goodsinproceduredocid | int | NO |  |  |  |
| extrasearch | longtext | NO |  |  |  |
| hideinvoicezeros | int | NO |  |  |  |
| minimumstoragetemperature | varchar(8) | NO |  |  |  |
| maximumstoragetemperature | varchar(8) | NO |  |  |  |
| minimumrelhumid | varchar(8) | NO |  |  |  |
| maximumrelhumid | varchar(8) | NO |  |  |  |
| feedbackurllink | varchar(128) | NO |  |  |  |
| shopifydesc | longtext | NO |  |  |  |
| shopifytitle | varchar(70) | NO |  |  |  |
| Shopify_Tag_String | varchar(200) | NO |  |  |  |
| Shopify_Product_Type | varchar(200) | NO |  |  |  |
| Shopify_SEO_Title | varchar(200) | NO |  |  |  |
| Shopify_SEO_Description | varchar(200) | NO |  |  |  |
| shopify_url_img | varchar(200) | NO |  |  |  |
| AI_FAQURL | varchar(128) | NO |  |  |  |
| exclusivetomemo | longtext | NO |  |  |  |
| fda_number | varchar(128) | NO |  |  |  |
| excludestockcount | tinyint | NO |  |  |  |
| allowpriceexport | tinyint | NO |  |  |  |

-e 
## viamed_memos_history
## `viamed_memos_history`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| addedon | bigint | NO |  | 0 |  |
| addedby | int | NO |  |  |  |
| memotype | int | NO |  |  |  |
| memo | longtext | NO |  |  |  |
| opera | varchar(12) | NO |  |  |  |
| companyid | int | NO |  |  |  |
| contactid | int | NO |  |  |  |

## `viamed_motd`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| date | varchar(100) | NO |  |  |  |
| createdby | varchar(100) | NO |  |  |  |
| verifiedby | varchar(100) | NO |  |  |  |
| motd | longtext | NO |  |  |  |

## `viamed_motd_read`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| motdid | int | NO |  |  |  |
| date | varchar(100) | NO |  |  |  |
| userid | varchar(100) | NO |  |  |  |

## `viamed_new_products`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| product_name | varchar(64) | NO |  |  |  |
| marketing_level | int | NO |  | 0 |  |
| current_level | int | NO |  | 0 |  |
| created_by | varchar(32) | NO |  |  |  |
| created_on | bigint | NO |  | 0 |  |
| status | varchar(32) | NO |  |  |  |
| ce_family_type | int | NO |  |  |  |
| coordinator | varchar(64) | NO |  |  |  |
| agendaid | int | NO |  |  |  |
| priority | int | NO |  |  |  |
| projectid | int | NO |  |  |  |

## `viamed_new_products_details`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| id_requirement | int | NO |  | 0 |  |
| status | varchar(12) | NO |  |  |  |
| added_by | varchar(32) | NO |  |  |  |
| added_on | bigint | NO |  | 0 |  |
| documentindex_id | int | NO |  | 0 |  |
| file_link | varchar(32) | NO |  |  |  |
| notes | longtext | NO |  |  |  |
| product_id | int | NO |  | 0 |  |

## `viamed_new_products_requirements`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| market_level | int | NO |  | 0 |  |
| stage | int | NO |  | 0 |  |
| header | varchar(32) | NO |  |  |  |
| added_by | varchar(32) | NO |  |  |  |
| added_on | bigint | NO |  | 0 |  |
| notes | longtext | NO |  |  |  |

## `viamed_newshop_catagorys`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| shopid | varchar(128) | NO |  |  |  |
| maincatid | int | NO |  |  |  |
| name | varchar(128) | NO |  |  |  |
| description | longtext | NO |  |  |  |
| image | varchar(64) | NO |  |  |  |
| live | varchar(4) | NO |  |  |  |
| verified | varchar(4) | NO |  |  |  |
| verifiedby | varchar(32) | NO |  |  |  |
| datemod | varchar(32) | NO |  |  |  |
| updateby | varchar(64) | NO |  |  |  |
| displayorder | int | NO |  |  |  |
| altext | varchar(128) | NO |  |  |  |
| industry | int | NO |  |  |  |

## `viamed_newshop_consign_stock`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| stk_ref | varchar(16) | NO |  |  |  |
| barcode | int | NO |  |  |  |
| serial_number | varchar(64) | NO |  |  |  |
| description | varchar(64) | NO |  |  |  |
| lastupdated | bigint | NO |  | 0 |  |
| lastupdatedby | varchar(128) | NO |  |  |  |
| locationid | int | NO |  |  |  |
| user_status | varchar(36) | NO |  |  |  |
| viamed_status | varchar(12) | NO |  |  |  |
| viamedupdated | int | NO |  |  |  |
| viamedupdateby | varchar(32) | NO |  |  |  |
| used | int | NO |  |  |  |
| jobnumber | varchar(128) | NO |  |  |  |
| jobnumberaddedon | bigint | NO |  | 0 |  |
| jobnumberaddedby | varchar(128) | NO |  |  |  |
| matchedon | bigint | NO |  | 0 |  |
| dilstatus | varchar(5) | NO |  |  |  |
| invnum | varchar(16) | NO |  |  |  |
| completed | int | NO |  |  |  |

## `viamed_newshop_emails`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| subject | varchar(250) | NO |  |  |  |
| messagebody | longtext | NO |  |  |  |
| fromemail | varchar(250) | NO |  |  |  |
| tocompany | varchar(32) | NO |  |  |  |
| requestedon | bigint | NO |  | 0 |  |
| replyedby | varchar(64) | NO |  |  |  |
| replyedon | bigint | NO |  | 0 |  |
| google | varchar(10) | NO |  |  |  |
| webid | int | NO |  |  |  |

## `viamed_newshop_file_index`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| addedby | varchar(32) | NO |  |  |  |
| addedon | varchar(32) | NO |  |  |  |
| docname | varchar(90) | NO |  |  |  |
| description | varchar(128) | NO |  |  |  |
| filetype | int | NO |  |  |  |
| oldid | int | NO |  |  |  |
| archived | int | NO |  |  |  |
| exp_date | int | NO |  |  |  |
| thumb_nail | varchar(16) | NO |  |  |  |
| shopid | varchar(128) | NO |  |  |  |

## `viamed_newshop_file_product`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| productid | varchar(64) | NO |  |  |  |
| fileid | int | NO |  |  |  |
| shopid | varchar(128) | NO |  |  |  |
| ord | int | NO |  |  |  |
| primaryid | int | NO |  |  |  |

## `viamed_newshop_logfile`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| location | longtext | NO |  |  |  |
| uid | int | NO |  |  |  |
| accesstime | bigint | NO |  | 0 |  |
| ip | varchar(32) | NO |  |  |  |

## `viamed_newshop_products`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| shopid | varchar(128) | NO |  |  |  |
| PRODUCTID | varchar(12) | NO |  |  |  |
| PRODUCTNAM | varchar(64) | NO |  |  |  |
| SEARCHREF | longtext | NO |  |  |  |
| SHORTDESCR | longtext | NO |  |  |  |
| LONGDESCRI | longtext | NO |  |  |  |
| IMAGEURL | varchar(92) | NO |  |  |  |
| ACTUALWEIG | varchar(8) | NO |  |  |  |
| VOLUMETRIC | varchar(8) | NO |  |  |  |
| LIVE | varchar(8) | NO |  |  |  |
| VERIFIED | varchar(8) | NO |  |  |  |
| VERIFIEDBY | varchar(16) | NO |  |  |  |
| STOCK | int | NO |  |  |  |
| SHOWPRICE | varchar(8) | NO |  |  |  |
| DATEMODIFI | varchar(16) | NO |  |  |  |
| REFERENCET | varchar(64) | NO |  |  |  |
| ORDERINGNU | varchar(64) | NO |  |  |  |
| CATEGORYID | int | NO |  |  |  |
| ALLADD | varchar(6) | NO |  |  |  |
| PRIORITY | int | NO |  |  |  |
| FOCDELIVERY | varchar(5) | NO |  |  |  |
| EAN13 | varchar(20) | NO |  |  |  |

## `viamed_newshop_products_catagorys`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| shopid | varchar(128) | NO |  |  |  |
| catid | varchar(16) | NO |  |  |  |
| productopera | varchar(16) | NO |  |  |  |
| verifiedby | varchar(32) | NO |  |  |  |
| datemod | varchar(32) | NO |  |  |  |
| productid | varchar(16) | NO |  |  |  |
| priority | int | NO |  |  |  |

## `viamed_newshop_shipping_country_zones`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| shopid | varchar(128) | NO |  |  |  |
| country | varchar(128) | NO |  |  |  |
| method | varchar(24) | NO |  |  |  |
| zone | varchar(9) | NO |  |  |  |

## `viamed_newshop_webindustrys`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| description | varchar(64) | NO |  |  |  |
| active | int | NO |  |  |  |
| ord | int | NO |  |  |  |
| bannerbar | longtext | NO |  |  |  |

## `viamed_newshop_webindustrys_stock`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO |  |  |  |
| industry | int | NO |  |  |  |
| stock_ref | varchar(16) | NO |  |  |  |
| allowed | int | NO |  |  |  |
| addedby | int | NO |  |  |  |
| addedon | bigint | NO |  | 0 |  |

## `viamed_nom_headers`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| header | varchar(40) | NO |  |  |  |
| group | varchar(40) | NO |  |  |  |

## `viamed_objectives`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| section | varchar(64) | NO |  |  |  |
| objective | longtext | NO |  |  |  |
| report_php | varchar(128) | NO |  |  |  |
| addedby | int | NO |  |  |  |
| addedon | int | NO |  |  |  |

## `viamed_objectives_notes`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| objective_id | int | NO |  |  |  |
| notes | longtext | NO |  |  |  |
| addedby | int | NO |  |  |  |
| addedon | int | NO |  |  |  |

## `viamed_operacreditlimits`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| opera | varchar(12) | NO |  |  |  |
| primary_company_id | int | NO |  |  |  |
| currency | varchar(3) | NO |  |  |  |
| account_limit | int | NO |  |  |  |
| account_days | int | NO |  |  |  |
| terms | varchar(100) | NO |  |  |  |
| notes | longtext | NO |  |  |  |

## `viamed_order_watch`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| username | varchar(32) | NO |  |  |  |
| ordernumber | varchar(12) | NO |  |  |  |
| status | varchar(12) | NO |  |  |  |

## `viamed_overview`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| year | int | NO |  |  |  |
| month | mediumint | NO |  |  |  |
| stock | int | NO |  |  |  |
| bank | int | NO |  |  |  |
| debtors | int | NO |  |  |  |
| creditors | int | NO |  |  |  |
| sales | int | NO |  |  |  |

## `viamed_oxygensensorlimits`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| stockref | varchar(16) | NO |  |  |  |
| lowerlimito2 | float(8,4) | NO |  |  |  |
| higherlimito2 | float(8,4) | NO |  |  |  |
| updatedby | int | NO |  |  |  |
| updatedon | bigint | NO |  | 0 |  |
| accuracyhigh | float(8,4) | NO |  |  |  |
| active | tinyint | NO |  |  |  |

## `viamed_packaging_lists`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| mainid | int | NO |  |  |  |
| userid | int | NO |  |  |  |
| stock_ref | varchar(12) | NO |  |  |  |
| qty | int | NO |  |  |  |
| addedon | bigint | NO |  | 0 |  |

## `viamed_packaging_sizes`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| description | varchar(36) | NO |  |  |  |
| width | float | NO |  |  |  |
| length | float | NO |  |  |  |
| height | float | NO |  |  |  |
| weight | float | NO |  |  |  |
| stock_ref | varchar(16) | NO |  |  |  |
| internalwidth | float(10,2) | NO |  |  |  |
| internalheight | float(10,2) | NO |  |  |  |
| internallength | float(10,2) | NO |  |  |  |
| active | varchar(8) | NO |  |  |  |

## `viamed_pcs`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| ip | varchar(24) | NO |  |  |  |
| memo | longtext | NO |  |  |  |
| addedon | bigint | NO |  | 0 |  |
| os | varchar(12) | YES |  |  |  |
| wrd | varchar(12) | YES |  |  |  |
| hd | varchar(12) | YES |  |  |  |
| mem | varchar(12) | YES |  |  |  |
| cpu | varchar(12) | YES |  |  |  |
| userpc | varchar(12) | YES |  |  |  |

## `viamed_po_logs`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| porref | varchar(14) | NO |  |  |  |
| sentvia | varchar(5) | NO |  |  |  |
| sentby | varchar(32) | NO |  |  |  |
| confirmeddate | bigint | NO |  | 0 |  |
| confirmedvia | varchar(5) | NO |  |  |  |
| confirmedby | varchar(32) | NO |  |  |  |
| estshipdate | bigint | NO |  | 0 |  |
| stock_ref | varchar(24) | NO |  |  |  |
| donotchase | varchar(1) | NO |  |  |  |
| notes | longtext | NO |  |  |  |
| shipmethod | int | NO |  |  |  |
| notsent | varchar(1) | NO |  |  |  |
| confirmnumber | varchar(32) | NO |  |  |  |
| arriveshipdate | bigint | NO |  | 0 |  |
| arriveby | varchar(32) | NO |  |  |  |
| qty | int | NO |  |  |  |
| contactid | int | NO |  |  |  |
| companyid | int | NO |  |  |  |
| ordernumber | varchar(23) | NO |  |  |  |
| docid | int | NO |  |  |  |
| pogenby | int | NO |  |  |  |
| updatedby | int | NO |  |  |  |
| updatedon | bigint | NO |  | 0 |  |
| confirmedvalidon | bigint | NO |  | 0 |  |
| confirmedvalidby | int | NO |  |  |  |
| orderdetailid | int | NO |  |  |  |
| tracknum | varchar(48) | NO |  |  |  |
| estimatedateconfirmed | tinyint | NO |  |  |  |

## `viamed_po_logs_docs`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| poref | varchar(16) | NO |  |  |  |
| docid | int | NO |  |  |  |
| addedby | int | NO |  |  |  |
| addedon | int | NO |  |  |  |

## `viamed_po_logs_est_ship`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| po | varchar(24) | NO |  |  |  |
| stockref | varchar(24) | NO |  |  |  |
| estqty | int | NO |  |  |  |
| estship | bigint | NO |  | 0 |  |
| actship | bigint | NO |  | 0 |  |
| actshipqty | int | NO |  |  |  |
| addedby | int | NO |  |  |  |
| addedon | bigint | NO |  | 0 |  |
| updatedby | int | NO |  |  |  |
| updatedon | bigint | NO |  | 0 |  |
| porderid | int | NO |  |  |  |

## `viamed_po_logs_flag`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| addedon | bigint | NO |  | 0 |  |
| addedby | int | NO |  |  |  |
| usergroupid | int | NO |  |  |  |
| poref | varchar(16) | NO |  |  |  |
| stkref | varchar(16) | NO |  |  |  |

## `viamed_po_logs_history`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| porref | varchar(14) | NO |  |  |  |
| sentvia | varchar(5) | NO |  |  |  |
| sentby | varchar(32) | NO |  |  |  |
| confirmeddate | bigint | NO |  | 0 |  |
| confirmedvia | varchar(5) | NO |  |  |  |
| confirmedby | varchar(32) | NO |  |  |  |
| estshipdate | bigint | NO |  | 0 |  |
| stock_ref | varchar(24) | NO |  |  |  |
| donotchase | varchar(1) | NO |  |  |  |
| notes | longtext | NO |  |  |  |
| nextupdatedate | bigint | NO |  | 0 |  |
| nextupdateby | varchar(64) | NO |  |  |  |
| confirmedvalidon | bigint | NO |  | 0 |  |
| confirmedvalidby | int | NO |  |  |  |
| orderdetailid | int | NO |  |  |  |
| company_id | int | NO |  |  |  |
| hostcompanyid | int | NO |  |  |  |
| qty | int | NO |  |  |  |

## `viamed_po_watch_list`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| name | varchar(64) | NO |  |  |  |
| po | varchar(10) | NO |  |  |  |
| stock_ref | varchar(12) | NO |  |  |  |
| estshipdate | int | NO |  |  |  |
| status | varchar(10) | NO |  |  |  |
| addedby | int | NO |  |  |  |
| addedon | bigint | NO |  | 0 |  |
| lineid | int | NO |  |  |  |

## `viamed_post_market_orders`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| DELIVERY | varchar(16) | NO |  |  |  |
| confirmedby | varchar(32) | NO |  |  |  |
| confirmedon | int | NO |  |  |  |
| note | longtext | NO |  |  |  |
| status | varchar(12) | NO |  |  |  |
| contactid | int | NO |  |  |  |
| companyid | int | NO |  |  |  |

## `viamed_post_market_sales_accounts`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| reportid | int | NO |  |  |  |
| account | varchar(12) | NO |  |  |  |

## `viamed_post_market_sales_answers`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| questionid | int | NO |  |  |  |
| reportid | int | NO |  |  |  |
| answer | longtext | NO |  |  |  |
| furtheraction | text | NO |  |  |  |

## `viamed_post_market_sales_questions`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| questiontext | longtext | NO |  |  |  |
| pms_id | int | NO |  |  |  |
| headline | varchar(128) | NO |  |  |  |

## `viamed_post_market_sales_report_account_notes`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| reportid | int | NO |  |  |  |
| account | varchar(12) | NO |  |  |  |
| notes | longtext | NO |  |  |  |
| pmsid | varchar(12) | NO |  |  |  |
| territory | varchar(32) | NO |  |  |  |
| fieldcode | varchar(128) | NO |  |  |  |
| addedon | bigint | NO |  | 0 |  |
| addedby | bigint | NO |  | 0 |  |
| stockref | varchar(12) | NO |  |  |  |

## `viamed_post_market_sales_reports`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| datecode | bigint | NO |  | 0 |  |
| userid | int | NO |  |  |  |
| addedby | varchar(32) | NO |  |  |  |
| updatedon | bigint | NO |  | 0 |  |
| status | varchar(32) | NO |  |  |  |
| salesgroupname | varchar(250) | NO |  |  |  |

## `viamed_ppq_position`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| description | varchar(200) | NO |  |  |  |
| question | int | NO |  | 0 |  |
| page | varchar(100) | NO |  |  |  |
| x2 | varchar(100) | NO |  |  |  |
| y2 | varchar(100) | NO |  |  |  |
| x | varchar(100) | NO |  |  |  |
| y | varchar(100) | NO |  |  |  |
| filter | int | NO |  |  |  |
| tablename | varchar(64) | NO |  |  |  |
| fieldname | varchar(64) | NO |  |  |  |
| functionality | varchar(64) | NO |  |  |  |

## `viamed_ppq_questions`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| ppqid | varchar(100) | NO |  |  |  |
| page | varchar(100) | NO |  |  |  |
| question | int | NO |  | 0 |  |
| locked | varchar(100) | NO |  |  |  |
| answer | varchar(100) | NO |  |  |  |

## `viamed_price_review`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| stockref | varchar(12) | NO |  |  |  |
| hostcompany | int | NO |  |  |  |
| reviewedby | int | NO |  |  |  |
| reviewedon | int | NO |  |  |  |
| status | varchar(32) | NO |  |  |  |
| freightpercent | float(10,2) | NO |  |  |  |
| taxpercent | float(10,2) | NO |  |  |  |
| processingpercent | float(10,2) | NO |  |  |  |
| landedpricegbp | float(10,2) | NO |  |  |  |
| finalcost | float(10,2) | NO |  |  |  |

## `viamed_pricelist_log`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| addedon | bigint | NO |  | 0 |  |
| addedby | int | NO |  |  |  |
| description | varchar(128) | NO |  |  |  |
| status | int | NO |  |  |  |

## `viamed_pricelist_log_stk`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| priceid | int | NO |  |  |  |
| stkref | varchar(12) | NO |  |  |  |

## `viamed_product_recall`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| addedby | int | NO |  |  |  |
| addedon | bigint | NO |  | 0 |  |
| ccn | int | NO |  |  |  |
| issue | int | NO |  |  |  |
| description | longtext | NO |  |  |  |
| status | int | NO |  |  |  |

## `viamed_product_recall_details`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| barcode | int | NO |  |  |  |
| addedby | int | NO |  |  |  |
| addedon | bigint | NO |  | 0 |  |
| status | int | NO |  |  |  |
| updatedon | int | NO |  |  |  |
| updatedby | int | NO |  |  |  |
| replace_barcode | int | NO |  |  |  |
| replace_by | int | NO |  |  |  |
| replace_on | int | NO |  |  |  |
| vprid | int | NO |  |  |  |

## `viamed_product_recall_status`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| description | varchar(64) | NO |  |  |  |

## `viamed_production_jobs`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| stock_ref | varchar(10) | NO |  |  |  |
| qty | varchar(100) | NO |  |  |  |
| createdby | varchar(100) | NO |  |  |  |
| createon | varchar(100) | NO |  |  |  |
| stage | varchar(100) | NO |  |  |  |
| startedby | varchar(100) | NO |  |  |  |
| startedon | varchar(100) | NO |  |  |  |
| completedby | varchar(100) | NO |  |  |  |
| completedon | varchar(100) | NO |  |  |  |
| cancelledon | varchar(100) | NO |  |  |  |
| cancelledby | varchar(100) | NO |  |  |  |
| produceorder | decimal(10,0) | NO |  | 2 |  |
| urgent | varchar(100) | NO |  |  |  |
| operadone | varchar(3) | NO |  |  |  |
| operaby | varchar(64) | NO |  |  |  |
| operaref | bigint | NO |  | 0 |  |
| customer_ord | varchar(12) | NO |  |  |  |
| deadline | bigint | NO |  | 0 |  |
| memo | longtext | NO |  |  |  |
| priority | int | NO |  |  |  |
| producedby | int | NO |  |  |  |
| company_id | int | NO |  |  |  |
| memoby | int | NO |  |  |  |

## `viamed_production_jobs_extraparts`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| jobid | int | NO |  |  |  |
| stock_ref | varchar(16) | NO |  |  |  |
| qty | int | NO |  |  |  |
| addedby | varchar(64) | NO |  |  |  |
| addedon | bigint | NO |  | 0 |  |
| operadone | varchar(3) | NO |  |  |  |
| operaby | varchar(64) | NO |  |  |  |
| operaref | bigint | NO |  | 0 |  |
| mergeid | bigint | NO |  | 0 |  |
| serviceid | int | NO |  |  |  |

## `viamed_production_jobs_times`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| addedby | int | NO |  |  |  |
| addedon | bigint | NO |  |  |  |
| timeinsecs | int | NO |  |  |  |
| memo | longtext | NO |  |  |  |
| production_id | int | NO |  |  |  |

## `viamed_purchase_orders_errors`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| orderid | int | NO |  |  |  |
| memo | longtext | NO |  |  |  |

## `viamed_quotes`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| quote | varchar(16) | NO |  |  |  |
| status | varchar(5) | NO |  |  |  |
| updatedby | int | NO |  |  |  |
| updatedon | bigint | NO |  | 0 |  |
| notes | longtext | NO |  |  |  |
| responsibleuser | int | NO |  |  |  |
| expecteddate | int | NO |  |  |  |
| chance | int | NO |  |  |  |
| stockref | varchar(64) | NO |  |  |  |

## `viamed_quotes_history`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| quote | varchar(10) | NO |  |  |  |
| status | int | NO |  |  |  |
| notes | longtext | NO |  |  |  |
| stockref | varchar(24) | NO |  |  |  |
| addedby | int | NO |  |  |  |
| addedon | bigint | NO |  | 0 |  |
| responsibleuser | int | NO |  |  |  |
| expecteddate | int | NO |  |  |  |
| chance | int | NO |  |  |  |
| daylink | varchar(12) | NO |  |  |  |

## `viamed_quotes_status`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| description | varchar(64) | NO |  |  |  |

## `viamed_receipts_match_opera`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| bankid | int | NO |  |  |  |
| operaaccount | varchar(12) | NO |  |  |  |
| operareference | varchar(48) | NO |  |  |  |
| operatype | varchar(16) | NO |  |  |  |
| paid_flag | int | NO |  |  |  |
| linkedby | int | NO |  |  |  |
| linkedon | int | NO |  |  |  |

## `viamed_reminder_details`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| operaac | varchar(12) | NO |  |  |  |
| headerid | varchar(12) | NO |  |  |  |
| date | varchar(16) | NO |  |  |  |
| reminderby | varchar(24) | NO |  |  |  |
| notes | longtext | NO |  |  |  |
| sent_statement | char(3) | NO |  |  |  |
| sent_copyinvoice | char(3) | NO |  |  |  |
| phone | char(3) | NO |  |  |  |
| email | char(3) | NO |  |  |  |
| post | char(3) | NO |  |  |  |
| fax | char(3) | NO |  |  |  |
| datepromised | varchar(12) | NO |  |  |  |
| contactname | varchar(64) | NO |  |  |  |
| contact_id | int | NO |  |  |  |

## `viamed_reminder_details_invoices`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| detailid | int | NO |  | 0 |  |
| reference | varchar(12) | NO |  |  |  |
| date | varchar(12) | NO |  |  |  |
| spare | varchar(12) | NO |  |  |  |

## `viamed_reminder_header`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| join_id | varchar(10) | NO |  |  |  |
| opera_ac | varchar(12) | NO |  |  |  |
| updatedby | varchar(40) | NO |  |  |  |
| companyname | varchar(64) | NO |  |  |  |
| contactname | varchar(40) | NO |  |  |  |
| contactnumber | varchar(40) | NO |  |  |  |
| faxnumber | varchar(40) | NO |  |  |  |
| emailaddress | varchar(125) | NO |  |  |  |
| add1 | varchar(80) | NO |  |  |  |
| add2 | varchar(80) | NO |  |  |  |
| add3 | varchar(80) | NO |  |  |  |
| postcode | varchar(12) | NO |  |  |  |
| notes | longtext | NO |  |  |  |
| last_reminder | varchar(20) | NO |  |  |  |

## `viamed_remits`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| docid | int | NO |  |  |  |
| remittanceid | int | NO |  |  |  |
| addedby | int | NO |  |  |  |
| addedon | bigint | NO |  | 0 |  |
| matchedon | bigint | NO |  | 0 |  |
| matchedby | int | NO |  |  |  |
| bankaccountref | varchar(16) | NO |  |  |  |
| operaaccount | varchar(10) | NO |  |  |  |
| operaaccountname | varchar(100) | NO |  |  |  |
| paid_flag | int | NO |  |  |  |
| bankid | int | NO |  |  |  |
| amount | float(10,2) | NO |  |  |  |
| originaloperaaccount | varchar(12) | NO |  |  |  |
| originaloperaname | varchar(60) | NO |  |  |  |
| invoicereference | varchar(16) | NO |  |  |  |
| bankremitlinkedon | bigint | NO |  | 0 |  |
| bankremitlinkedby | int | NO |  |  |  |
| visa | varchar(8) | NO |  |  |  |
| paymentrundate | bigint | NO |  | 0 |  |

## `viamed_remits_abb`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| abb | varchar(20) | NO |  |  |  |
| description | varchar(100) | NO |  |  |  |
| addedon | int | NO |  |  |  |
| addedby | bigint | NO |  | 0 |  |

## `viamed_remits_paid`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| remit_ref | varchar(12) | NO |  |  |  |
| account | varchar(12) | NO |  |  |  |
| paidflag | varchar(8) | NO |  |  |  |
| addedby | varchar(24) | NO |  |  |  |
| docid | varchar(24) | NO |  |  |  |
| status | varchar(12) | NO |  |  |  |
| addeddate | bigint | NO |  | 0 |  |

## `viamed_sale_return`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| headerid | int | NO |  |  |  |
| serialid | varchar(100) | NO |  |  |  |
| serialnumber | varchar(100) | NO |  |  |  |
| stock_ref | varchar(100) | NO |  |  |  |
| operaid | varchar(100) | NO |  |  |  |
| datesent | varchar(100) | NO |  |  |  |
| datereturned | bigint | NO |  | 0 |  |
| status | varchar(100) | NO |  |  |  |
| type | varchar(100) | NO |  |  |  |
| functio | varchar(100) | NO |  |  |  |
| purpose | varchar(100) | NO |  |  |  |
| sentby | varchar(100) | NO |  |  |  |
| responsibleuser | varchar(64) | NO |  |  |  |
| revieweddate | bigint | NO |  |  |  |
| reviewedby | varchar(64) | NO |  |  |  |
| contactid | int | NO |  |  |  |
| companyid | int | NO |  |  |  |
| givenstockallocated | int | NO |  |  |  |
| chasedby | int | NO |  |  |  |
| chasedon | bigint | NO |  |  |  |
| expiredate | bigint | NO |  |  |  |
| typesor | varchar(64) | NO |  |  |  |
| success | varchar(64) | NO |  |  |  |
| notes | longtext | NO |  |  |  |

## `viamed_salereturnhead`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| operaid | varchar(100) | NO |  |  |  |
| createdate | bigint | NO |  | 0 |  |
| contactname | varchar(100) | NO |  |  |  |
| companyname | varchar(100) | NO |  |  |  |
| department | varchar(100) | NO |  |  |  |
| add1 | varchar(100) | NO |  |  |  |
| add2 | varchar(100) | NO |  |  |  |
| add3 | varchar(100) | NO |  |  |  |
| add4 | varchar(100) | NO |  |  |  |
| postcode | varchar(100) | NO |  |  |  |
| sentby | varchar(100) | NO |  |  |  |
| status | varchar(100) | NO |  |  |  |
| shipnotes | longtext | NO |  |  |  |
| addedby | varchar(32) | NO |  |  |  |
| addedon | bigint | NO |  |  |  |
| responsibleuser | varchar(64) | NO |  |  |  |
| revieweddate | bigint | NO |  |  |  |
| reviewedby | varchar(64) | NO |  |  |  |
| telephone | varchar(64) | NO |  |  |  |
| email | varchar(128) | NO |  |  |  |
| contactid | int | NO |  |  |  |
| companyid | int | NO |  |  |  |
| statustext | varchar(32) | NO |  |  |  |
| statustextby | int | NO |  |  |  |
| statustexton | bigint | NO |  |  |  |
| valueforcustoms | varchar(16) | NO |  |  |  |
| cancelledby | int | NO |  |  |  |
| cancelledon | bigint | NO |  |  |  |
| issueid | int | NO |  |  |  |
| goodsinflag | varchar(9) | NO |  |  |  |
| expdate | varchar(24) | NO |  |  |  |
| datesent | bigint | NO |  |  |  |
| delivdate | varchar(24) | NO |  |  |  |
| typesor | varchar(64) | NO |  |  |  |
| position1 | varchar(64) | NO |  |  |  |

## `viamed_sales_forcasts`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| user | varchar(32) | NO |  |  |  |
| addedon | bigint | NO |  | 0 |  |
| stock_ref | varchar(24) | NO |  |  |  |
| year | int | NO |  |  |  |
| month | int | NO |  |  |  |
| qty | int | NO |  |  |  |
| region | varchar(5) | NO |  |  |  |
| vui | int | NO |  |  |  |
| companyid | int | NO |  |  |  |
| contactid | int | NO |  |  |  |
| currency | varchar(5) | NO |  |  |  |
| salesorpurchase | tinyint | NO |  |  |  |
| hostcompanyid | int | NO |  |  |  |

## `viamed_sales_forcasts_reviewed`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| addedby | int | NO |  |  |  |
| addedon | bigint | NO |  |  |  |
| stock_ref | varchar(12) | NO |  |  |  |
| notes | longtext | NO |  |  |  |
| region | varchar(12) | NO |  |  |  |

## `viamed_sales_ukmap`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| user | varchar(64) | NO |  |  |  |
| operaaccount | varchar(12) | NO |  |  |  |
| icontype | int | NO |  |  |  |
| link | varchar(128) | NO |  |  |  |
| hovertext | longtext | NO |  |  |  |

## `viamed_sensorrecycle`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| operaaccount | varchar(16) | NO |  |  |  |
| stockref | varchar(16) | NO |  |  |  |
| companyid | int | NO |  |  |  |
| contactid | int | NO |  |  |  |
| contact_monthyear | varchar(7) | NO |  |  |  |
| addedby | int | NO |  |  |  |
| addedon | int | NO |  |  |  |

## `viamed_service_details`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| currentid | int | NO |  |  |  |
| primaryid | int | NO |  |  |  |
| locationnotes | longtext | NO |  |  |  |
| hotelnotes | longtext | NO |  |  |  |
| timebooked | longtext | NO |  |  |  |
| allconfirmed | varchar(7) | NO |  |  |  |
| worksignedoff | varchar(7) | NO |  |  |  |
| wordsignedoffcontactid | int | NO |  |  |  |
| engineernotes | longtext | NO |  |  |  |
| engineerid | int | NO |  |  |  |
| completionnotes | longtext | NO |  |  |  |
| servicereportsent | varchar(3) | NO |  |  |  |
| servicereportsentto | int | NO |  |  |  |
| dateserviced | date | NO |  |  |  |
| engineervisistcomplete | varchar(1) | NO |  |  |  |
| engineervisistcompletedate | bigint | NO |  | 0 |  |
| servicereportconfirm | varchar(1) | NO |  |  |  |
| servicereportconfirmdate | bigint | NO |  | 0 |  |
| sendinvoice | bigint | NO |  | 0 |  |
| sendinvoiceby | int | NO |  |  |  |
| scanparts | bigint | NO |  | 0 |  |
| scanpartsby | int | NO |  |  |  |
| engineerpartsnotes | longtext | NO |  |  |  |

## `viamed_service_eng_stk`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| employid | int | NO |  |  |  |
| stock_ref | varchar(32) | NO |  |  |  |

## `viamed_service_equipment`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| visitid | int | NO |  |  |  |
| companyid | int | NO |  |  |  |
| contactid | int | NO |  |  |  |
| stock_ref | varchar(32) | NO |  |  |  |
| description | varchar(128) | NO |  |  |  |
| lastserviced | int | NO |  |  |  |
| lastservicedby | varchar(64) | NO |  |  |  |
| serialnumber | varchar(128) | NO |  |  |  |
| barcode | varchar(128) | NO |  |  |  |
| assetnumber | varchar(128) | NO |  |  |  |
| notes | longtext | NO |  |  |  |
| currentstatus | varchar(32) | NO |  |  |  |
| servicedby | varchar(64) | NO |  |  |  |
| engineerid | int | NO |  |  |  |
| servicedon | bigint | NO |  | 0 |  |
| status | varchar(1) | NO |  |  |  |

## `viamed_service_items_reminders`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| barcode | int | NO |  |  |  |
| reminded | bigint | NO |  | 0 |  |
| donotchase | int | NO |  |  |  |
| serviced | bigint | NO |  | 0 |  |
| updatedby | int | NO |  |  |  |
| updatedon | bigint | NO |  | 0 |  |
| code | varchar(1) | NO |  |  |  |
| nextreminddate | bigint | NO |  | 0 |  |

## `viamed_service_visits`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| primaryid | int | NO |  |  |  |
| companyid | int | NO |  |  |  |
| contactid | int | NO |  |  |  |
| duedate | bigint | NO |  | 0 |  |
| recursmonths | int | NO |  |  |  |
| addedby | varchar(32) | NO |  |  |  |
| addedon | bigint | NO |  | 0 |  |
| customerorder | varchar(32) | NO |  |  |  |
| operaorder | varchar(12) | NO |  |  |  |
| status | varchar(12) | NO |  |  |  |
| engineerid | int | NO |  |  |  |
| bookedfordate | bigint | NO |  | 0 |  |
| completedon | bigint | NO |  | 0 |  |
| completedby | varchar(32) | NO |  |  |  |
| description | varchar(128) | NO |  |  |  |
| customersignedoff | varchar(64) | NO |  |  |  |

## `viamed_shipping_calc_details`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| calc_id | int | NO |  | 0 |  |
| actual_weight | float | NO |  | 0 |  |
| width | float | NO |  | 0 |  |
| height | float | NO |  | 0 |  |
| length | float | NO |  | 0 |  |
| VolumetricWeight | float | NO |  | 0 |  |
| weightused | float | NO |  | 0 |  |
| warnings | varchar(128) | NO |  |  |  |

## `viamed_shipping_calc_header`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| addedby | varchar(64) | NO |  |  |  |
| addedon | varchar(12) | NO |  |  |  |
| ordernumber | varchar(12) | NO |  |  |  |

## `viamed_shipping_options`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| company | varchar(24) | NO |  |  |  |
| service | varchar(48) | NO |  |  |  |
| notes | longtext | NO |  |  |  |
| modifiedby | varchar(32) | NO |  |  |  |
| modifiedon | varchar(32) | NO |  |  |  |
| accountnumber | varchar(64) | NO |  |  |  |
| direction | int | NO |  |  |  |
| disporder | int | NO |  |  |  |
| showgoodsin | int | NO |  |  |  |

## `viamed_shipping_options_account`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| opera | varchar(12) | NO |  |  |  |
| optionid | int | NO |  | 0 |  |
| p | varchar(8) | NO |  |  |  |
| notes | longtext | NO |  |  |  |
| modifiedby | varchar(32) | NO |  |  |  |
| modifiedon | varchar(32) | NO |  |  |  |
| accountnumber | varchar(64) | NO |  |  |  |
| contactid | int | NO |  |  |  |
| companyid | int | NO |  |  |  |
| notesby | int | NO |  |  |  |
| noteson | bigint | NO |  | 0 |  |

## `viamed_staff_prioritys`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| user | varchar(32) | NO |  |  |  |
| user_id | int | NO |  | 0 |  |
| header | varchar(64) | NO |  |  |  |
| notes | longtext | NO |  |  |  |
| priority | int | NO |  | 0 |  |
| status | varchar(12) | NO |  |  |  |
| usernotes | longtext | NO |  |  |  |
| userupdate | varchar(64) | NO |  |  |  |
| addedby | varchar(64) | NO |  |  |  |
| addedon | varchar(64) | NO |  |  |  |
| removedby | varchar(64) | NO |  |  |  |
| removedon | varchar(64) | NO |  |  |  |
| movedon | varchar(64) | NO |  |  |  |
| movedby | varchar(64) | NO |  |  |  |

## `viamed_stock_calcs`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO |  |  |  |
| stock_ref | varchar(12) | NO |  |  |  |
| lastyearsalesvalue | float(10,2) | NO |  |  |  |
| lastyearsales | int | NO |  |  |  |
| currentyearestimatevalue | float(10,2) | NO |  |  |  |
| currentyearqtyestimate | int | NO |  |  |  |
| stockvalue | float(10,2) | NO |  |  |  |
| stockqty | int | NO |  |  |  |
| percentstocktosalesonestimate | float(10,2) | NO |  |  |  |
| monthlyusage | int | NO |  |  |  |
| monthsofstock | int | NO |  |  |  |
| monthstodeliver | int | NO |  |  |  |

## `viamed_stock_groups2`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| description | varchar(254) | NO |  |  |  |
| owner | int | NO |  |  |  |
| addedon | int | NO |  |  |  |
| addedby | int | NO |  |  |  |

## `viamed_stock_groups2_details`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| stockref | varchar(16) | NO |  |  |  |
| addedby | int | NO |  |  |  |
| addedon | int | NO |  |  |  |
| group2id | int | NO |  |  |  |

## `viamed_stock_slowingsales`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| stock_ref | varchar(12) | NO |  |  |  |
| addedby | int | NO |  |  |  |
| addedon | bigint | NO |  | 0 |  |
| status | int | NO |  |  |  |

## `viamed_stock_valuations`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| stock_ref | varchar(12) | NO |  |  |  |
| operaqty | int | NO |  |  |  |
| barcodeqty | int | NO |  |  |  |
| unitvalue | float(10,2) | NO |  |  |  |
| date_taken | int | NO |  |  |  |
| stock_tag | varchar(16) | NO |  |  |  |

## `viamed_stockgroup`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| description | varchar(250) | NO |  |  |  |
| ownerid | int | NO |  |  |  |
| ownername | varchar(100) | NO |  |  |  |
| addedon | int | NO |  |  |  |
| addedby | int | NO |  |  |  |

## `viamed_suggest_qa`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| stock_ref | varchar(24) | NO |  |  |  |
| updatedon | bigint | NO |  | 0 |  |
| updatedby | varchar(32) | NO |  |  |  |
| reason | varchar(32) | NO |  |  |  |
| shelfid | int | NO |  |  |  |
| alerttypeid | int | NO |  |  |  |

## `viamed_supplier_product_types`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| account | varchar(24) | NO |  |  |  |
| description | longtext | NO |  |  |  |
| updatedby | int | NO |  |  |  |
| updatedon | bigint | NO |  | 0 |  |
| listonscope | tinyint | NO |  |  |  |

## `viamed_supplier_sales`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| groupcode | varchar(32) | NO |  |  |  |
| tag | varchar(128) | NO |  |  |  |
| month | int | NO |  |  |  |
| year | int | NO |  |  |  |
| sales | float | NO |  |  |  |
| company | varchar(64) | NO |  |  |  |
| region | varchar(16) | NO |  |  |  |
| territory | varchar(16) | NO |  |  |  |

## `viamed_swot`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| addedby | int | NO |  |  |  |
| addedon | bigint | NO |  | 0 |  |
| swottype | int | NO |  |  |  |
| subject | varchar(125) | NO |  |  |  |
| notes | longtext | NO |  |  |  |
| counternotes | longtext | NO |  |  |  |
| polarity | int | NO |  |  |  |
| issueid | int | NO |  |  |  |
| companyid | int | NO |  |  |  |
| stock_ref | varchar(12) | NO |  |  |  |

## `viamed_swot_userread`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| swotid | int | NO |  |  |  |
| userid | int | NO |  |  |  |
| addedon | int | NO |  |  |  |

## `viamed_sync_tables`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| tablename | varchar(64) | NO |  |  |  |
| allowsync | int | NO |  |  |  |
| synctype | int | NO |  |  |  |

## `viamed_timecard_log`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| cardid | varchar(8) | NO |  |  |  |
| direction | varchar(12) | NO |  |  |  |
| location | varchar(12) | NO |  |  |  |
| time | bigint | NO |  | 0 |  |
| timetext | varchar(128) | NO |  |  |  |
| employeeid | int | NO |  |  |  |
| building | int | NO |  |  |  |

## `viamed_toorderlist`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| account | varchar(12) | NO |  |  |  |
| stock_ref | varchar(24) | NO |  |  |  |
| suppref | varchar(48) | NO |  |  |  |
| qty | int | NO |  |  |  |
| addedby | int | NO |  |  |  |
| addedon | bigint | NO |  | 0 |  |
| status | bigint | NO |  | 0 |  |
| printedby | int | NO |  |  |  |
| memo | longtext | NO |  |  |  |

## `viamed_tradeins`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| addedby | varchar(64) | NO |  |  |  |
| addedon | bigint | NO |  | 0 |  |
| notes | longtext | NO |  |  |  |
| status | varchar(32) | NO |  |  |  |
| completedby | varchar(64) | NO |  |  |  |
| completedon | bigint | NO |  | 0 |  |
| company | varchar(128) | NO |  |  |  |
| name | varchar(128) | NO |  |  |  |
| customer_id | int | NO |  |  |  |

## `viamed_uk_sales_map`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| user | varchar(32) | NO |  |  |  |
| account | varchar(12) | NO |  |  |  |
| color | varchar(7) | NO |  |  |  |
| bright | int | NO |  |  |  |
| rad | int | NO |  |  |  |

## `viamed_update_log`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| universaltime | int | NO |  |  |  |
| status | varchar(32) | NO |  |  |  |
| identifer | varchar(32) | NO |  |  |  |

## `viamed_updater`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| updatefile | varchar(56) | NO |  |  |  |
| description | varchar(128) | NO |  |  |  |
| nextid | int | NO |  |  |  |
| timer | int | NO |  |  |  |
| lastused | bigint | NO |  | 0 |  |
| pythonuse | varchar(1) | NO |  |  |  |
| pythonfile | varchar(250) | NO |  |  |  |
| pytimer | int | NO |  |  |  |
| pylastused | int | NO |  |  |  |
| repeateachtime | int | NO |  |  |  |

## `viamed_ups_extrarates_area`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| postcode | varchar(12) | NO |  |  |  |

## `viamed_ups_invoices`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| Account_Number | varchar(32) | NO |  |  |  |
| Invoice_Number | varchar(32) | NO |  |  |  |
| Invoice_date | varchar(12) | NO |  |  |  |
| Amount_Due | float(10,2) | NO |  |  |  |
| Shipment_Number | varchar(16) | NO |  |  |  |
| Collection_Record | varchar(16) | NO |  |  |  |
| Reference_No1 | varchar(16) | NO |  |  |  |
| Reference_No2 | varchar(16) | NO |  |  |  |
| Reference_No3 | varchar(16) | NO |  |  |  |
| Weight1 | float(10,2) | NO |  |  |  |
| Weight2 | float(10,2) | NO |  |  |  |
| Zone | varchar(8) | NO |  |  |  |
| Service_Level | varchar(32) | NO |  |  |  |
| Collection_Date | varchar(12) | NO |  |  |  |
| Sender_Name | varchar(32) | NO |  |  |  |
| Sender_Company_Name | varchar(32) | NO |  |  |  |
| Sender_Address_1 | varchar(32) | NO |  |  |  |
| Sender_Country | varchar(32) | NO |  |  |  |
| Receiver_Name | varchar(32) | NO |  |  |  |
| Receiver_Company_Name | varchar(32) | NO |  |  |  |
| Receiver_Address_1 | varchar(32) | NO |  |  |  |
| Receiver_Country | varchar(32) | NO |  |  |  |
| Third_Party | varchar(32) | NO |  |  |  |
| Net_Charges | float(10,2) | NO |  |  |  |
| Basic_Tier_Discount | float(10,2) | NO |  |  |  |
| Invoice_Section | varchar(32) | NO |  |  |  |
| Invoice_Type | varchar(32) | NO |  |  |  |
| Invoice_Due_date | varchar(32) | NO |  |  |  |

## `viamed_ups_packagetypes`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| packcode | varchar(5) | NO |  |  |  |
| description | varchar(64) | NO |  |  |  |
| notes | longtext | NO |  |  |  |

## `viamed_ups_rates`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| type | varchar(32) | NO |  |  |  |
| weight | float | NO |  | 0 |  |
| zone | char(8) | NO |  |  |  |
| cost | double | NO |  | 0 |  |
| lastudatedby | int | NO |  |  |  |
| lastupdatedon | bigint | NO |  | 0 |  |

## `viamed_ups_shipment_history`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| date | varchar(12) | NO |  |  |  |
| destination | varchar(128) | NO |  |  |  |
| destination_code | varchar(4) | NO |  |  |  |
| tracking_number | varchar(32) | NO |  |  |  |
| status | varchar(24) | NO |  |  |  |
| ref1 | varchar(24) | NO |  |  |  |
| ref2 | varchar(24) | NO |  |  |  |
| confirmedarrivedby | int | NO |  |  |  |
| confirmedarrivedon | int | NO |  |  |  |

## `viamed_ups_surcharges`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| description | varchar(42) | NO |  |  |  |
| percent | float | NO |  | 0 |  |
| carrier | char(3) | NO |  |  |  |

## `viamed_ups_type_opera`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| type | varchar(64) | NO |  |  |  |
| opera | varchar(16) | NO |  |  |  |
| addedby | int | NO |  |  |  |
| addedon | int | NO |  |  |  |

## `viamed_ups_zones`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| customercountry | varchar(32) | NO |  |  |  |
| IATA | varchar(4) | NO |  |  |  |
| targetcountry | varchar(64) | NO |  |  |  |
| postcode1 | varchar(16) | NO |  |  |  |
| postcode2 | varchar(16) | NO |  |  |  |
| sending_expressplus | char(3) | NO |  |  |  |
| sending_express | char(3) | NO |  |  |  |
| sending_expresssaver | char(3) | NO |  |  |  |
| sending_standard | char(3) | NO |  |  |  |
| sending_expedited | char(3) | NO |  |  |  |
| sending_express_freight | char(3) | NO |  |  |  |
| rec_expressplus | char(3) | NO |  |  |  |
| rec_express | char(3) | NO |  |  |  |
| rec_expresssaver | char(3) | NO |  |  |  |
| rec_standard | char(3) | NO |  |  |  |
| rec_expedited | char(3) | NO |  |  |  |
| rec_express_freight | char(3) | NO |  |  |  |
| opera_territory | varchar(64) | NO |  |  |  |

## `viamed_vat_returns`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| box1 | float(10,2) | NO |  |  |  |
| box2 | float(10,2) | NO |  |  |  |
| box3 | float(10,2) | NO |  |  |  |
| box4 | float(10,2) | NO |  |  |  |
| box5 | float(10,2) | NO |  |  |  |
| box6 | float(10,2) | NO |  |  |  |
| box7 | float(10,2) | NO |  |  |  |
| box8 | float(10,2) | NO |  |  |  |
| box9 | float(10,2) | NO |  |  |  |
| senton | int | NO |  |  |  |
| sentby | int | NO |  |  |  |
| companyid | int | NO |  |  |  |
| year | int | NO |  |  |  |
| qtr | int | NO |  |  |  |
| month | int | NO |  |  |  |
| report | int | NO |  |  |  |
| addedby | int | NO |  |  |  |
| addedon | bigint | NO |  | 0 |  |

## `viamed_web_sync`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| account | varchar(16) | NO |  |  |  |

## `viamed_xref`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| stock_ref | varchar(124) | NO |  |  |  |
| oem | varchar(64) | NO |  |  |  |
| oem_pn | varchar(128) | NO |  |  |  |
| type | varchar(64) | NO |  |  |  |
| verified | varchar(64) | NO |  |  |  |
| updatedon | bigint | NO |  | 0 |  |
| updatedby | varchar(64) | NO |  |  |  |
| xrefcode | varchar(128) | NO |  |  |  |
| combined | longtext | NO |  |  |  |
| primary_id | int | NO |  |  |  |
| specsheet_id | int | NO |  |  |  |
| certificatecompatible | varchar(1) | NO |  |  |  |
| rowcolor | varchar(7) | NO |  |  |  |
| hideweb | varchar(7) | NO |  |  |  |
| priorityorder | int | NO |  |  |  |
| importtag | varchar(5) | NO |  |  |  |
| hostcompanyid | int | NO |  |  |  |
| preferedsell | varchar(48) | NO |  |  |  |
| preferedsellby | int | NO |  |  |  |
| preferedsellon | bigint | NO |  |  |  |
| deletestatus | int | NO |  |  |  |
| deletestatuson | bigint | NO |  |  |  |
| deletestatusby | int | NO |  |  |  |
| shopifyhandle | varchar(256) | NO |  |  |  |
| xrefcode_temp | varchar(64) | NO |  |  |  |
| oemclean | varchar(128) | NO |  |  |  |
| cleansearch | varchar(128) | NO |  |  |  |
| imgurl | varchar(200) | NO |  |  |  |
| brand | varchar(255) | NO |  |  |  |

## `viamed_xref_answer`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| answer | varchar(200) | NO |  |  |  |
| xrefcode | varchar(32) | NO |  |  |  |
| fieldid | int | NO |  |  |  |

## `viamed_xref_cat`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| updatedon | bigint | NO |  |  |  |
| updatedby | int | NO |  |  |  |
| xrefcode | varchar(128) | NO |  |  |  |
| description | longtext | NO |  |  |  |
| showonweb | int | NO |  |  |  |
| hostcompanyid | int | NO |  |  |  |
| showfeaturesonweb | tinyint | NO |  |  |  |

## `viamed_xref_cleanlookup`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| clean | varchar(128) | NO |  |  |  |
| dirty | varchar(128) | NO |  |  |  |
| xrefcode | varchar(64) | NO |  |  |  |

## `viamed_xref_fields`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| field_name | varchar(32) | NO |  |  |  |
| xrefcode | varchar(128) | NO |  |  |  |
| displayorder | int | NO |  |  |  |
| addedon | int | NO |  |  |  |
| addedby | bigint | NO |  | 0 |  |
| showweb | int | NO |  |  |  |
| showlocal | int | NO |  |  |  |
| hiddenfield | int | NO |  |  |  |

## `viamed_xref_fields_answers`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| xrefcode | varchar(126) | NO |  |  |  |
| fieldid | int | NO |  |  |  |
| answer | varchar(255) | NO |  |  |  |
| specsheet_id | int | NO |  |  |  |
| setby | int | NO |  |  |  |
| seton | bigint | NO |  | 0 |  |
| stock_ref | varchar(32) | NO |  |  |  |
| addedby | int | NO |  |  |  |
| addedon | int | NO |  |  |  |
| answerid | int | NO |  |  |  |

## `viamed_xref_memos`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| memo | longtext | NO |  |  |  |
| addedby | int | NO |  |  |  |
| addedon | bigint | NO |  | 0 |  |
| rowid | int | NO |  |  |  |

## `viamed_xref_removed`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  |  |
| stock_ref | varchar(124) | NO |  |  |  |
| oem | varchar(64) | NO |  |  |  |
| oem_pn | varchar(128) | NO |  |  |  |
| type | varchar(64) | NO |  |  |  |
| verified | varchar(64) | NO |  |  |  |
| updatedon | varchar(64) | NO |  |  |  |
| updatedby | varchar(64) | NO |  |  |  |
| xrefcode | varchar(64) | NO |  |  |  |
| combined | longtext | NO |  |  |  |
| primaryid | int | NO |  |  |  |

## `viamed_xref_specsheet`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| specsheet | varchar(100) | NO |  |  |  |
| xrefcode | varchar(64) | NO |  |  |  |
| stock_ref | varchar(32) | NO |  |  |  |

## `viamed_xref_specsheet_documents`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| docid | int | NO |  |  |  |
| specsheetid | int | NO |  |  |  |

## `viamed_yearendstocks`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| processtag | varchar(8) | NO |  |  |  |
| yearended | int | NO |  | 0 |  |
| stock_ref | varchar(12) | NO |  |  |  |
| description | varchar(40) | NO |  |  |  |
| anaysiscode | varchar(12) | NO |  |  |  |
| sellprice | float | NO |  | 0 |  |
| costprice | float | NO |  | 0 |  |
| lastcostprice | float | NO |  | 0 |  |
| usecostprice | float | NO |  |  |  |
| quantity | int | NO |  | 0 |  |
| tag | varchar(24) | NO |  |  |  |
| total_value | float | NO |  | 0 |  |
| checked | varchar(10) | NO |  |  |  |
| taxpc | float | NO |  | 0 |  |
| freightpc | float | NO |  | 0 |  |
| finalcost | float(10,2) | NO |  | 0.00 |  |
| finalvalue | float(10,2) | NO |  | 0.00 |  |
| supplierac | varchar(12) | NO |  |  |  |
| liveview | varchar(5) | NO |  |  |  |
| signedoffon | bigint | NO |  | 0 |  |
| signedoffby | int | NO |  |  |  |
| lastsupplieroperaac | varchar(12) | NO |  |  |  |
| hostcompany | int | NO |  |  |  |
| intrastats_qty | int | NO |  |  |  |

## `viamed_yearendstocks_persupplier`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| supplierac | varchar(12) | NO |  |  |  |
| total | varchar(24) | NO |  |  |  |
| year | varchar(5) | NO |  |  |  |

## `viamed_yearendstocksbackup`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| yearended | int | NO |  | 0 |  |
| stock_ref | varchar(12) | NO |  |  |  |
| description | varchar(40) | NO |  |  |  |
| anaysiscode | varchar(12) | NO |  |  |  |
| sellprice | float | NO |  | 0 |  |
| costprice | float | NO |  | 0 |  |
| lastcostprice | float | NO |  | 0 |  |
| usecostprice | float | NO |  |  |  |
| quantity | int | NO |  | 0 |  |
| tag | varchar(12) | NO |  |  |  |
| total_value | float | NO |  | 0 |  |
| checked | varchar(10) | NO |  |  |  |
| taxpc | float | NO |  | 0 |  |
| freightpc | float | NO |  | 0 |  |
| finalcost | float | NO |  | 0 |  |
| finalvalue | float | NO |  | 0 |  |
| supplierac | varchar(12) | NO |  |  |  |

## `viamedagenda`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| mainmeetheader | varchar(100) | NO |  |  |  |
| sectionid | int | NO |  | 0 |  |
| subsectionid | int | NO |  | 0 |  |
| meetingid | int | NO |  | 0 |  |
| heading | varchar(100) | NO |  |  |  |
| lastaddressed | varchar(100) | NO |  |  |  |
| nextdue | varchar(100) | NO |  |  |  |
| urllocation | varchar(100) | NO |  |  |  |
| intrastaturl | varchar(100) | NO |  |  |  |
| instastaturltxt | varchar(100) | NO |  |  |  |
| security | varchar(100) | NO |  |  |  |
| pdf_location | varchar(100) | NO |  |  |  |
| special | varchar(100) | NO |  |  |  |
| status | varchar(5) | NO |  |  |  |
| archivesection | varchar(100) | NO |  |  |  |
| mintimetoaddress | varchar(100) | NO |  |  |  |
| timelapse | varchar(100) | NO |  |  |  |
| searchhead | varchar(200) | NO |  |  |  |
| directorsonly | char(3) | NO |  |  |  |
| companyid | int | NO |  |  |  |
| objective | longtext | NO |  |  |  |
| manrev | int | NO |  |  |  |

## `viamedagenda_events_log`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| eventtypeid | int | NO |  |  |  |
| eventtime | bigint | NO |  |  |  |
| eventuser | int | NO |  |  |  |
| addedon | bigint | NO |  |  |  |
| addedby | int | NO |  |  |  |
| memo | longtext | NO |  |  |  |
| hostcompanyid | int | NO |  |  |  |
| issueid | int | NO |  |  |  |
| timeis | time | NO |  |  |  |
| marketingindexsubtype | int | NO |  |  |  |
| companyid | int | NO |  |  |  |
| contactid | int | NO |  |  |  |
| completed | bigint | NO |  |  |  |
| defaultaction | varchar(6) | NO |  |  |  |
| completedby | int | NO |  |  |  |

## `viamedagenda_events_log_history`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| eventtypeid | int | NO |  |  |  |
| eventtime | bigint | NO |  |  |  |
| eventuser | int | NO |  |  |  |
| addedon | bigint | NO |  |  |  |
| addedby | int | NO |  |  |  |
| memo | longtext | NO |  |  |  |
| hostcompanyid | int | NO |  |  |  |
| issueid | int | NO |  |  |  |
| timeis | time | NO |  |  |  |
| marketingindexsubtype | int | NO |  |  |  |
| companyid | int | NO |  |  |  |
| contactid | int | NO |  |  |  |
| completed | bigint | NO |  |  |  |
| defaultaction | varchar(6) | NO |  |  |  |
| completedby | int | NO |  |  |  |
| historydate | bigint | NO |  |  |  |
| eventid | int | NO |  |  |  |

## `viamedagenda_events_types`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| description | varchar(250) | NO |  |  |  |
| hostcompanyid | int | NO |  |  |  |
| securitylevel | int | NO |  |  |  |
| archived | int | NO |  |  |  |
| code | varchar(32) | NO |  |  |  |

## `viamedagenda_events_users`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| userid | int | NO |  |  |  |
| eventid | int | NO |  |  |  |
| addedby | int | NO |  |  |  |
| addedon | bigint | NO |  | 0 |  |
| status | int | NO |  |  |  |
| hostcompanyid | int | NO |  |  |  |

## `viamedagenda_filterlink`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| filterid | int | NO |  |  |  |
| issueid | int | NO |  |  |  |
| userid | int | NO |  |  |  |
| marketingid | int | NO |  |  |  |

## `viamedagenda_iso_actions`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| agendaid | int | NO |  |  |  |
| addedby | int | NO |  |  |  |
| addedon | bigint | NO |  | 0 |  |
| actionid | int | NO |  |  |  |

## `viamedagenda_iso_actions_lists`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| isoactionid | int | NO |  |  |  |
| description | varchar(228) | NO |  |  |  |
| displayorder | int | NO |  |  |  |

## `viamedagenda_iso_actions_log`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| actionlistid | int | NO |  |  |  |
| updatedby | int | NO |  |  |  |
| updatedon | bigint | NO |  | 0 |  |
| status | int | NO |  |  |  |
| issueid | int | NO |  |  |  |
| callid | int | NO |  |  |  |

## `viamedagenda_issuextra`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| userid | int | NO |  |  |  |
| issueid | int | NO |  |  |  |
| duedate | int | NO |  |  |  |
| deadline | int | NO |  |  |  |
| estimetocomplete | int | NO |  |  |  |

## `viamedagenda_mylists`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| issueid | int | NO |  |  |  |
| userid | int | NO |  |  |  |
| recordorder | int | NO |  | 99999 |  |
| filterid | int | NO |  |  |  |

## `viamedagenda_newnotes`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| issueid | int | NO |  |  |  |
| userid | int | NO |  |  |  |
| prenotes | longtext | NO |  |  |  |
| accountdebtor | varchar(16) | NO |  |  |  |

## `viamedagenda_reviewlogs`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| agendaid | int | NO |  |  |  |
| reviewedby | int | NO |  |  |  |
| reviewedon | bigint | NO |  |  |  |

## `viamedagenda_status`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| issueid | int | NO |  |  |  |
| status | varchar(128) | NO |  |  |  |
| addedon | bigint | NO |  |  |  |
| addedby | int | NO |  |  |  |

## `viamedagenda_user_filters`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| user_id | int | NO |  |  |  |
| description | varchar(32) | NO |  |  |  |
| active | varchar(1) | NO |  |  |  |
| icon | varchar(16) | NO |  |  |  |
| disporder | int | NO |  |  |  |
| showstatus | int | NO |  |  |  |
| tempstatus | int | NO |  |  |  |
| shortcode | varchar(4) | NO |  |  |  |
| backcol | varchar(12) | NO |  |  |  |
| textcol | varchar(12) | NO |  |  |  |

## `viamedagendafuture`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| usergroupid | int | NO |  |  |  |
| live_date | varchar(12) | NO |  |  |  |
| type | varchar(12) | NO |  |  |  |
| subject | varchar(250) | NO |  |  |  |
| notes | longtext | NO |  |  |  |
| target_user | varchar(24) | NO |  |  |  |
| file_id | varchar(12) | NO |  |  |  |
| recur_time_months | int | NO |  | 0 |  |
| agenda_header | int | NO |  | 0 |  |
| agenda_section | int | NO |  | 0 |  |
| set_by | varchar(24) | NO |  |  |  |
| set_on | varchar(12) | NO |  |  |  |
| special | varchar(12) | NO |  |  |  |
| recur_time_weeks | int | NO |  |  |  |
| recur_time_days | int | NO |  |  |  |
| employeeid | int | NO |  |  |  |
| appearfromuser | varchar(84) | NO |  |  |  |
| crm_companyid | int | NO |  |  |  |
| rotateusers | int | NO |  |  |  |
| rotationlast | int | NO |  |  |  |
| mon | int | NO |  |  |  |
| tue | int | NO |  |  |  |
| wed | int | NO |  |  |  |
| thu | int | NO |  |  |  |
| fri | int | NO |  |  |  |
| mainCompanyid | int | NO |  |  |  |
| primaryaudit | tinyint | NO |  |  |  |
| deadline_date | varchar(100) | NO |  |  |  |
| icanprelinkissues | int | NO |  |  |  |

## `viamedagendafuture_logs`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| autoid | int | NO |  |  |  |
| issueid | int | NO |  |  |  |
| issuedon | int | NO |  |  |  |
| issuedto | int | NO |  |  |  |

## `viamedagendafuturetypes`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| type | varchar(16) | NO |  |  |  |

## `viamedagendahistory`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| agendid | varchar(100) | NO |  |  |  |
| subject | varchar(200) | NO |  |  |  |
| notes | longtext | NO |  |  |  |
| completionnotes | longtext | NO |  |  |  |
| backorderstatus | varchar(64) | NO |  |  |  |
| chaired | varchar(100) | NO |  |  |  |
| investigateby | varchar(100) | NO |  |  |  |
| investigatedcomplete | bigint | NO |  |  |  |
| investigatenotes | longtext | NO |  |  |  |
| completed | varchar(100) | NO |  |  |  |
| resoleved | varchar(100) | NO |  |  |  |
| resultnotes | longtext | NO |  |  |  |
| createdate | bigint | NO |  |  |  |
| createpresent | varchar(100) | NO |  |  |  |
| completepresent | varchar(100) | NO |  |  |  |
| completedate | bigint | NO |  |  |  |
| createmeetingdate | bigint | NO |  |  |  |
| stock_ref | varchar(16) | NO |  |  |  |
| opera | varchar(10) | NO |  |  |  |
| porref | varchar(10) | NO |  |  |  |
| porreq | varchar(100) | NO |  |  |  |
| testfield | varchar(100) | NO |  |  |  |
| modified | varchar(100) | NO |  |  |  |
| Order_number | varchar(100) | NO |  |  |  |
| complete_pdf_location | varchar(100) | NO |  |  |  |
| showdueon | varchar(100) | NO |  |  |  |
| repeatduenext | varchar(100) | NO |  |  |  |
| viewed | varchar(10) | NO |  |  |  |
| user_highlight | char(3) | NO |  |  |  |
| deadline_date | varchar(100) | NO |  |  |  |
| hide_until | bigint | NO |  |  |  |
| priority | int | NO |  | 0 |  |
| historytrackid | varchar(100) | NO |  |  |  |
| updatetag | varchar(12) | NO |  |  |  |
| previous_issue | int | NO |  | 0 |  |
| stock_ref_tag | varchar(128) | NO |  |  |  |
| opera_tag | varchar(16) | NO |  |  |  |
| primary_issue | int | NO |  | 0 |  |
| hideupdates | char(2) | NO |  |  |  |
| informationonly | char(2) | NO |  |  |  |
| viamedquotecompanyid | int | NO |  |  |  |
-e 
## viamedquotestatus
## `viamedquotestatus`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| customer_id | varchar(100) | NO |  |  |  |
| quoteref | varchar(50) | NO |  |  |  |
| rep_id | varchar(100) | NO |  |  |  |
| rasiedby | varchar(50) | NO |  |  |  |
| account | varchar(50) | NO |  |  |  |
| contact | varchar(50) | NO |  |  |  |
| title | varchar(50) | NO |  |  |  |
| position | varchar(50) | NO |  |  |  |
| department | varchar(50) | NO |  |  |  |
| address1 | varchar(50) | NO |  |  |  |
| address2 | varchar(50) | NO |  |  |  |
| address3 | varchar(50) | NO |  |  |  |
| city | varchar(50) | NO |  |  |  |
| county | varchar(50) | NO |  |  |  |
| country | varchar(50) | NO |  |  |  |
| postcode | varchar(50) | NO |  |  |  |
| addresstel | varchar(50) | NO |  |  |  |
| directtel | varchar(50) | NO |  |  |  |
| fax | varchar(50) | NO |  |  |  |
| email | varchar(50) | NO |  |  |  |
| timestampraised | bigint | NO |  | 0 |  |
| status | varchar(24) | NO |  |  |  |
| emailrep | char(1) | NO |  |  |  |
| emailtl | char(1) | NO |  |  |  |
| emailgoldmine | char(1) | NO |  |  |  |
| emailcustomer | char(1) | NO |  |  |  |
| emailfake | char(1) | NO |  |  |  |
| timestampsent | bigint | NO |  | 0 |  |
| timeorderraised | int | NO |  | 0 |  |
| memo | longtext | NO |  |  |  |
| reminderflag | varchar(100) | NO |  |  |  |
| reminder | varchar(100) | NO |  |  |  |
| company | varchar(254) | NO |  |  |  |
| company_id | int | NO |  |  |  |
| updatedate | bigint | NO |  | 0 |  |
| mailid | int | NO |  |  |  |
| marketingindexid | int | NO |  |  |  |
| callid | int | NO |  |  |  |
| marketingindexstageid | int | NO |  |  |  |
| visittag | int | NO |  |  |  |
| irrequest | int | NO |  |  |  |

-e 
## backorders2
## `backorders2`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| Order_number | varchar(100) | NO |  |  |  |
| Account | varchar(100) | NO |  |  |  |
| Stock_ref | varchar(100) | NO |  |  |  |
| Description | varchar(100) | NO |  |  |  |
| Qty | varchar(100) | NO |  |  |  |
| Qty_Invoiced | varchar(100) | NO |  |  |  |
| Cust_ref | varchar(100) | NO |  |  |  |
| Priority | varchar(100) | NO |  |  |  |
| Due | varchar(100) | NO |  |  |  |
| Item_Price | float | NO |  |  |  |
| Customername | varchar(128) | NO |  |  |  |
| Customerref | varchar(128) | NO |  |  |  |
| Order_priority | int | NO |  |  |  |
| Forward_Order | int | NO |  |  |  |
| Quotenum | varchar(16) | NO |  |  |  |
| companyid | varchar(16) | NO |  |  |  |
| importedate | bigint | NO |  |  |  |
| amending | int | NO |  |  |  |
| linevalue | varchar(32) | NO |  |  |  |
| coll | varchar(7) | NO |  |  |  |
| hostcompany | int | NO |  |  |  |
| errorcode | int | NO |  |  |  |
| orderid | int | NO |  |  |  |
| orderlineid | int | NO |  |  |  |

-e 
## ISO_quality_manual_files
## `ISO_quality_manual_files`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| addedby | varchar(100) | NO |  |  |  |
| addedon | bigint | NO |  |  |  |
| docid | int | NO |  |  |  |
| docname | varchar(100) | NO |  |  |  |
| description | varchar(254) | NO |  |  |  |
| type | varchar(100) | NO |  |  |  |
| security | varchar(100) | NO |  |  |  |
| oldid | varchar(100) | NO |  |  |  |
| archived | varchar(100) | NO |  |  |  |
| update_reason | longtext | NO |  |  |  |
| filename | varchar(100) | NO |  |  |  |
| removedby | varchar(64) | NO |  |  |  |
| removedon | varchar(64) | NO |  |  |  |
| exp_date | bigint | NO |  | 0 |  |
| reviewed_date | bigint | NO |  | 0 |  |
| reviewed_by | varchar(64) | NO |  |  |  |
| thumb_nail | varchar(24) | NO |  |  |  |
| pages | int | NO |  | 0 |  |
| link_code | varchar(12) | NO |  |  |  |
| companyid | varchar(32) | NO |  |  |  |
| review_timer | bigint | NO |  |  |  |
| md5hash | varchar(255) | NO |  |  |  |
| isostandard | varchar(1) | NO |  |  |  |
| downloadname | varchar(124) | NO |  |  |  |
| pdftext | longtext | NO |  |  |  |
| serialbarcode | int | NO |  |  |  |
| srsnumber | varchar(16) | NO |  |  |  |
| srnnumber | varchar(16) | NO |  |  |  |
| exp_date_ignore | int | NO |  |  |  |
| searchextra | longtext | NO |  |  |  |
| hostcompany | int | NO |  |  |  |
| documentexplain | longtext | NO |  |  |  |
| draftdocument | int | NO |  |  |  |
| draftupdatetodocid | int | NO |  |  |  |
| draftrevision | int | NO |  |  |  |
| sornumber | int | NO |  |  |  |
| interestedparty | int | NO |  |  |  |
| qualitymanual | int | NO |  |  |  |
| qualitymanualprimaryid | int | NO |  |  |  |
| primaryaudit | varchar(3) | NO |  |  |  |
| primarycop | int | NO |  |  |  |
| revisionconrtol | varchar(64) | NO |  |  |  |
| essencialreq | tinyint | NO |  |  |  |
| porref | varchar(24) | NO |  |  |  |
| salesorderid | int | NO |  |  |  |
| purchaseorderid | int | NO |  |  |  |
| pricelistcode | varchar(12) | NO |  |  |  |
| riskassesmentdocid | int | NO |  |  |  |
| alarmexpire | int | NO |  |  |  |
| alarmexpireuser | int | NO |  |  |  |
| alarmdate | bigint | NO |  |  |  |
| scope | longtext | NO |  |  |  |
| hsearealink | int | NO |  |  |  |
| employeeid | int | NO |  |  |  |
| external_revision_ref | varchar(128) | NO |  |  |  |
| contactdontchase | tinyint | NO |  |  |  |
| contactdontchaseby | int | NO |  |  |  |
| contactdontchaseon | bigint | NO |  |  |  |
| downloadcount | int | NO |  |  |  |
| AI_reviewedon | bigint | NO |  |  |  |
| AI_raw | longtext | NO |  |  |  |
| AI_status | int | NO |  |  |  |
| AI_conversationid | int | YES |  | NULL |  |
| AI_fileid | int | YES |  | NULL |  |
| AI_summary | longtext | NO |  |  |  |
| AI_summary_status | int | NO |  | 0 |  |
| returnboxid | int | NO |  |  |  |

-e 
## global_companys
## `global_companys`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| name | varchar(64) | NO |  |  |  |
| fullname | varchar(64) | NO |  |  |  |
| add1 | varchar(64) | NO |  |  |  |
| add2 | varchar(64) | NO |  |  |  |
| add3 | varchar(64) | NO |  |  |  |
| add4 | varchar(64) | NO |  |  |  |
| postcode | varchar(64) | NO |  |  |  |
| country | varchar(128) | NO |  |  |  |
| tel | varchar(64) | NO |  |  |  |
| fax | varchar(64) | NO |  |  |  |
| email | varchar(64) | NO |  |  |  |
| stockcountdate | bigint | NO |  | 0 |  |
| operadocs | varchar(250) | NO |  |  |  |
| isodocs | varchar(250) | NO |  |  |  |
| isodocthumbs | varchar(250) | NO |  |  |  |
| privacymode | int | NO |  |  |  |
| docidlogo | int | NO |  |  |  |
| website | varchar(250) | NO |  |  |  |
| commrate | float(10,2) | NO |  |  |  |
| shippcharge | float(10,2) | NO |  |  |  |
| fixedcharge | float(10,2) | NO |  |  |  |
| vatrate | float(10,2) | NO |  |  |  |
| debtorsdone | int | NO |  |  |  |
| vatcode | varchar(16) | NO |  |  |  |
| bankaccountnumber | varchar(24) | NO |  |  |  |
| active | int | NO |  |  |  |
| termsandconditionslocation | varchar(200) | NO |  |  |  |
| bankname | varchar(64) | NO |  |  |  |
| banksortcode | varchar(12) | NO |  |  |  |
| bankaccount | varchar(24) | NO |  |  |  |
| bankiban | varchar(64) | NO |  |  |  |
| bankbic | varchar(32) | NO |  |  |  |
| templatecode | varchar(16) | NO |  |  |  |
| prefix | varchar(4) | NO |  |  |  |
| sendinvoicefromemail | varchar(100) | NO |  |  |  |
| companyregistrationnumber | varchar(128) | NO |  |  |  |
| accountsemail | varchar(128) | NO |  |  |  |
| accountsnameforinvoiceemail | varchar(64) | NO |  |  |  |
| feedbacklink | varchar(128) | NO |  |  |  |
| eori | varchar(36) | NO |  |  |  |
| insurancetrigger | int | NO |  |  |  |
| UTR | varchar(20) | NO |  |  |  |
| website_files | varchar(250) | NO |  |  |  |
| govgatewayid | varchar(16) | NO |  |  |  |
| govgatewaypw | varchar(32) | NO |  |  |  |
| gmaillogin | varchar(128) | NO |  |  |  |
| gmailcode_encrypted | varbinary(255) | YES |  |  |  |

-e 
## pw_companys
## `pw_companys`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| vui | int | NO |  |  |  |
| company_id | int | NO |  |  |  |
| addedon | bigint | NO |  |  |  |
| addedby | int | NO |  |  |  |
| adminmode | int | NO |  |  |  |
| useremail | varchar(128) | NO |  |  |  |
| purchaseorder | tinyint | NO |  |  |  |
| commitquote | tinyint | NO |  |  |  |
| passwordemail | varchar(64) | NO |  |  |  |
| updatestock | tinyint | NO |  |  |  |
| updatedocument | tinyint | NO |  |  |  |
| updatestaff | tinyint | NO |  |  |  |
| updatexref | tinyint | NO |  |  |  |
| updatecountryrules | int | NO |  |  |  |
| movestock | tinyint | NO |  |  |  |
| updatexero | tinyint | NO |  |  |  |
| quickpick | tinyint | NO |  |  |  |

## `pw_emailsignitures`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| hostcompanyid | int | NO |  |  |  |
| employeeid | int | NO |  |  |  |
| signiture | longtext | NO |  |  |  |
| updatedby | int | NO |  |  |  |
| updatedon | bigint | NO |  |  |  |

## `pw_extras`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| userid | int | NO |  |  |  |
| signature | longtext | NO |  |  |  |
| email | varchar(255) | NO |  |  |  |

## `pw_feedback`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| vui | int | NO |  |  |  |
| notes | longtext | NO |  |  |  |
| addedon | bigint | NO |  | 0 |  |
| addedby | int | NO |  |  |  |

## `pw_titles`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| title | varchar(128) | NO |  |  |  |
| hse | varchar(5) | NO |  |  |  |
| job | varchar(5) | NO |  |  |  |

## `pw_updated`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| updatedby | int | NO |  |  |  |
| updatedon | bigint | NO |  |  |  |
| action | varchar(16) | NO |  |  |  |
| empid | int | NO |  |  |  |

## `qasensor`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| ip | varchar(100) | NO |  |  |  |
| n | varchar(24) | NO |  |  |  |

## `qasensor_limits`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| stkref | varchar(24) | NO |  |  |  |
| lowlimit | float(10,2) | NO |  |  |  |
| highlimit | float(10,2) | NO |  |  |  |
| setby | int | NO |  |  |  |
| seton | bigint | NO |  | 0 |  |
| usepressure | tinyint(1) | NO |  |  |  |

## `remote_sync`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  |  |
| vui | int | NO |  |  |  |
| tablename | varchar(128) | NO |  |  |  |

## `repair_reviews`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| stockref | varchar(24) | NO |  |  |  |
| reviewedby | int | NO |  |  |  |
| reviewedon | int | NO |  |  |  |

## `requestwarehouse`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| requesting | varchar(120) | NO |  |  |  |
| quantity | varchar(16) | NO |  |  |  |
| name | varchar(30) | NO |  |  |  |
| status | varchar(100) | NO |  |  |  |
| type | varchar(30) | NO |  |  |  |
| date | bigint | NO |  | 0 |  |
| dateremoved | bigint | NO |  | 0 |  |
| urgent | char(1) | NO |  |  |  |
| name2 | varchar(64) | NO |  |  |  |
| priority | int | NO |  | 0 |  |
| costeach | varchar(100) | NO |  |  |  |
| supplierpn | varchar(100) | NO |  |  |  |
| suppliername | varchar(100) | NO |  |  |  |
| worksheet | longtext | NO |  |  |  |
| memo | longtext | NO |  |  |  |
| completedby | int | NO |  |  |  |
| qacleared | bigint | NO |  | 0 |  |
| qaby | int | NO |  |  |  |
| nonurgent | varchar(10) | NO |  |  |  |
| labourallocateby | int | NO |  |  |  |
| labourallocateon | bigint | NO |  | 0 |  |
| dateupdated | bigint | NO |  |  |  |
| dateremovedby | int | NO |  |  |  |
| dateupdatedby | int | NO |  |  |  |

## `reqwarehouse`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| Subject | varchar(120) | NO |  |  |  |
| notes | text | YES |  |  |  |
| daterequested | date | YES |  |  |  |
| datecompleted | date | NO |  | 0000-00-00 |  |
| state | varchar(8) | NO |  |  |  |

## `royalmail`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| Country | varchar(128) | NO |  |  |  |
| TrackedSigned | int | NO |  |  |  |
| Tracked | int | NO |  |  |  |
| Signed | int | NO |  |  |  |
| ParcelReturns | int | NO |  |  |  |

## `sales_groups`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| groupid | int | NO |  |  |  |
| groupdesc | varchar(100) | NO |  |  |  |
| operaaccount | varchar(100) | NO |  |  |  |
| owner | varchar(32) | NO |  |  |  |
| tag | varchar(12) | NO |  |  |  |
| status | varchar(12) | NO |  |  |  |
| company_id | int | NO |  |  |  |
| addedon | bigint | NO |  |  |  |
| addedby | int | NO |  |  |  |

## `sendaheart`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| sento | int | NO |  |  |  |
| sentby | int | NO |  |  |  |
| senton | bigint | NO |  | 0 |  |
| img | varchar(30) | NO |  |  |  |

## `sensorsearch`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| verified | varchar(30) | NO |  |  |  |
| id | int | NO | PRI |  | auto_increment |
| oemsearch | varchar(100) | NO |  |  |  |
| Stock_ref | varchar(30) | NO |  |  |  |
| oemstockref | varchar(100) | NO |  |  |  |
| oemmodel | varchar(100) | NO |  |  |  |
| oemcompany | varchar(100) | NO |  |  |  |
| publicview | char(3) | NO |  |  |  |

## `serialnumber_answer2_form`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| Stock_ref | varchar(16) | NO |  |  |  |
| form | varchar(32) | NO |  |  |  |

## `serialnumber_answerid_oldanswer`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| oldanswer | varchar(100) | NO |  |  |  |
| answerid | int | NO |  |  |  |
| newanswer | varchar(100) | NO |  |  |  |
| updatedby | int | NO |  |  |  |
| updatedon | bigint | NO |  | 0 |  |

## `serialnumber_answers`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | bigint | NO | PRI |  | auto_increment |
| questionid | varchar(100) | NO |  |  |  |
| question_type | varchar(100) | NO |  |  |  |
| stock_ref | varchar(100) | NO |  |  |  |
| barcode | varchar(100) | NO |  |  |  |
| date_created | bigint | NO |  |  |  |
| created_by | varchar(100) | NO |  |  |  |
| answer | longtext | NO |  |  |  |
| pass_fail | varchar(100) | NO |  |  |  |
| srnnumber | varchar(32) | NO |  |  |  |
| certificatenumber | bigint | NO |  | 0 |  |
| ercheck | tinyint | NO |  |  |  |

## `serialnumber_answers_blob`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| answerid | varchar(100) | NO |  |  |  |
| blb | longtext | NO |  |  |  |

## `serialnumber_answers_options`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| questionid | int | NO |  |  |  |
| addedby | int | NO |  |  |  |
| addedon | bigint | NO |  |  |  |
| optiontext | varchar(200) | NO |  |  |  |
| optionvalue | varchar(200) | NO |  |  |  |
| active | tinyint | NO |  |  |  |
| displayorder | int | NO |  |  |  |

## `serialnumber_bulkmerge`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| mainid | int | NO |  |  |  |
| mergedid | int | NO |  |  |  |
| addedon | bigint | NO |  |  |  |
| addedby | int | NO |  |  |  |
| status | int | NO |  |  |  |
| stockref | varchar(128) | NO |  |  |  |

## `serialnumber_endyearcounted`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| stock_ref | varchar(100) | NO |  |  |  |
| addedon | int | YES |  |  |  |
| addedby | int | YES |  |  |  |
| hostcompanyid | int | NO |  |  |  |
| barcode | int | NO |  |  |  |
| serialnumber | varchar(64) | NO |  |  |  |
| dateinstock | int | NO |  |  |  |

## `serialnumber_lables`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| tag | varchar(250) | NO |  |  |  |
| shortdesc | varchar(64) | NO |  |  |  |
| longdesc | longtext | NO |  |  |  |
| urlpage | varchar(64) | NO |  |  |  |
| printer | varchar(25) | NO |  |  |  |
| backgroundimg | varchar(32) | NO |  |  |  |
| startx | float | NO |  |  |  |
| starty | float | NO |  |  |  |
| imagesizex | float | NO |  |  |  |
| imagesizey | float | NO |  |  |  |
| docid | int | NO |  |  |  |
| addedon | bigint | NO |  | 0 |  |
| addedby | int | NO |  |  |  |
| totop | int | NO |  |  |  |
| offsetx | float(10,2) | NO |  |  |  |
| offsety | float(10,2) | NO |  |  |  |
| active | int | NO |  |  |  |
| numberacross | int | NO |  |  |  |
| printername | varchar(16) | NO |  |  |  |
| goodoutlabel | int | NO |  |  |  |

## `serialnumber_lables_fields`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| label_id | int | NO |  |  |  |
| dataname | varchar(64) | NO |  |  |  |
| datafield | varchar(64) | NO |  |  |  |
| rotation | int | NO |  |  |  |
| barcode | int | NO |  |  |  |
| positionx | int | NO |  |  |  |
| positiony | int | NO |  |  |  |
| size | int | NO |  |  |  |
| tablename | varchar(250) | NO |  |  |  |
| fieldname | varchar(250) | NO |  |  |  |

## `serialnumber_lables_history`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| labelid | int | NO |  |  |  |
| fieldname | varchar(200) | NO |  |  |  |
| oldanswer | longtext | NO |  |  |  |
| updatedby | int | NO |  |  |  |
| updatedon | bigint | NO |  |  |  |
| extrafieldid | int | NO |  |  |  |

## `serialnumber_movements`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| serialid | varchar(100) | NO |  |  |  |
| oldloc | varchar(100) | NO |  |  |  |
| newloc | varchar(100) | NO |  |  |  |
| movedon | bigint | NO |  | 0 |  |
| movedby | varchar(100) | NO |  |  |  |
| Stock_ref | varchar(100) | NO |  |  |  |

## `serialnumber_questions`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| status | varchar(100) | NO |  |  |  |
| id | int | NO | PRI |  | auto_increment |
| question_text | varchar(100) | NO |  |  |  |
| question_type | varchar(100) | NO |  |  |  |
| stock_ref | varchar(100) | NO |  |  |  |
| special_function | varchar(100) | NO |  |  |  |
| added_by | varchar(100) | NO |  |  |  |
| added_on | varchar(100) | NO |  |  |  |
| question_order | int | NO |  |  |  |
| default_answer | longtext | NO |  |  |  |
| questionorder | int | NO |  |  |  |
| summarypages | varchar(1) | NO |  |  |  |
| logchanges | int | NO |  |  |  |
| repeatans | int | NO |  |  |  |
| accesskey | varchar(1) | NO |  |  |  |
| question_text_long | longtext | NO |  |  |  |

## `serialnumber_questions_old`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| status | varchar(100) | NO |  |  |  |
| id | int | NO | PRI |  | auto_increment |
| original_id | int | NO |  |  |  |
| question_text | varchar(100) | NO |  |  |  |
| question_type | varchar(100) | NO |  |  |  |
| stock_ref | varchar(100) | NO |  |  |  |
| special_function | varchar(100) | NO |  |  |  |
| added_by | varchar(100) | NO |  |  |  |
| added_on | varchar(100) | NO |  |  |  |
| question_order | int | NO |  |  |  |
| default_answer | longtext | NO |  |  |  |
| questionorder | int | NO |  |  |  |
| summarypages | varchar(1) | NO |  |  |  |
| datereplaced | bigint | NO |  | 0 |  |
| limit1 | float(2,1) | NO |  |  |  |

## `serialnumber_recalllist`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| uiq | varchar(5) | NO |  |  |  |
| user | varchar(32) | NO |  |  |  |
| stock_ref | varchar(12) | NO |  |  |  |
| account | varchar(12) | NO |  |  |  |
| barcode | varchar(16) | NO |  |  |  |
| serialnumber | varchar(32) | NO |  |  |  |
| Invoice | varchar(16) | NO |  |  |  |
| DateInvoice | varchar(16) | NO |  |  |  |
| custname | varchar(64) | NO |  |  |  |
| srn | varchar(64) | NO |  |  |  |
| rma | varchar(64) | NO |  |  |  |

## `serialnumber_special_qa`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| stock_ref | varchar(16) | NO |  |  |  |
| lowmv | float(10,2) | NO |  |  |  |
| highmv | float(10,2) | NO |  |  |  |
| passid | int | NO |  |  |  |
| outputid | int | NO |  |  |  |

## `serialnumberbatch`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| serialid | varchar(100) | NO |  |  |  |

## `serialnumberhistory`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| serialnumber | varchar(100) | NO |  |  |  |
| barcodeid | varchar(100) | NO |  |  |  |
| stock_ref | varchar(100) | NO |  |  |  |
| invoicenumber | varchar(100) | NO |  |  |  |
| creditnumber | varchar(100) | NO |  |  |  |
| deliveryaccount | varchar(100) | NO |  |  |  |
| invoiceaccount | varchar(100) | NO |  |  |  |

## `serialnumberlocation`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| photo2 | varchar(100) | NO |  |  |  |
| photo1 | varchar(100) | NO |  |  |  |
| id | int | NO | PRI |  | auto_increment |
| locationid | int | NO |  |  |  |
| room | varchar(100) | NO |  |  |  |
| building | varchar(100) | NO |  |  |  |
| lastupdartedby | varchar(100) | NO |  |  |  |
| lastupdated | varchar(100) | NO |  |  |  |
| locationdescription | varchar(100) | NO |  |  |  |
| sellable | varchar(7) | NO |  |  |  |
| consigned | varchar(1) | NO |  |  |  |
| consign_description | varchar(128) | NO |  |  |  |
| auditedby | varchar(32) | NO |  |  |  |
| auditedon | int | NO |  |  |  |
| building_id | int | NO |  |  |  |
| room_id | int | NO |  |  |  |
| shelf_id | int | NO |  |  |  |
| block_id | int | NO |  |  |  |
| row_id | int | NO |  |  |  |
| reservedforaccount | varchar(8) | NO |  |  |  |
| res_stkref | varchar(24) | NO |  |  |  |
| res_stkqty | int | NO |  |  |  |
| res_stkacc | varchar(12) | NO |  |  |  |
| includeincount | int | NO |  |  |  |
| showbell | int | NO |  |  |  |

## `serialnumberlocation_stock_alerts`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| stock_ref | varchar(24) | NO |  |  |  |
| locationid | int | NO |  |  |  |
| addedby | varchar(32) | NO |  |  |  |
| addedon | bigint | NO |  | 0 |  |
| qty_alarm1 | int | NO |  |  |  |
| qty_alarm2 | int | NO |  |  |  |
| qty_rec | int | NO |  |  |  |
| alerttypeid | int | NO |  |  |  |

## `serialnumberlocation_stock_alerts_types`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| description | varchar(64) | NO |  |  |  |
| addedby | int | NO |  |  |  |
| addedon | bigint | NO |  | 0 |  |

## `serialnumberlocation_types`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| type | varchar(12) | NO |  |  |  |
| description | varchar(64) | NO |  |  |  |

## `serialnumbermergeitems`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| user | varchar(100) | NO |  |  |  |
| mainid | varchar(100) | NO |  |  |  |
| serialid | varchar(100) | NO |  |  |  |
| addedby | int | NO |  |  |  |
| Stock_ref | varchar(40) | NO |  |  |  |
| OperaDescription | varchar(60) | NO |  |  |  |
| Serialnumber | varchar(24) | NO |  |  |  |
| addedon | int | NO |  |  |  |
| hostcompanyid | int | NO |  |  |  |

## `serialnumberminstock`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| stock_ref | varchar(100) | NO |  |  |  |
| locationid | varchar(100) | NO |  |  |  |
| minstock | varchar(100) | NO |  |  |  |
| minmove | varchar(100) | NO |  |  |  |

## `serialnumbermultipack`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| stock_ref | varchar(100) | NO |  |  |  |
| operaqty | varchar(100) | NO |  |  |  |
| Alt_stock_ref | varchar(100) | NO |  |  |  |
| unique_serialnumbers | varchar(100) | NO |  |  |  |

## `serialnumberpicked`

| Field | Type | Null | Key | Default | Extra |
|-------|------|------|-----|---------|-------|
| id | int | NO | PRI |  | auto_increment |
| stock_ref | varchar(100) | NO |  |  |  |
| serialnumberid | int | NO |  |  |  |
| pickedby | varchar(100) | NO |  |  |  |
| pickedon | bigint | NO |  | 0 |  |
| ordernumber | varchar(100) | NO |  |  |  |
| matchedon | bigint | NO |  | 0 |  |
| status | varchar(100) | NO |  |  |  |
| deliverynoteref | varchar(12) | NO |  |  |  |
| serialnumber | varchar(100) | NO |  |  |  |
| deliverynumber | int | NO |  |  |  |
| lineid | int | NO |  |  |  |

