import csv

# Filenames
shopify_file = "sourcefile.csv"
photos_file = "photofile.csv"
output_file = "ready_for_upload_no_title.csv"

# Helper: Get column index by header name
def get_col_indices(headers, names):
    return [headers.index(name) if name in headers else None for name in names]

# Step 1: Build SKU-to-photos lookup from supplier file
sku_to_photos = {}
with open(photos_file, newline='', encoding='utf-8') as f:
    reader = csv.reader(f)
    photo_headers = next(reader)
    sku_col, photo1_col, photo2_col, photo3_col = get_col_indices(
        photo_headers, ["Viamed Part Number", "Photograph 1", "Photograph 2", "Photograph 3"]
    )
    for row in reader:
        sku = row[sku_col].strip()
        photos = [row[i].strip() for i in (photo1_col, photo2_col, photo3_col) if i is not None and row[i].strip()]
        if photos:
            sku_to_photos[sku] = photos

# Step 2: Process Shopify CSV and write output
with open(shopify_file, newline='', encoding='utf-8') as infile, \
     open(output_file, 'w', newline='', encoding='utf-8') as outfile:
    reader = csv.reader(infile)
    writer = csv.writer(outfile)

    headers = next(reader)
    writer.writerow(headers)

    # Get key column indices
    handle_idx, title_idx, sku_idx = get_col_indices(headers, ["Handle", "Title", "Variant SKU"])
    img_src_idx, img_pos_idx = get_col_indices(headers, ["Image Src", "Image Position"])

    for row in reader:
        # Write original row
        writer.writerow(row)

        # Prepare to match SKU (remove leading "'")
        sku_value = row[sku_idx].lstrip("'").strip()
        if sku_value in sku_to_photos:
            for pos, photo_url in enumerate(sku_to_photos[sku_value], 2):
                new_row = [''] * len(headers)
                # Copy key fields
                new_row[handle_idx] = row[handle_idx]
                new_row[title_idx] = ""  # Leave Title blank for new image rows
                new_row[sku_idx] = ""  # Leave Variant SKU blank for new image rows
                # Set image fields
                new_row[img_src_idx] = photo_url
                new_row[img_pos_idx] = str(pos)
                writer.writerow(new_row)