    #include <ESP8266WiFi.h>
    #include <ESP8266WiFiMulti.h> 
    #include <ESP8266mDNS.h>
    #include <ESP8266WebServer.h>   // Include the WebServer library
    #include <WiFiManager.h>
    #include <ArduinoOTA.h>
    #include <WiFiUdp.h>
#include <Arduino.h>
#include <U8g2lib.h>

#ifdef U8X8_HAVE_HW_SPI
#include <SPI.h>
#endif
#ifdef U8X8_HAVE_HW_I2C
#include <Wire.h>
#endif
const int buttonPin = D7;     // the number of the pushbutton pin
int buttonState = 0; 
const int analogInPin = A0; 
int readvalue =0;
char ipchar[16];
// Wifi Setup Stuff
ESP8266WiFiMulti wifiMulti;     // Create an instance of the ESP8266WiFiMulti class, called 'wifiMulti'
ESP8266WebServer server(80);    // Create a webserver object that listens for HTTP request on port 80
void handleRoot();              // function prototypes for HTTP handlers
void handleNotFound();
String Authcode="OledDisplay";
char MyNameIs[16]="UFOTester";
String Message = "";


int stage=4;
int updatemode=0;
unsigned long myTime;
U8G2_SSD1306_128X64_NONAME_F_SW_I2C u8g2(U8G2_R0, /* clock=*/ SCL, /* data=*/ SDA, /* reset=*/ U8X8_PIN_NONE);   // All Boards without Reset of the Display

#define NUMBERREADINGS 5000
int readings[NUMBERREADINGS] ;
int numberreadings=0;
int totalreadingsvalue=0; 



void setup() {
  u8g2.begin();
  Initdisplay();
  pinMode(buttonPin, INPUT);

  // wifi stuff
  Serial.begin(115200);         // Start the Serial communication to send messages to the computer
  delay(10);

  WiFiManager wifiManager;
  wifiManager.autoConnect(MyNameIs);
  
  
  Serial.println("Connecting ...");
  int i = 0;
  while (wifiMulti.run() != WL_CONNECTED) { // Wait for the Wi-Fi to connect: scan for Wi-Fi networks, and connect to the strongest of the networks above
    delay(250);
    //Serial.print('.');
  }
  Serial.println('\n');
  Serial.print("Connected to ");
  Serial.println(WiFi.SSID());              // Tell us what network we're connected to
  Serial.print("IP address:\t");
  Serial.println(WiFi.localIP());           // Send the IP address of the ESP8266 to the computer

  if (MDNS.begin("esp8266")) {              // Start the mDNS responder for esp8266.local
    //Serial.println("mDNS responder started");
  } else {
    //Serial.println("Error setting up MDNS responder!");
  }

  server.on("/", handleRoot);               // Call the 'handleRoot' function when a client requests URI "/"
  server.onNotFound(handleNotFound);        // When a client requests an unknown URI (i.e. something other than "/"), call function "handleNotFound"
  server.begin();                           // Actually start the server
  //Serial.println("HTTP server started");

  
  ArduinoOTA.setHostname(MyNameIs);
    ArduinoOTA.onStart([]() {
    String type;
    if (ArduinoOTA.getCommand() == U_FLASH) {
      type = "sketch";
    } else { // U_SPIFFS
      type = "filesystem";
    }

    // NOTE: if updating SPIFFS this would be the place to unmount SPIFFS using SPIFFS.end()
    Serial.println("Start updating " + type);
  });
  ArduinoOTA.onEnd([]() {
    Serial.println("\nEnd");
  });
  ArduinoOTA.onProgress([](unsigned int progress, unsigned int total) {
    Serial.printf("Progress: %u%%\r", (progress / (total / 100)));
  });
  ArduinoOTA.onError([](ota_error_t error) {
    Serial.printf("Error[%u]: ", error);
    if (error == OTA_AUTH_ERROR) {
      Serial.println("Auth Failed");
    } else if (error == OTA_BEGIN_ERROR) {
      Serial.println("Begin Failed");
    } else if (error == OTA_CONNECT_ERROR) {
      Serial.println("Connect Failed");
    } else if (error == OTA_RECEIVE_ERROR) {
      Serial.println("Receive Failed");
    } else if (error == OTA_END_ERROR) {
      Serial.println("End Failed");
    }
  });
  ArduinoOTA.begin();
  Serial.println("Ready for update");
  Serial.print("IP address: ");
  Serial.println(WiFi.localIP());
  IpDisplay();
  initialisereadins();
}

void loop() {
   buttonState = digitalRead(buttonPin);
   if (buttonState == LOW and stage==4) {
    stage=0;
   } else {
    
   }
ArduinoOTA.handle();
 // Listen for HTTP requests from clients
server.handleClient();
if (updatemode==1) {
  ArduinoOTA.handle();
  SystemUpdateMode();

} else {
  // In Waiting for Sensor Mode
  switch (stage) {
      case 0:
        waitingsensor();
        if (get_reading() > 150) {
          stage=1;
        }
        break;
      case 1:
        holdsensorstill();
        stage=2;
        break;
      case 2:
        get_baseline();
        break;
      case 3:
        break;
      case 4:
        TakeReading();
        break;
      default:
        stage=0;
        break;
  }

  if (get_reading() < 150 and stage!=4) {
    stage=0;
  }
}


                    
}// end of loop

void get_baseline() {
    int baseline=0;
    int upperlimit=0;
    int lowerlimit=0;
    int currentreading=0;
    int failhigh=0;
    int faillow=0;
    int failhigh2=0;
    int faillow2=0;
    delay(3000);
    calculatebaseline();
    totalreadingsvalue=0;
    for (int i=0; i < NUMBERREADINGS; i++) {
      Serial.println(get_reading());
      totalreadingsvalue=totalreadingsvalue+get_reading();
    }

    gotbaseline();
    baseline=(totalreadingsvalue/NUMBERREADINGS);
    upperlimit=(baseline)+ ((baseline *2.5)/100);
    lowerlimit=(baseline)- ((baseline *2.5)/100);
    Serial.println("Total Reading "+String(totalreadingsvalue));
    Serial.println("Base Line Value "+String(baseline));
    Serial.println("Upper Limit "+String(upperlimit));
    Serial.println("Lower Limit "+String(lowerlimit));
    delay(3000);
    shakesensor();
    for (int i=0; i < NUMBERREADINGS; i++) {
        currentreading=get_reading();
        if (currentreading > upperlimit) {
          failhigh++;
        }
        if (currentreading < lowerlimit) {
          faillow++;
        }
        delay(1);
    }
    
    shakesensor1();
    for (int i=0; i < NUMBERREADINGS; i++) {
         currentreading=get_reading();
        if (currentreading > upperlimit) {
          failhigh2++;
        }
        if (currentreading < lowerlimit) {
          faillow2++;
        }   
        delay(1);
    }   

    Serial.println("Smooth High Readings : "+String(failhigh));
    Serial.println("Smooth Low Readings :"+String(faillow));
    Serial.println("Quicker High Readings : "+String(failhigh2));
    Serial.println("Quicker Low Readings :"+String(faillow2));   

    if (failhigh > 5 or faillow > 5 or failhigh2 > 5 or faillow2 > 5 ) {
      finalresultsfail();
    } else {
      finalresultspass();
    }
    delay(3000);
    stage=4;
}



void finalresultsfail() {
  u8g2.clearBuffer();          // clear the internal memory
  u8g2.setFont(u8g2_font_ncenB08_tr); // choose a suitable font
  u8g2.drawStr(4,20,"Sensor Failed");  // write something to the internal memory
  u8g2.drawStr(4,50,WiFi.localIP().toString().c_str() );
  u8g2.sendBuffer();          // transfer internal memory to the display 
}void finalresultspass() {
  u8g2.clearBuffer();          // clear the internal memory
  u8g2.setFont(u8g2_font_ncenB08_tr); // choose a suitable font
  u8g2.drawStr(4,20,"Sensor Passed");  // write something to the internal memory
  u8g2.drawStr(4,50,WiFi.localIP().toString().c_str() );
  u8g2.sendBuffer();          // transfer internal memory to the display 
}
void finalresults() {
  u8g2.clearBuffer();          // clear the internal memory
  u8g2.setFont(u8g2_font_ncenB08_tr); // choose a suitable font
  u8g2.drawStr(4,20,"Pass / Or Fail");  // write something to the internal memory
  u8g2.drawStr(4,50,WiFi.localIP().toString().c_str() );
  u8g2.sendBuffer();          // transfer internal memory to the display 
}

void shakesensor() {
  u8g2.clearBuffer();          // clear the internal memory
  u8g2.setFont(u8g2_font_ncenB08_tr); // choose a suitable font
  u8g2.drawStr(4,20,"Shake Sensor");  // write something to the internal memory
  u8g2.drawStr(4,30,"Smoothly");  // write something to the internal memory
  u8g2.drawStr(4,50,WiFi.localIP().toString().c_str() );
  u8g2.sendBuffer();          // transfer internal memory to the display 
}

void shakesensor1() {
  u8g2.clearBuffer();          // clear the internal memory
  u8g2.setFont(u8g2_font_ncenB08_tr); // choose a suitable font
  u8g2.drawStr(4,20,"Shake Sensor");  // write something to the internal memory
  u8g2.drawStr(4,30,"Quicker");  // write something to the internal memory
  u8g2.drawStr(4,50,WiFi.localIP().toString().c_str() );
  u8g2.sendBuffer();          // transfer internal memory to the display 
}

void gotbaseline() {
  u8g2.clearBuffer();          // clear the internal memory
  u8g2.setFont(u8g2_font_ncenB08_tr); // choose a suitable font
  u8g2.drawStr(4,20,"Got Baseline");  // write something to the internal memory
  u8g2.drawStr(4,50,WiFi.localIP().toString().c_str() );
  u8g2.sendBuffer();          // transfer internal memory to the display 
}

void calculatebaseline() {
  u8g2.clearBuffer();          // clear the internal memory
  u8g2.setFont(u8g2_font_ncenB08_tr); // choose a suitable font
  u8g2.drawStr(4,20,"Calculating Baseline");  // write something to the internal memory
  u8g2.drawStr(4,50,WiFi.localIP().toString().c_str() );
  u8g2.sendBuffer();          // transfer internal memory to the display 
}

void holdsensorstill() {
  u8g2.clearBuffer();          // clear the internal memory
  u8g2.setFont(u8g2_font_ncenB08_tr); // choose a suitable font
  u8g2.drawStr(4,20,"Hold Sensor Still");  // write something to the internal memory
  //u8g2.drawStr(4,20,"Calculating Baseline");  // write something to the internal memory
  u8g2.drawStr(4,50,WiFi.localIP().toString().c_str() );
  u8g2.sendBuffer();          // transfer internal memory to the display 
}

void waitingsensor() {
  u8g2.clearBuffer();          // clear the internal memory
  u8g2.setFont(u8g2_font_ncenB08_tr); // choose a suitable font
  u8g2.drawStr(4,10,"Waiting Sensor");  // write something to the internal memory
  u8g2.drawStr(4,50,WiFi.localIP().toString().c_str() );
  u8g2.sendBuffer();          // transfer internal memory to the display 
}

int get_reading() {
  int mvoutput = 0;
  readvalue = analogRead(analogInPin);
  mvoutput = (readvalue*3300)/1023;
  return mvoutput;
}

void takemeasurement() {
  enum {BufSize=12}; // If a is short use a smaller number, eg 5 or 6 
  char buf[BufSize];
  u8g2.clearBuffer();          // clear the internal memory
  u8g2.drawStr(4, 10, "Start Test");
  u8g2.sendBuffer();
  for (int i=0;i < NUMBERREADINGS; i++) {
      readvalue = analogRead(analogInPin);
      readings[i] = (readvalue*3300)/1023;
      if ( i % 100 ==0 ) {
      snprintf (buf, BufSize, "%d mV" , readings[i]);
      u8g2.clearBuffer();          // clear the internal memory
      u8g2.drawStr(4, 10, "Testing");
      u8g2.drawStr(4, 20,buf);
      u8g2.sendBuffer();
      
      } else {
        delay(1);
      }
  }
  u8g2.clearBuffer();          // clear the internal memory
  u8g2.drawStr(4, 10, "End Test");
  u8g2.sendBuffer();
}

void initialisereadins() {
    enum {BufSize=12}; // If a is short use a smaller number, eg 5 or 6 
  char buf[BufSize];
  for (int i=0;i < NUMBERREADINGS; i++) {
    readings[i]=i;
    if ( i % 250 ==0 ) {
    snprintf (buf, BufSize, "%d Memory" , i);
    u8g2.clearBuffer();          // clear the internal memory
    u8g2.drawStr(4, 10, "Create Buffer");
    u8g2.drawStr(4, 20, buf);
    u8g2.sendBuffer();          // transfer internal memory to the display 
    Serial.println(i);
    }
  }
}

void outputreadins() {
    enum {BufSize=12}; // If a is short use a smaller number, eg 5 or 6 
  char buf[BufSize];
  for (int i=0;i < NUMBERREADINGS; i++) {
    Serial.println(readings[i]);
    snprintf (buf, BufSize, "%d Memory" , readings[i]);
    u8g2.clearBuffer();          // clear the internal memory
    u8g2.drawStr(4, 10, "Verify Buffer");
    u8g2.drawStr(4, 20, buf);
    u8g2.sendBuffer();          // transfer internal memory to the display 
    
  }
}

void TakeReading() {
    u8g2.clearBuffer();          // clear the internal memory
  u8g2.setFont(u8g2_font_ncenB08_tr); // choose a suitable font
  u8g2.drawStr(4,10,"Reading IS");  // write something to the internal memory
  readvalue=analogRead(analogInPin);
  int val=(readvalue*3300)/1023;
  //Serial.println(readvalue);
  enum {BufSize=9}; // If a is short use a smaller number, eg 5 or 6 
  char buf[BufSize];
  snprintf (buf, BufSize, "%d mV" , val);
  u8g2.drawStr(4, 40, buf);
  snprintf (buf, BufSize, "%d", millis());
  u8g2.drawStr(4, 50, buf);

  u8g2.drawStr(4, 60,WiFi.localIP().toString().c_str() );

  u8g2.sendBuffer();          // transfer internal memory to the display 
}

void OLEDISPLAY(String Messageis) {
  enum {BufSize=16}; // If a is short use a smaller number, eg 5 or 6 
  char buf[BufSize];
  snprintf (buf, BufSize, "%d" , Messageis);
  u8g2.clearBuffer();          // clear the internal memory
  u8g2.setFont(u8g2_font_ncenB08_tr); // choose a suitable font
  u8g2.drawStr(4,10,buf);  // write something to the internal memory
  u8g2.sendBuffer();          // transfer internal memory to the display 
}

void IpDisplay() {
  u8g2.clearBuffer();          // clear the internal memory
  u8g2.setFont(u8g2_font_ncenB08_tr); // choose a suitable font
  u8g2.drawStr(4,10,"CONNECTED");  // write something to the internal memory
  u8g2.drawStr(4, 20,WiFi.localIP().toString().c_str() );
  
  u8g2.sendBuffer();          // transfer internal memory to the display 
}

void SystemUpdateMode() {
  u8g2.clearBuffer();          // clear the internal memory
  u8g2.setFont(u8g2_font_ncenB08_tr); // choose a suitable font
  u8g2.drawStr(4,10,"Waiting Update");  // write something to the internal memory
  u8g2.drawStr(4, 20,WiFi.localIP().toString().c_str() );
  u8g2.sendBuffer();          // transfer internal memory to the display 
}

void Initdisplay() {
  u8g2.clearBuffer();          // clear the internal memory
  u8g2.setFont(u8g2_font_ncenB08_tr); // choose a suitable font
  u8g2.drawStr(4,10,"Searching Wifi");  // write something to the internal memory
  u8g2.drawStr(4,20,"Connect to");  // write something to the internal memory
  u8g2.drawStr(4,30,MyNameIs);  // write something to the internal memory
  u8g2.drawStr(4,40,"http://192.168.4.1/");  // write something to the internal memory
  u8g2.drawStr(4,50,"To Configure");  // write something to the internal memory
  u8g2.sendBuffer();          // transfer internal memory to the display 
}





// WEBSERVER STUFF

void handleRoot() {
 String html = "";
 int argument=0;
 html = "";
  if (server.hasArg("X")) {
    html=html+"Taking Reading?<br>";
    takemeasurement();
    stage=4;
    argument=1;
  }

  if (server.hasArg("R")) {
    html=html+"Existing Reading<br>";
    outputreadins();
    argument=1;
  }

  if (server.hasArg("S")) {
    html=html+"Stage Reset<br>";
    stage=0;
    argument=1;
  }

   if (server.hasArg("U")) {
    html=html+"Entering Update Mode<br>"+WiFi.localIP().toString()+"<br>";
    server.send(200, "text/html", html );   // Send HTTP status 200 (Ok) and send some text to the browser/client
    updatemode=1;
    argument=1;
  } 
   if (server.hasArg("Y")) {
    html=html+"Disabled Update Mode<br>"+WiFi.localIP().toString()+"<br>";
    updatemode=0;
    argument=1;
  } 

    html=html+"<br>Viamed UFO Tester<br>";
    html=html+"<a href=\"http://"+WiFi.localIP().toString()+"/?U=1\">Flash Mode</a></br>";
    html=html+"<a href=\"http://"+WiFi.localIP().toString()+"/?Y=1\">Disable Flash Mode</a></br>";
    html=html+"<a href=\"http://"+WiFi.localIP().toString()+"/?S=0\">Set Stage Zero</a></br>";
    html=html+"<a href=\"http://"+WiFi.localIP().toString()+"/?X=1\">Live Reading</a></br>";
  server.send(200, "text/html", html );   // Send HTTP status 200 (Ok) and send some text to the browser/client
  Serial.println(html);  
} 

void ReadSerial() {
    if (Serial.available() > 0) {
    Message += Serial.readString();
    Serial.print(Message);
  }
}

void handleNotFound(){
  server.send(404, "text/plain", "404: Not found"); // Send HTTP status 404 (Not Found) when there's no handler for the URI in the request
}

void handleUpdate() {
  Serial.print("Update");
  WiFi.mode(WIFI_STA);
  while (true) {
    
  }
  Serial.print("Done?");
}


// END OF FILE
